/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import codechicken.microblock.Saw;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import schmoller.tubes.api.interfaces.ISpecialItemCompare;

public class SpecialShapedRecipe
implements IRecipe {
    public int width;
    public int height;
    public Object[] recipeItems;
    public ItemStack output;
    public boolean canMirror = true;

    public SpecialShapedRecipe(ItemStack output, Object ... definition) {
        this.output = output.func_77946_l();
        String recipe = "";
        int index = 0;
        this.width = 0;
        this.height = 0;
        while (definition[index] instanceof String) {
            String line = (String)definition[index++];
            ++this.height;
            this.width = line.length();
            recipe = recipe + line;
        }
        HashMap<Character, Object> map = new HashMap<Character, Object>();
        while (index < definition.length) {
            Character character = (Character)definition[index];
            Object obj = definition[index + 1];
            if (obj instanceof Item) {
                obj = new ItemStack((Item)obj);
            } else if (obj instanceof Block) {
                obj = new ItemStack((Block)obj);
            } else if (obj instanceof Fluid) {
                obj = new FluidStack((Fluid)obj, 1000);
            } else if (!(obj instanceof String || obj instanceof ItemStack || obj instanceof FluidStack)) {
                throw new IllegalArgumentException("Invalid definition: " + character + " = " + obj);
            }
            map.put(character, obj);
            index += 2;
        }
        this.recipeItems = new Object[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            char c = recipe.charAt(i);
            this.recipeItems[i] = map.get(Character.valueOf(c));
        }
    }

    public SpecialShapedRecipe setCanMirror(boolean canMirror) {
        this.canMirror = canMirror;
        return this;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.checkMatch(inv, i, j, false)) {
                    return true;
                }
                if (!this.canMirror || !this.checkMatch(inv, i, j, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack toMatch;
                ItemStack inSlot;
                Object obj = null;
                if (x >= startX && x < startX + this.width && y >= startY && y < startY + this.height) {
                    obj = mirror ? this.recipeItems[this.width - (x - startX) - 1 + (y - startY) * this.width] : this.recipeItems[x - startX + (y - startY) * this.width];
                }
                if ((inSlot = inv.func_70463_b(x, y)) == null && obj != null || obj == null && inSlot != null) {
                    return false;
                }
                if (obj instanceof ItemStack) {
                    toMatch = (ItemStack)obj;
                    if (toMatch.func_77973_b() instanceof Saw) {
                        if (inSlot.func_77973_b() instanceof Saw) continue;
                        return false;
                    }
                    if (inSlot.func_77973_b() != toMatch.func_77973_b()) {
                        return false;
                    }
                    if (inSlot.func_77960_j() != toMatch.func_77960_j() && toMatch.func_77960_j() != Short.MAX_VALUE) {
                        return false;
                    }
                    if (!(toMatch.func_77973_b() instanceof ISpecialItemCompare) || ((ISpecialItemCompare)toMatch.func_77973_b()).areItemsEqual(inSlot, toMatch)) continue;
                    return false;
                }
                if (obj instanceof String) {
                    ArrayList toMatchAny = OreDictionary.getOres((String)((String)obj));
                    boolean matched = false;
                    for (ItemStack toMatch2 : toMatchAny) {
                        if (inSlot.func_77973_b() != toMatch2.func_77973_b() || inSlot.func_77960_j() != toMatch2.func_77960_j() && toMatch2.func_77960_j() != Short.MAX_VALUE || toMatch2.func_77973_b() instanceof ISpecialItemCompare && !((ISpecialItemCompare)toMatch2.func_77973_b()).areItemsEqual(inSlot, toMatch2)) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    return false;
                }
                if (!(obj instanceof FluidStack)) continue;
                toMatch = (FluidStack)obj;
                FluidStack contained = FluidContainerRegistry.getFluidForFilledItem((ItemStack)inSlot);
                if (contained != null && contained.isFluidStackIdentical((FluidStack)toMatch)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.width * this.height;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }
}

