/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import schmoller.tubes.api.PayloadRegistry;

public abstract class Payload {
    public abstract Object get();

    public abstract int size();

    public abstract void setSize(int var1);

    public abstract int maxSize();

    public abstract void read(NBTTagCompound var1);

    public void write(NBTTagCompound tag) {
        tag.func_74778_a("Type", PayloadRegistry.instance().getPayload(this.getClass()).type);
    }

    public abstract void read(MCDataInput var1);

    public void write(MCDataOutput output) {
        output.writeByte((int)PayloadRegistry.instance().getPayload(this.getClass()).index);
    }

    public static Payload load(NBTTagCompound tag) {
        String typeName = tag.func_74779_i("Type");
        Payload payload = null;
        PayloadRegistry.PayloadType type = PayloadRegistry.instance().getPayload(typeName);
        if (type == null) {
            throw new IllegalArgumentException("Unknown tube payload type " + typeName);
        }
        payload = type.newInstance();
        payload.read(tag);
        return payload;
    }

    public static Payload load(MCDataInput input) {
        short typeId = input.readByte();
        Payload payload = null;
        PayloadRegistry.PayloadType type = PayloadRegistry.instance().getPayload(typeId);
        if (type == null) {
            throw new IllegalArgumentException("Unknown tube payload type " + typeId);
        }
        payload = type.newInstance();
        payload.read(input);
        return payload;
    }

    public abstract Payload copy();

    public abstract boolean isPayloadTypeEqual(Payload var1);

    public abstract boolean isPayloadEqual(Payload var1);

    public boolean canSpawnInWorld() {
        return false;
    }

    public void spawnInWorld(World world, double x, double y, double z, float velX, float velY, float velZ) {
    }
}

