/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.IFluidHandler;
import schmoller.tubes.api.BlockInstance;
import schmoller.tubes.api.interfaces.IInterfaceProvider;
import schmoller.tubes.inventory.providers.CauldronProvider;
import schmoller.tubes.inventory.providers.DoubleChestProvider;
import schmoller.tubes.inventory.providers.FurnaceInventoryProvider;
import schmoller.tubes.inventory.providers.JukeboxProvider;

public class ProviderRegistry {
    private static HashMap<Class<?>, HashMap<Object, IInterfaceProvider>> mProviders = new HashMap();

    public static Object provideFor(Class<?> interfaceClass, Object object) {
        if (object == null) {
            return null;
        }
        HashMap<Object, IInterfaceProvider> providers = mProviders.get(interfaceClass);
        if (providers == null) {
            return null;
        }
        IInterfaceProvider provider = null;
        provider = object instanceof BlockInstance ? providers.get(((BlockInstance)object).getBlock()) : providers.get(object.getClass());
        if (provider != null) {
            return provider.provide(object);
        }
        if (!(object instanceof BlockInstance)) {
            for (Object clazz : providers.keySet()) {
                if (!(clazz instanceof Class) || !((Class)clazz).isAssignableFrom(object.getClass())) continue;
                return providers.get(clazz).provide(object);
            }
        }
        return null;
    }

    public static void registerProvider(Class<?> interfaceClass, Object classOrBlock, IInterfaceProvider provider) {
        if (!(classOrBlock instanceof Class) && !(classOrBlock instanceof Block)) {
            throw new IllegalArgumentException();
        }
        HashMap<Object, IInterfaceProvider<Object>> providers = mProviders.get(interfaceClass);
        if (providers == null) {
            providers = new HashMap();
            mProviders.put(interfaceClass, providers);
        }
        providers.put(classOrBlock, provider);
    }

    static {
        ProviderRegistry.registerProvider(IInventory.class, TileEntityFurnace.class, new FurnaceInventoryProvider());
        ProviderRegistry.registerProvider(IInventory.class, TileEntityChest.class, new DoubleChestProvider());
        ProviderRegistry.registerProvider(IInventory.class, BlockJukebox.TileEntityJukebox.class, new JukeboxProvider());
        ProviderRegistry.registerProvider(IFluidHandler.class, Blocks.field_150383_bp, new CauldronProvider());
    }
}

