/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api.helpers;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.microblock.HollowMicroblock;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.scalatraits.TSlottedTile;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import schmoller.tubes.CompoundList;
import schmoller.tubes.ModTubes;
import schmoller.tubes.api.InteractionHandler;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IPayloadHandler;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.api.interfaces.ITubeConnectable;
import schmoller.tubes.parts.BaseTubePart;

public abstract class BaseTube
extends BaseTubePart
implements ITube {
    private LinkedList<TubeItem> mItemsInTransit = new LinkedList();
    private boolean mIsUpdating = false;
    private LinkedList<TubeItem> mWaitingToAdd = new LinkedList();
    public static int transitTime = 1000;
    public static int blockedWaitTime = 10;
    public static final int CHANNEL_ADDITEM = 0;
    public static final int NO_COLOUR = -1;
    private int mTick = 0;
    public static final int NO_ROUTE = -1;
    public static final int ROUTE_TERM = -2;
    private boolean mDidRoute = false;

    public BaseTube(String type) {
        super(type);
    }

    @Override
    public boolean addItem(Payload item, int fromDir) {
        assert (fromDir >= -1 && fromDir < 6);
        TubeItem tItem = new TubeItem(item);
        if (fromDir == -1) {
            tItem.lastDirection = 6;
            tItem.direction = 6;
            tItem.setProgress(0.5f);
        } else {
            tItem.direction = tItem.lastDirection = fromDir;
            tItem.setProgress(0.0f);
        }
        this.onItemEnter(tItem);
        if (!this.world().field_72995_K) {
            if (this.mIsUpdating) {
                this.mWaitingToAdd.add(tItem);
            } else {
                this.mItemsInTransit.add(tItem);
            }
            if (tItem.direction != 6) {
                this.addToClient(tItem);
            }
        }
        return true;
    }

    @Override
    public boolean addItem(TubeItem item) {
        return this.addItem(item, false);
    }

    @Override
    public boolean addItem(TubeItem item, boolean syncToClient) {
        assert (item.direction >= -1 && item.direction <= 6);
        this.onItemEnter(item);
        if (this.mIsUpdating) {
            this.mWaitingToAdd.add(item);
        } else {
            this.mItemsInTransit.add(item);
        }
        if (syncToClient) {
            this.addToClient(item);
        }
        return true;
    }

    @Override
    public int getColor() {
        return -1;
    }

    @Override
    public boolean canPathThrough() {
        return true;
    }

    @Override
    public int getConnections() {
        return TubeHelper.getConnectivity((IBlockAccess)this.world(), this.x(), this.y(), this.z());
    }

    protected int getNumConnections() {
        int count = 0;
        int con = this.getConnections();
        for (int i = 0; i < 6; ++i) {
            if ((con & 1 << i) == 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final int getConnectableMask() {
        int con = this.getConnectableSides();
        if (this.tile() instanceof TSlottedTile) {
            for (int i = 0; i < 6; ++i) {
                TMultiPart part = this.tile().partMap(i);
                if (!(part instanceof TFacePart) || part instanceof HollowMicroblock) continue;
                con -= con & 1 << i;
            }
        }
        return con;
    }

    private int getNextDirection(TubeItem item) {
        int count = 0;
        int dir = -1;
        this.mDidRoute = false;
        if (this.hasCustomRouting()) {
            if (this.world().field_72995_K) {
                return -2;
            }
            this.mDidRoute = true;
            return this.onDetermineDestination(item);
        }
        int conns = this.getConnections();
        conns -= conns & 1 << (item.direction ^ 1);
        for (int i = 0; i < 6; ++i) {
            if ((conns & 1 << i) == 0) continue;
            ++count;
            dir = i;
        }
        if (count > 1) {
            if (this.world().field_72995_K) {
                return -2;
            }
            if (count > 1) {
                dir = TubeHelper.findNextDirection((IBlockAccess)this.world(), this.x(), this.y(), this.z(), item);
                this.mDidRoute = true;
            }
        }
        return dir;
    }

    @Override
    public int getRouteWeight() {
        return 1;
    }

    public void update() {
        this.mIsUpdating = true;
        Iterator it = this.mItemsInTransit.iterator();
        int tickNo = ModTubes.instance.getCurrentTick();
        while (it.hasNext()) {
            TubeItem item = (TubeItem)it.next();
            if (item.tickNo == tickNo) continue;
            item.tickNo = tickNo;
            if (item.direction == 6) {
                if (!this.onItemJunction(item)) {
                    it.remove();
                    continue;
                }
                if (item.direction == 6) continue;
                this.addToClient(item);
            }
            item.lastProgress = item.progress;
            item.progress = (float)((double)item.progress + 0.1 * (double)item.speed);
            if (!item.updated && (double)item.progress >= 0.5 && !this.onItemJunction(item)) {
                it.remove();
                continue;
            }
            if (!(item.progress >= 1.0f)) continue;
            if (this.onItemLeave(item)) {
                it.remove();
                continue;
            }
            item.state = 2;
            item.progress -= 1.0f;
            item.lastProgress -= 1.0f;
            item.updated = false;
            item.direction ^= 1;
            if (this.world().field_72995_K) continue;
            this.addToClient(item);
        }
        this.mItemsInTransit.addAll(this.mWaitingToAdd);
        this.mWaitingToAdd.clear();
        this.mIsUpdating = false;
        int rate = this.getTickRate();
        if (rate > 0) {
            ++this.mTick;
            if (this.mTick >= rate) {
                this.mTick = 0;
                this.onTick();
            }
        }
    }

    @Override
    public List<TubeItem> getItems() {
        if (this.mWaitingToAdd.isEmpty()) {
            return this.mItemsInTransit;
        }
        return new CompoundList<TubeItem>(this.mItemsInTransit, this.mWaitingToAdd);
    }

    private int randDirection(int fromDir) {
        fromDir ^= 1;
        int total = this.getNumConnections();
        if (total <= 1) {
            return fromDir;
        }
        int num = TubeHelper.rand.nextInt(total - 1);
        int index = 0;
        int con = this.getConnections();
        for (int i = 0; i < 6; ++i) {
            if (i == fromDir || (con & 1 << i) == 0) continue;
            if (num == index) {
                return i;
            }
            ++index;
        }
        return fromDir;
    }

    private boolean handleJunction(TubeItem item) {
        int lastDir;
        item.lastDirection = lastDir = item.direction;
        item.direction = this.getNextDirection(item);
        item.updated = true;
        if (item.direction == -1) {
            if (this.getNumConnections() == 1) {
                if (item.direction != 6) {
                    item.direction = lastDir ^ 1;
                }
            } else {
                item.direction = TubeHelper.findNextDirection((IBlockAccess)this.world(), this.x(), this.y(), this.z(), item);
                if (item.direction == -1) {
                    item.direction = this.randDirection(lastDir);
                }
            }
            item.state = 2;
            if (this.getNumConnections() != 1) {
                this.addToClient(item);
            }
        } else {
            if (item.direction == -2) {
                return false;
            }
            if (!this.world().field_72995_K && this.mDidRoute) {
                this.addToClient(item);
            }
        }
        return true;
    }

    protected void addToClient(TubeItem item) {
        if (this.world().field_72995_K) {
            return;
        }
        item.write(this.openChannel(0));
    }

    public void save(NBTTagCompound root) {
        NBTTagList list = new NBTTagList();
        for (TubeItem item : this.mItemsInTransit) {
            NBTTagCompound tag = new NBTTagCompound();
            item.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        root.func_74782_a("items", (NBTBase)list);
    }

    public void load(NBTTagCompound root) {
        this.mItemsInTransit.clear();
        NBTTagList list = root.func_150295_c("items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.mItemsInTransit.add(TubeItem.readFromNBT(tag));
        }
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeShort(this.mItemsInTransit.size());
        for (TubeItem item : this.mItemsInTransit) {
            item.write(packet);
        }
    }

    public void readDesc(MCDataInput packet) {
        int count = packet.readShort() & 0xFFFF;
        this.mItemsInTransit.clear();
        for (int i = 0; i < count; ++i) {
            this.mItemsInTransit.add(TubeItem.read(packet));
        }
    }

    @Override
    protected void onRecieveDataClient(int channel, MCDataInput input) {
        if (channel == 0) {
            this.mItemsInTransit.add(TubeItem.read(input));
        }
        super.onRecieveDataClient(channel, input);
    }

    @Override
    protected void onDropItems(List<ItemStack> itemsToDrop) {
        for (TubeItem item : this.mItemsInTransit) {
            if (!(item.item instanceof ItemPayload)) continue;
            itemsToDrop.add((ItemStack)item.item.get());
        }
    }

    @Override
    public void simulateEffects(TubeItem item) {
    }

    @Override
    public int getRoutableDirections(TubeItem item) {
        return 63;
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        return this.canAddItem(item.item, item.direction);
    }

    @Override
    public boolean canAddItem(Payload item, int direction) {
        return true;
    }

    protected void onItemEnter(TubeItem item) {
    }

    protected boolean onItemLeave(TubeItem item) {
        if (item.direction == 6) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)item.direction);
        TileEntity ent = this.world().func_147438_o(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
        ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
        if (con != null) {
            if (this.world().field_72995_K && !(con instanceof ITube)) {
                return true;
            }
            if (con.canItemEnter(item)) {
                item.progress -= 1.0f;
                item.lastProgress -= 1.0f;
                item.updated = false;
                return con.addItem(item);
            }
            return false;
        }
        if (this.world().field_72995_K) {
            return true;
        }
        IPayloadHandler handler = InteractionHandler.getHandler(item.item.getClass(), (IBlockAccess)this.world(), this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
        if (handler != null) {
            Payload remaining = handler.insert(item.item, item.direction ^ 1, true);
            if (remaining == null) {
                return true;
            }
            item.item = remaining;
        }
        return false;
    }

    protected boolean onItemJunction(TubeItem item) {
        return this.handleJunction(item);
    }

    @Override
    public boolean showInventoryConnection(int side) {
        return false;
    }

    @Override
    public boolean canConnectToInventories() {
        return true;
    }

    @Override
    public boolean canConnectTo(ITubeConnectable con) {
        return true;
    }

    protected int getConnectableSides() {
        return 63;
    }

    protected boolean hasCustomRouting() {
        return false;
    }

    protected int onDetermineDestination(TubeItem item) {
        return -1;
    }

    public int getTickRate() {
        return 0;
    }

    public void onTick() {
    }
}

