/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.inventory;

import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import schmoller.tubes.AnyFilter;
import schmoller.tubes.FluidFilter;
import schmoller.tubes.api.FluidPayload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.IPayloadHandler;

public class BasicFluidHandler
implements IPayloadHandler<FluidPayload> {
    private IFluidHandler mParent;

    public BasicFluidHandler(IFluidHandler parent) {
        this.mParent = parent;
    }

    @Override
    public FluidPayload insert(FluidPayload payload, int side, boolean doAdd) {
        int filled = this.mParent.fill(ForgeDirection.getOrientation((int)side), (FluidStack)payload.get(), doAdd);
        if (filled == payload.size()) {
            return null;
        }
        FluidPayload remaining = payload.copy();
        remaining.setSize(remaining.size() - filled);
        return remaining;
    }

    @Override
    public FluidPayload extract(IFilter template, int side, boolean doExtract) {
        return this.extract(template, side, 1000, SizeMode.Max, doExtract);
    }

    @Override
    public FluidPayload extract(IFilter template, int side, int count, SizeMode mode, boolean doExtract) {
        if (template == null) {
            throw new IllegalArgumentException("Cannot have a null template. Use AnyFilter \"any\"");
        }
        if (template.getPayloadType() != null && !template.getPayloadType().equals(FluidPayload.class)) {
            throw new IllegalArgumentException("Invalid filter type " + template.getType());
        }
        if (doExtract && this.extract(template, side, count, mode, false) == null) {
            return null;
        }
        int amount = count;
        if (mode == SizeMode.Max || mode == SizeMode.GreaterEqual) {
            amount = 1000;
        }
        FluidStack fluid = null;
        fluid = template instanceof AnyFilter ? this.mParent.drain(ForgeDirection.getOrientation((int)side), amount, doExtract) : this.mParent.drain(ForgeDirection.getOrientation((int)side), new FluidStack(((FluidFilter)template).getFluid(), amount), doExtract);
        if (fluid == null) {
            return null;
        }
        if (mode == SizeMode.Exact ? fluid.amount != count : (mode == SizeMode.GreaterEqual ? fluid.amount < count : mode == SizeMode.LessEqual && fluid.amount > count)) {
            return null;
        }
        return new FluidPayload(fluid);
    }

    @Override
    public boolean isSideAccessable(int side) {
        return true;
    }
}

