/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import schmoller.tubes.SpecialShapedRecipe;
import schmoller.tubes.api.interfaces.ISpecialItemCompare;

public class SpecialShapedRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"gui.nei.tubes.shaped");
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"crafting2x2");
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.func_77571_b(), (ItemStack)result) || result.func_77973_b() instanceof ISpecialItemCompare && !((ISpecialItemCompare)result.func_77973_b()).areItemsEqual(recipe.func_77571_b(), result)) continue;
            CachedSpecialShapedRecipe cashed = null;
            if (!(recipe instanceof SpecialShapedRecipe)) continue;
            cashed = new CachedSpecialShapedRecipe((SpecialShapedRecipe)recipe);
            this.arecipes.add(cashed);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof SpecialShapedRecipe)) continue;
            SpecialShapedRecipe sRecipe = (SpecialShapedRecipe)recipe;
            boolean found = false;
            for (Object obj : sRecipe.recipeItems) {
                ItemStack toMatch;
                if (obj instanceof ItemStack) {
                    toMatch = (ItemStack)obj;
                    if (ingredient.func_77973_b() != toMatch.func_77973_b() || ingredient.func_77960_j() != toMatch.func_77960_j() && toMatch.func_77960_j() != Short.MAX_VALUE || toMatch.func_77973_b() instanceof ISpecialItemCompare && !((ISpecialItemCompare)toMatch.func_77973_b()).areItemsEqual(ingredient, toMatch)) {
                        continue;
                    }
                } else if (obj instanceof String) {
                    ArrayList toMatchAny = OreDictionary.getOres((String)((String)obj));
                    boolean matched = false;
                    for (ItemStack toMatch2 : toMatchAny) {
                        if (ingredient.func_77973_b() != toMatch2.func_77973_b() || ingredient.func_77960_j() != toMatch2.func_77960_j() && toMatch2.func_77960_j() != Short.MAX_VALUE || toMatch2.func_77973_b() instanceof ISpecialItemCompare && !((ISpecialItemCompare)toMatch2.func_77973_b()).areItemsEqual(ingredient, toMatch2)) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        continue;
                    }
                } else if (obj instanceof FluidStack) {
                    toMatch = (FluidStack)obj;
                    FluidStack contained = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
                    if (contained == null || !contained.isFluidStackIdentical((FluidStack)toMatch)) {
                        continue;
                    }
                } else if (obj == null) continue;
                found = true;
                break;
            }
            if (!found) continue;
            this.arecipes.add(new CachedSpecialShapedRecipe(sRecipe));
        }
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner((GuiContainer)gui, (String)"crafting2x2");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)"crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public class CachedSpecialShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedSpecialShapedRecipe(SpecialShapedRecipe recipe) {
            super((TemplateRecipeHandler)SpecialShapedRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.output, 119, 24);
            this.result.generatePermutations();
            this.ingredients = new ArrayList();
            for (int x = 0; x < recipe.width; ++x) {
                for (int y = 0; y < recipe.height; ++y) {
                    ArrayList<ItemStack> obj = recipe.recipeItems[y * recipe.width + x];
                    if (obj == null) continue;
                    if (obj instanceof String) {
                        obj = OreDictionary.getOres((String)((String)((Object)obj)));
                    } else if (obj instanceof FluidStack) {
                        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                            if (!data.fluid.isFluidStackIdentical((FluidStack)obj)) continue;
                            items.add(data.filledContainer);
                        }
                        obj = items;
                    }
                    PositionedStack stack = new PositionedStack((Object)obj, 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                    stack.generatePermutations();
                }
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SpecialShapedRecipeHandler.this.cycleticks / 20, this.ingredients);
        }
    }
}

