/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.ModTubes;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.OverflowBuffer;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.interfaces.ITubeOverflowDestination;
import schmoller.tubes.inventory.BasicInvHandler;
import schmoller.tubes.routing.OutputRouter;
import schmoller.tubes.types.DirectionalTube;

public class BufferTube
extends DirectionalTube
implements ISidedInventory,
ITubeOverflowDestination {
    private OverflowBuffer mOverflow = new OverflowBuffer();
    private ItemStack[] mSlots = new ItemStack[9];

    public BufferTube() {
        super("buffer");
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int i) {
        return this.mSlots[i];
    }

    public ItemStack func_70298_a(int i, int amount) {
        if (this.mSlots[i] == null) {
            return null;
        }
        if (this.mSlots[i].field_77994_a <= amount) {
            ItemStack item = this.mSlots[i];
            this.mSlots[i] = null;
            return item;
        }
        return this.mSlots[i].func_77979_a(amount);
    }

    public ItemStack func_70304_b(int i) {
        return this.mSlots[i];
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.mSlots[i] = itemstack;
    }

    public String func_145825_b() {
        return "Buffer Tube";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.x(), (double)this.y(), (double)this.z()) <= 25.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return true;
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    protected int getConnectableSides() {
        return 63;
    }

    @Override
    public int getTickRate() {
        return this.mOverflow.isEmpty() ? 20 : 10;
    }

    @Override
    public void onTick() {
        if (this.world().field_72995_K) {
            return;
        }
        if (!this.mOverflow.isEmpty()) {
            TubeItem item = this.mOverflow.peekNext();
            BaseRouter.PathLocation loc = new OutputRouter((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), item, this.getFacing()).route();
            if (loc != null) {
                this.mOverflow.getNext();
                item.state = 0;
                item.direction = item.lastDirection = this.getFacing();
                item.updated = true;
                item.setProgress(0.5f);
                this.addItem(item, true);
            }
            return;
        }
        for (int i = 0; i < this.mSlots.length; ++i) {
            if (this.mSlots[i] == null) continue;
            TubeItem item = new TubeItem(new ItemPayload(this.mSlots[i]));
            item.direction = item.lastDirection = this.getFacing();
            item.state = 0;
            item.updated = true;
            item.setProgress(0.5f);
            this.addItem(item, true);
            this.mSlots[i] = null;
            break;
        }
    }

    @Override
    public boolean canPathThrough() {
        return false;
    }

    @Override
    public boolean canAcceptOverflowFromSide(int side) {
        return side == (this.getFacing() ^ 1);
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        if (item.direction == (this.getFacing() ^ 1)) {
            return item.state == 2;
        }
        return super.canItemEnter(item);
    }

    @Override
    public boolean canAddItem(Payload item, int direction) {
        if (direction == (this.getFacing() ^ 1)) {
            return false;
        }
        if (!(item instanceof ItemPayload)) {
            return false;
        }
        if (this.world().field_72995_K) {
            return true;
        }
        BasicInvHandler handler = new BasicInvHandler((IInventory)this);
        ItemPayload result = handler.insert((ItemPayload)item, direction ^ 1, false);
        return result == null || result.size() != item.size();
    }

    @Override
    protected boolean onItemJunction(TubeItem item) {
        if (item.direction == (this.getFacing() ^ 1)) {
            if (!this.world().field_72995_K) {
                this.mOverflow.addItem(item);
            }
        } else {
            BasicInvHandler handler = new BasicInvHandler((IInventory)this);
            ItemPayload left = handler.insert((ItemPayload)item.item, item.direction ^ 1, true);
            if (left != null) {
                item.item.setSize(left.size());
                item.direction ^= 1;
                item.state = 2;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (!super.activate(player, part, item)) {
            player.openGui((Object)ModTubes.instance, 5, this.world(), this.x(), this.y(), this.z());
            return true;
        }
        return true;
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        this.mOverflow.save(root);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            if (this.mSlots[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            this.mSlots[i].func_77955_b(tag);
            tag.func_74768_a("Slot", i);
            items.func_74742_a((NBTBase)tag);
        }
        root.func_74782_a("Slots", (NBTBase)items);
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        this.mOverflow.load(root);
        NBTTagList items = root.func_150295_c("Slots", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound tag = items.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            this.mSlots[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    @Override
    protected void onDropItems(List<ItemStack> itemsToDrop) {
        super.onDropItems(itemsToDrop);
        this.mOverflow.onDropItems(itemsToDrop);
        for (int i = 0; i < this.mSlots.length; ++i) {
            if (this.mSlots[i] == null) continue;
            itemsToDrop.add(this.mSlots[i]);
        }
    }
}

