/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.api.ItemPayload;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.InventoryHelper;
import schmoller.tubes.api.helpers.RenderHelper;
import schmoller.tubes.api.interfaces.IFilter;

public class ItemFilter
implements IFilter {
    public static ResourceLocation oreDict = new ResourceLocation("tubes", "textures/gui/oreDictHighlight.png");
    private ItemStack mTemplate;
    private boolean mFuzzy;
    @SideOnly(value=Side.CLIENT)
    private static RenderItem itemRenderer;

    public ItemFilter(ItemStack template, boolean fuzzy) {
        assert (template != null);
        this.mTemplate = template.func_77946_l();
        this.mFuzzy = fuzzy;
    }

    @Override
    public String getType() {
        return "item";
    }

    @Override
    public Class<? extends Payload> getPayloadType() {
        return ItemPayload.class;
    }

    public ItemStack getItem() {
        return this.mTemplate;
    }

    public void toggleFuzzy() {
        this.mFuzzy = !this.mFuzzy;
    }

    @Override
    public boolean matches(Payload payload, SizeMode mode) {
        int id;
        if (!(payload instanceof ItemPayload)) {
            return false;
        }
        if (!this.mFuzzy && !InventoryHelper.areItemsEqual((ItemStack)payload.get(), this.mTemplate)) {
            return false;
        }
        if (this.mFuzzy && (id = OreDictionary.getOreID((ItemStack)this.mTemplate)) != OreDictionary.getOreID((ItemStack)((ItemStack)payload.get()))) {
            return false;
        }
        ItemStack other = (ItemStack)payload.get();
        switch (mode) {
            case Exact: {
                return other.field_77994_a == this.mTemplate.field_77994_a;
            }
            case GreaterEqual: {
                return other.field_77994_a >= this.mTemplate.field_77994_a;
            }
            case LessEqual: {
                return other.field_77994_a <= this.mTemplate.field_77994_a;
            }
            case Max: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matches(TubeItem item, SizeMode mode) {
        return this.matches(item.item, mode);
    }

    @Override
    public void increase(boolean useMax, boolean shift) {
        this.mTemplate.field_77994_a = this.mTemplate.field_77994_a + (shift ? 10 : 1);
        if (useMax && this.mTemplate.field_77994_a > this.getMax()) {
            this.mTemplate.field_77994_a = this.getMax();
        }
    }

    @Override
    public void decrease(boolean shift) {
        this.mTemplate.field_77994_a = this.mTemplate.field_77994_a - (shift ? 10 : 1);
        if (this.mTemplate.field_77994_a < 0) {
            this.mTemplate.field_77994_a = 0;
        }
    }

    @Override
    public int getMax() {
        return this.mTemplate.func_77976_d();
    }

    @Override
    public int size() {
        return this.mTemplate.field_77994_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFilter(int x, int y) {
        if (itemRenderer == null) {
            itemRenderer = new RenderItem();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        ItemFilter.itemRenderer.field_77023_b = 20.0f;
        FontRenderer font = this.mTemplate.func_77973_b().getFontRenderer(this.mTemplate);
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        itemRenderer.func_82406_b(font, Minecraft.func_71410_x().func_110434_K(), this.mTemplate, x, y);
        if (this.mFuzzy) {
            int frame = (int)(System.currentTimeMillis() / 50L % 32L);
            float offset = (float)(frame * 1) / 32.0f;
            GL11.glDepthFunc((int)516);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            CCRenderState.changeTexture((ResourceLocation)oreDict);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-50.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)774, (int)774);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderHelper.renderRect(x, y, 16, 16, 0.0f, offset, 1.0f, 0.03125f);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)50.0f);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        itemRenderer.func_94148_a(font, Minecraft.func_71410_x().func_110434_K(), this.mTemplate, x, y, null);
        GL11.glPopMatrix();
        ItemFilter.itemRenderer.field_77023_b = 0.0f;
    }

    @Override
    public void write(NBTTagCompound tag) {
        this.mTemplate.func_77955_b(tag);
        tag.func_74757_a("fuzzy", this.mFuzzy);
    }

    @Override
    public void write(MCDataOutput output) {
        output.writeItemStack(this.mTemplate);
        output.writeBoolean(this.mFuzzy);
    }

    public static ItemFilter from(NBTTagCompound tag) {
        return new ItemFilter(ItemStack.func_77949_a((NBTTagCompound)tag), tag.func_74767_n("fuzzy"));
    }

    public static ItemFilter from(MCDataInput input) {
        return new ItemFilter(input.readItemStack(), input.readBoolean());
    }

    @Override
    public IFilter copy() {
        return new ItemFilter(this.mTemplate, this.mFuzzy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(List<String> current) {
        List list = this.mTemplate.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, this.mTemplate.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        if (this.mFuzzy) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"gui.filter.item.oredict"));
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemFilter)) {
            return false;
        }
        ItemFilter other = (ItemFilter)obj;
        return InventoryHelper.areItemsEqual(this.mTemplate, other.mTemplate) && this.mFuzzy == other.mFuzzy;
    }
}

