/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api;

import com.google.common.base.Throwables;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.client.IPayloadRender;

public class PayloadRegistry {
    private static PayloadRegistry mInstance;
    private HashMap<Class<? extends Payload>, PayloadType> mTypes = new HashMap();
    private HashMap<Short, Class<? extends Payload>> mIdToPayload = new HashMap();
    private HashBiMap<Class<? extends Payload>, String> mPayloadToName = HashBiMap.create();

    private PayloadRegistry() {
    }

    public static PayloadRegistry instance() {
        if (mInstance == null) {
            mInstance = new PayloadRegistry();
        }
        return mInstance;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerPayloadRenderer(String type, IPayloadRender render) {
        assert (render != null);
        PayloadRegistry.instance().getPayload((String)type).render = render;
    }

    public static void registerPayload(Class<? extends Payload> payloadClass, String name, Class<?> interfaceClass) {
        PayloadType type = new PayloadType();
        type.interfaceClass = interfaceClass;
        type.payloadClass = payloadClass;
        type.type = name;
        PayloadRegistry.instance().mTypes.put(payloadClass, type);
        PayloadRegistry.instance().mIdToPayload.put(type.index, payloadClass);
        PayloadRegistry.instance().mPayloadToName.put(payloadClass, (Object)name);
    }

    public PayloadType getPayload(Class<? extends Payload> payloadClass) {
        return this.mTypes.get(payloadClass);
    }

    public PayloadType getPayload(String type) {
        return this.mTypes.get(this.mPayloadToName.inverse().get((Object)type));
    }

    public PayloadType getPayload(short id) {
        return this.mTypes.get(this.mIdToPayload.get(id));
    }

    public Set<Class<? extends Payload>> getPayloadTypes() {
        return Collections.unmodifiableSet(this.mTypes.keySet());
    }

    @SideOnly(value=Side.CLIENT)
    public IPayloadRender getPayloadRender(Class<? extends Payload> payloadClass) {
        return this.mTypes.get(payloadClass).render;
    }

    public static class PayloadType {
        private static short nextIndex = 0;
        public Class<?> payloadClass;
        public String type;
        public Class<?> interfaceClass;
        public IPayloadRender render;
        public short index = 0;

        public PayloadType() {
            short s = nextIndex;
            nextIndex = (short)(s + 1);
            this.index = s;
        }

        public Payload newInstance() {
            try {
                return (Payload)this.payloadClass.newInstance();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

