/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.api.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IRouteCheckCallback;

public abstract class BaseRouter {
    private HashSet<Position> mVisitedLocations = new HashSet();
    private PriorityQueue<PathLocation> mSearchQueue = new PriorityQueue();
    private IBlockAccess mWorld;
    private IRouteCheckCallback mCallback = null;

    public BaseRouter setRouteCheckCallback(IRouteCheckCallback callback) {
        this.mCallback = callback;
        return this;
    }

    protected void setup(IBlockAccess world, Position initialPosition) {
        this.mVisitedLocations.clear();
        this.mSearchQueue.clear();
        this.mWorld = world;
        this.mVisitedLocations.add(initialPosition);
        this.getInitialLocations(initialPosition);
    }

    public IBlockAccess getWorld() {
        return this.mWorld;
    }

    protected void addSearchPoint(PathLocation path) {
        if (this.mVisitedLocations.contains(path.position)) {
            return;
        }
        this.mSearchQueue.add(path);
    }

    protected abstract void getNextLocations(PathLocation var1);

    protected void getInitialLocations(Position position) {
        this.getNextLocations(new PathLocation(position.x, position.y, position.z, 0, 6, 6));
    }

    protected abstract boolean isTerminator(Position var1, int var2);

    private boolean isEndPointOk(Position current, int side) {
        if (this.mCallback != null) {
            return this.mCallback.isEndPointOk(current, side);
        }
        return true;
    }

    public PathLocation route() {
        List<PathLocation> dests = this.routeAll();
        if (dests.isEmpty()) {
            return null;
        }
        return dests.get(TubeHelper.rand.nextInt(dests.size()));
    }

    public List<PathLocation> routeAll() {
        ArrayList<PathLocation> paths = new ArrayList<PathLocation>();
        int shortestPath = Integer.MAX_VALUE;
        while (!this.mSearchQueue.isEmpty()) {
            PathLocation path = this.mSearchQueue.poll();
            if (path.dist > shortestPath) break;
            if (!this.mVisitedLocations.add(path.position)) continue;
            if (this.isTerminator(path.position, path.dir)) {
                if (!this.isEndPointOk(path.position, path.dir)) continue;
                shortestPath = path.dist;
                paths.add(path);
                continue;
            }
            this.getNextLocations(path);
        }
        return paths;
    }

    public static class PathLocation
    implements Comparable<PathLocation> {
        public final Position position;
        public int dist;
        public final int dir;
        public final int initialDir;
        public int color = -1;

        public PathLocation(PathLocation last, int newDir) {
            this.dist = last.dist + 1;
            this.dir = newDir;
            this.initialDir = last.initialDir;
            this.position = last.position.copy().offset(newDir, 1);
            this.color = last.color;
        }

        public PathLocation(Position position, int direction) {
            this.position = position.copy().offset(direction, 1);
            this.dist = 1;
            this.dir = this.initialDir = direction;
        }

        public PathLocation(int x, int y, int z, int dist, int dir, int initialDir) {
            this.position = new Position(x, y, z);
            this.dist = dist;
            this.dir = dir;
            this.initialDir = initialDir;
        }

        @Override
        public int compareTo(PathLocation other) {
            return this.dist - other.dist;
        }

        public String toString() {
            return String.format("{Path: %d, %d, %d: %d initial: %d len: %d col: %d}", this.position.x, this.position.y, this.position.z, this.dir, this.initialDir, this.dist, this.color);
        }
    }
}

