/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.network;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MCDOutputBridge
implements MCDataOutput {
    private ByteBuf mBuffer;

    public MCDOutputBridge(ByteBuf buf) {
        this.mBuffer = buf;
    }

    public MCDataOutput writeBoolean(boolean bool) {
        this.mBuffer.writeBoolean(bool);
        return this;
    }

    public MCDataOutput writeByte(int value) {
        this.mBuffer.writeByte((int)((byte)value));
        return this;
    }

    public MCDataOutput writeByteArray(byte[] array) {
        this.mBuffer.writeBytes(array);
        return this;
    }

    public MCDataOutput writeChar(char ch) {
        this.mBuffer.writeChar((int)ch);
        return this;
    }

    public MCDataOutput writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    public MCDataOutput writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    public MCDataOutput writeDouble(double value) {
        this.mBuffer.writeDouble(value);
        return this;
    }

    public MCDataOutput writeFloat(float value) {
        this.mBuffer.writeFloat(value);
        return this;
    }

    public MCDataOutput writeFluidStack(FluidStack fluid) {
        if (fluid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(fluid.fluidID);
            this.writeInt(fluid.amount);
            this.writeNBTTagCompound(fluid.tag);
        }
        return this;
    }

    public MCDataOutput writeInt(int value) {
        this.mBuffer.writeInt(value);
        return this;
    }

    public MCDataOutput writeItemStack(ItemStack stack) {
        if (stack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            this.writeByte(stack.field_77994_a);
            this.writeShort(stack.func_77960_j());
            this.writeNBTTagCompound(stack.field_77990_d);
        }
        return this;
    }

    public MCDataOutput writeLong(long value) {
        this.mBuffer.writeLong(value);
        return this;
    }

    public MCDataOutput writeNBTTagCompound(NBTTagCompound tag) {
        try {
            if (tag == null) {
                this.writeShort(-1);
            } else {
                byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
                this.writeShort((short)bytes.length);
                this.writeByteArray(bytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public MCDataOutput writeShort(int value) {
        this.mBuffer.writeShort((int)((short)value));
        return this;
    }

    public MCDataOutput writeString(String string) {
        this.mBuffer.writeShort((int)((short)string.length()));
        for (char c : string.toCharArray()) {
            this.mBuffer.writeChar((int)c);
        }
        return this;
    }

    public MCDataOutput writeVarInt(int value) {
        while ((value & 0x80) != 0) {
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte(value);
        return this;
    }

    public MCDataOutput writeVarShort(int value) {
        int low = value & Short.MAX_VALUE;
        int high = (value & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        this.writeShort(low);
        if (high != 0) {
            this.writeByte(high);
        }
        return this;
    }
}

