/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.render;

import codechicken.lib.render.CCRenderState;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.AdvRender;
import schmoller.tubes.api.TubeDefinition;
import schmoller.tubes.api.interfaces.ITube;
import schmoller.tubes.definitions.TypeTankTube;
import schmoller.tubes.render.NormalTubeRender;
import schmoller.tubes.types.TankTube;

public class TankTubeRender
extends NormalTubeRender {
    @Override
    public void renderStatic(TubeDefinition type, ITube tube, World world, int x, int y, int z) {
        int connections = tube.getConnections();
        this.mRender.resetTransform();
        this.mRender.enableNormals = false;
        this.mRender.setLightingFromBlock((IBlockAccess)world, x, y, z);
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetColor();
        this.mRender.faceMode = AdvRender.FaceMode.Both;
        this.mRender.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.mRender.translate(x, y, z);
        this.renderCore(connections, type, -1);
        this.renderConnections(connections, type);
    }

    @Override
    protected void renderCore(int connections, TubeDefinition def, int col) {
        this.mRender.setIcon(TypeTankTube.coreIcon);
        this.mRender.drawBox(~connections & 0x3C, 0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
        this.mRender.setIcon(TypeTankTube.coreOpenIcon);
        this.mRender.drawBox(~connections & 3, 0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
        this.mRender.setIcon(TypeTankTube.coreOpenIcon);
        this.mRender.drawBox(connections, 0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
    }

    @Override
    public void renderDynamic(TubeDefinition type, ITube tube, World world, int x, int y, int z, float frameTime) {
        FluidStack fluid = ((TankTube)tube).getFluid();
        if (fluid != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.mRender.resetTransform();
            this.mRender.enableNormals = false;
            this.mRender.setLightingFromBlock((IBlockAccess)world, x, y, z);
            this.mRender.resetTextureFlip();
            this.mRender.resetTextureRotation();
            this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)z);
            CCRenderState.changeTexture((ResourceLocation)Minecraft.func_71410_x().field_71446_o.func_130087_a(fluid.getFluid().getSpriteNumber()));
            this.mRender.setIcon(fluid.getFluid().getIcon(fluid));
            float amount = (float)fluid.amount / 1000.0f;
            if (amount > 1.0f) {
                amount = 1.0f;
            }
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            this.mRender.drawBox(63, 0.188f, 0.188f, 0.188f, 0.812f, 0.188f + 0.624f * amount, 0.812f);
            tes.func_78381_a();
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
        }
        super.renderDynamic(type, tube, world, x, y, z, frameTime);
    }

    @Override
    public void renderItem(TubeDefinition type, ItemStack item) {
        this.mRender.resetTransform();
        this.mRender.enableNormals = true;
        this.mRender.resetTextureFlip();
        this.mRender.resetTextureRotation();
        this.mRender.resetLighting(0xF000F0);
        this.mRender.faceMode = AdvRender.FaceMode.Normal;
        this.mRender.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        this.renderCore(0, type, -1);
        tes.func_78381_a();
    }
}

