/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.routing;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.AnyFilter;
import schmoller.tubes.api.InteractionHandler;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.IPayloadHandler;
import schmoller.tubes.api.interfaces.ITubeConnectable;

public class ImportSourceFinder
extends BaseRouter {
    private IFilter mItem;
    private int mStartDir;
    private SizeMode mMode;

    public ImportSourceFinder(IBlockAccess world, Position position, int startDirection, IFilter filterItem, SizeMode mode) {
        this.mItem = filterItem;
        this.mStartDir = startDirection;
        this.mMode = mode;
        this.setup(world, position);
    }

    @Override
    protected void getNextLocations(BaseRouter.PathLocation current) {
        int conns = TubeHelper.getConnectivity(this.getWorld(), current.position);
        for (int i = 0; i < 6; ++i) {
            if ((conns & 1 << i) == 0) continue;
            BaseRouter.PathLocation loc = new BaseRouter.PathLocation(current, i);
            TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), loc.position);
            ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
            if (con != null) {
                if (!con.canPathThrough()) continue;
                loc.dist += con.getRouteWeight() - 1;
            }
            this.addSearchPoint(loc);
        }
    }

    @Override
    protected void getInitialLocations(Position position) {
        int conns = TubeHelper.getConnectivity(this.getWorld(), position);
        if ((conns & 1 << this.mStartDir) != 0) {
            BaseRouter.PathLocation loc = new BaseRouter.PathLocation(position, this.mStartDir);
            TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), loc.position);
            ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
            if (con != null) {
                if (!con.canPathThrough()) {
                    return;
                }
                loc.dist += con.getRouteWeight() - 1;
            }
            this.addSearchPoint(loc);
        }
    }

    @Override
    protected boolean isTerminator(Position current, int side) {
        Object extracted;
        IPayloadHandler handler;
        TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), current);
        ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
        return con == null && (handler = InteractionHandler.getHandler(this.mItem == null ? null : this.mItem.getPayloadType(), this.getWorld(), current)) != null && (extracted = this.mItem == null ? handler.extract(new AnyFilter(0), side ^ 1, false) : handler.extract(this.mItem, side ^ 1, this.mItem.size(), this.mMode, false)) != null;
    }
}

