/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.LiquidSetting;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.StackTankHolder;

public class LiquidBufferElement {
    private Setting setting;
    private FlowComponent component;
    private boolean useWhiteList;
    private int currentTransferSize;
    private int totalTransferSize;
    private SlotInventoryHolder inventoryHolder;
    private List<StackTankHolder> holders;
    private int sharedBy;
    private boolean fairShare;
    private int shareId;

    public LiquidBufferElement(FlowComponent owner, Setting setting, SlotInventoryHolder inventoryHolder, boolean useWhiteList, StackTankHolder target) {
        this(owner, setting, inventoryHolder, useWhiteList);
        this.addTarget(target);
        this.sharedBy = 1;
    }

    public LiquidBufferElement(FlowComponent owner, Setting setting, SlotInventoryHolder inventoryHolder, boolean useWhiteList) {
        this.component = owner;
        this.setting = setting;
        this.inventoryHolder = inventoryHolder;
        this.useWhiteList = useWhiteList;
        this.holders = new ArrayList<StackTankHolder>();
    }

    public boolean addTarget(FlowComponent owner, Setting setting, SlotInventoryHolder inventoryHolder, StackTankHolder target) {
        if (this.component.getId() == owner.getId() && (this.setting == null || setting != null && this.setting.getId() == setting.getId()) && (this.inventoryHolder.isShared() || this.inventoryHolder.equals(inventoryHolder))) {
            this.addTarget(target);
            return true;
        }
        return false;
    }

    private void addTarget(StackTankHolder target) {
        this.holders.add(target);
        FluidStack temp = target.getFluidStack();
        if (temp != null) {
            this.totalTransferSize += target.getSizeLeft();
            this.currentTransferSize = this.totalTransferSize;
        }
    }

    public Setting getSetting() {
        return this.setting;
    }

    public List<StackTankHolder> getHolders() {
        return this.holders;
    }

    public int retrieveItemCount(int desiredItemCount) {
        int itemsAllowedToBeMoved;
        if (this.setting == null || !this.setting.isLimitedByAmount()) {
            return desiredItemCount;
        }
        if (this.useWhiteList) {
            int movedItems = this.totalTransferSize - this.currentTransferSize;
            itemsAllowedToBeMoved = this.setting.getAmount() - movedItems;
            int amountLeft = itemsAllowedToBeMoved % this.sharedBy;
            itemsAllowedToBeMoved /= this.sharedBy;
            if (!this.fairShare && this.shareId < amountLeft) {
                ++itemsAllowedToBeMoved;
            }
        } else {
            itemsAllowedToBeMoved = this.currentTransferSize - this.setting.getAmount();
        }
        return Math.min(itemsAllowedToBeMoved, desiredItemCount);
    }

    public void decreaseStackSize(int itemsToMove) {
        this.currentTransferSize -= itemsToMove * (this.useWhiteList ? this.sharedBy : 1);
    }

    public int getBufferSize(Setting outputSetting) {
        int bufferSize = 0;
        for (StackTankHolder holder : this.getHolders()) {
            FluidStack fluidStack = holder.getFluidStack();
            if (fluidStack == null || fluidStack.fluidID != ((LiquidSetting)outputSetting).getLiquidId()) continue;
            bufferSize += fluidStack.amount;
        }
        if (this.setting != null && this.setting.isLimitedByAmount()) {
            int maxSize = this.useWhiteList ? this.setting.getAmount() : this.totalTransferSize - this.setting.getAmount();
            bufferSize = Math.min(bufferSize, maxSize);
        }
        return bufferSize;
    }

    public LiquidBufferElement getSplitElement(int elementAmount, int id, boolean fair) {
        LiquidBufferElement element = new LiquidBufferElement(this.component, this.setting, this.inventoryHolder, this.useWhiteList);
        element.holders = new ArrayList<StackTankHolder>();
        for (StackTankHolder holder : this.holders) {
            element.addTarget(holder.getSplitElement(elementAmount, id, fair));
        }
        if (this.useWhiteList) {
            element.sharedBy = this.sharedBy * elementAmount;
            element.fairShare = fair;
            element.shareId = elementAmount * this.shareId + id;
            element.currentTransferSize -= this.totalTransferSize - this.currentTransferSize;
            if (element.currentTransferSize < 0) {
                element.currentTransferSize = 0;
            }
        } else {
            element.currentTransferSize = Math.min(this.currentTransferSize, element.totalTransferSize);
        }
        return element;
    }
}

