/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.TextBoxLogic;
import vswe.stevesfactory.interfaces.GuiManager;

public abstract class ScrollController<T> {
    private int offset;
    private boolean canScroll;
    private int dir;
    private boolean clicked;
    private boolean selected;
    private TextBoxLogic textBox;
    private List<T> result;
    private boolean hasSearchBox;
    private static final int ITEM_SIZE = 16;
    private static final int ITEM_SIZE_WITH_MARGIN = 20;
    private static final int ARROW_SIZE_W = 10;
    private static final int ARROW_SIZE_H = 6;
    private static final int ARROW_SRC_X = 64;
    private static final int ARROW_SRC_Y = 165;
    private static final int ARROW_X = 105;
    private static final int ARROW_Y_UP = 32;
    private static final int ARROW_Y_DOWN = 42;
    private static final int TEXT_BOX_SIZE_W = 64;
    private static final int TEXT_BOX_SIZE_H = 12;
    private static final int TEXT_BOX_SRC_X = 0;
    private static final int TEXT_BOX_SRC_Y = 165;
    private static final int TEXT_BOX_X = 5;
    private static final int TEXT_BOX_Y = 5;
    private static final int TEXT_BOX_TEXT_X = 3;
    private static final int TEXT_BOX_TEXT_Y = 3;
    private static final int CURSOR_X = 2;
    private static final int CURSOR_Y = 0;
    private static final int CURSOR_Z = 5;
    private static final int AMOUNT_TEXT_X = 75;
    private static final int AMOUNT_TEXT_Y = 9;
    private int itemsPerRow = 5;
    private int visibleRows = 2;
    private int startX = 5;
    private int scrollingUpperLimit = 17;
    private static final int SCROLL_SPEED = 100;
    private float left;

    public ScrollController(boolean hasSearchBox) {
        this(hasSearchBox ? "" : null);
    }

    public ScrollController(String defaultText) {
        boolean bl = this.hasSearchBox = defaultText != null;
        if (this.hasSearchBox) {
            this.textBox = new TextBoxLogic(Integer.MAX_VALUE, 58){

                @Override
                protected void textChanged() {
                    if (this.getText().length() > 0) {
                        ScrollController.this.updateSearch();
                    } else {
                        ScrollController.this.result.clear();
                        ScrollController.this.updateScrolling();
                    }
                }
            };
            this.textBox.setTextAndCursor(defaultText);
        }
        this.updateSearch();
    }

    protected abstract List<T> updateSearch(String var1, boolean var2);

    @SideOnly(value=Side.CLIENT)
    protected abstract void onClick(T var1, int var2, int var3, int var4);

    @SideOnly(value=Side.CLIENT)
    protected abstract void draw(GuiManager var1, T var2, int var3, int var4, boolean var5);

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawMouseOver(GuiManager var1, T var2, int var3, int var4);

    public void setX(int val) {
        this.startX = val;
    }

    public int getScrollingStartX() {
        return this.startX;
    }

    public int getScrollingStartY() {
        return this.scrollingUpperLimit + 3;
    }

    private int getFirstRow() {
        return (this.scrollingUpperLimit + this.offset - this.getScrollingStartY()) / 20;
    }

    private List<Point> getItemCoordinates() {
        int start;
        ArrayList<Point> points = new ArrayList<Point>();
        for (int row = start = this.getFirstRow(); row < start + this.visibleRows + 1; ++row) {
            for (int col = 0; col < this.itemsPerRow; ++col) {
                int y;
                int id = row * this.itemsPerRow + col;
                if (id < 0 || id >= this.result.size() || (y = this.getScrollingStartY() + row * 20 - this.offset) <= this.scrollingUpperLimit || y + 16 >= FlowComponent.getMenuOpenSize()) continue;
                points.add(new Point(id, this.getScrollingStartX() + 20 * col, y));
            }
        }
        return points;
    }

    public void onClick(int mX, int mY, int button) {
        if (CollisionHelper.inBounds(5, 5, 64, 12, mX, mY)) {
            if (button == 0 || !this.selected) {
                this.selected = !this.selected;
            } else if (this.hasSearchBox) {
                this.textBox.setTextAndCursor("");
            }
        }
        List<Point> points = this.getItemCoordinates();
        for (Point point : points) {
            if (!CollisionHelper.inBounds(point.x, point.y, 16, 16, mX, mY)) continue;
            this.onClick(this.result.get(point.id), mX, mY, button);
            break;
        }
        if (this.inArrowBounds(true, mX, mY)) {
            this.clicked = true;
            this.dir = 1;
        } else if (this.inArrowBounds(false, mX, mY)) {
            this.clicked = true;
            this.dir = -1;
        }
    }

    public void onRelease(int mX, int mY) {
        this.clicked = false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.selected && this.hasSearchBox) {
            this.textBox.onKeyStroke(gui, c, k);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        int srcBoxY;
        int n = srcBoxY = this.selected ? 1 : 0;
        if (this.hasSearchBox) {
            gui.drawTexture(5, 5, 0, 165 + srcBoxY * 12, 64, 12);
            gui.drawString(this.textBox.getText(), 8, 8, 0xFFFFFF);
            if (this.selected) {
                gui.drawCursor(5 + this.textBox.getCursorPosition(gui) + 2, 5, 5, -1);
            }
            if (this.textBox.getText().length() > 0 || this.result.size() > 0) {
                gui.drawString(Localization.ITEMS_FOUND.toString() + " " + this.result.size(), 75, 9, 0.7f, 0x404040);
            }
        }
        if (this.result.size() > 0) {
            this.drawArrow(gui, true, mX, mY);
            this.drawArrow(gui, false, mX, mY);
            List<Point> points = this.getItemCoordinates();
            for (Point point : points) {
                this.draw(gui, this.result.get(point.id), point.x, point.y, CollisionHelper.inBounds(point.x, point.y, 16, 16, mX, mY));
            }
        }
    }

    public void update(float partial) {
        if (this.clicked && this.canScroll) {
            int change = (int)((partial += this.left) * 100.0f);
            this.left = partial - (float)change / 100.0f;
            this.moveOffset(change * this.dir);
        }
    }

    private void moveOffset(int change) {
        this.offset += change;
        int min = 0;
        int max = (int)(Math.ceil((float)this.result.size() / (float)this.itemsPerRow) - (double)this.visibleRows) * 20 - 4;
        if (this.offset < min) {
            this.offset = min;
        } else if (this.offset > max) {
            this.offset = max;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawArrow(GuiManager gui, boolean down, int mX, int mY) {
        if (this.canScroll) {
            int srcArrowX = this.canScroll ? (this.clicked && down == (this.dir == 1) ? 2 : (this.inArrowBounds(down, mX, mY) ? 1 : 0)) : 3;
            int srcArrowY = down ? 1 : 0;
            gui.drawTexture(105, down ? 42 : 32, 64 + srcArrowX * 10, 165 + srcArrowY * 6, 10, 6);
        }
    }

    private boolean inArrowBounds(boolean down, int mX, int mY) {
        return CollisionHelper.inBounds(105, down ? 42 : 32, 10, 6, mX, mY);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        List<Point> points = this.getItemCoordinates();
        for (Point point : points) {
            if (!CollisionHelper.inBounds(point.x, point.y, 16, 16, mX, mY)) continue;
            this.drawMouseOver(gui, this.result.get(point.id), mX, mY);
        }
    }

    public void updateScrolling() {
        boolean bl = this.canScroll = this.result.size() > this.itemsPerRow * this.visibleRows;
        if (!this.canScroll) {
            this.offset = 0;
        }
    }

    public void setItemsPerRow(int n) {
        this.itemsPerRow = n;
    }

    public void setVisibleRows(int n) {
        this.visibleRows = n;
    }

    public void setItemUpperLimit(int n) {
        this.scrollingUpperLimit = n;
    }

    public void updateSearch() {
        this.result = this.hasSearchBox ? this.updateSearch(this.textBox.getText().toLowerCase(), this.textBox.getText().toLowerCase().equals(".all")) : this.updateSearch("", false);
        this.updateScrolling();
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setText(String s) {
        this.textBox.setText(s);
        this.updateSearch();
    }

    public String getText() {
        return this.textBox.getText();
    }

    public void setTextAndCursor(String s) {
        this.textBox.setTextAndCursor(s);
    }

    public void doScroll(int scroll) {
        this.moveOffset(scroll / -20);
    }

    private class Point {
        int id;
        int x;
        int y;

        private Point(int id, int x, int y) {
            this.id = id;
            this.x = x;
            this.y = y;
        }
    }
}

