/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.interfaces.GuiAntiNEI;
import vswe.stevesfactory.interfaces.IAdvancedTooltip;
import vswe.stevesfactory.settings.Settings;

@SideOnly(value=Side.CLIENT)
public abstract class GuiBase
extends GuiAntiNEI {
    private static final ResourceLocation TERRAIN = new ResourceLocation("textures/atlas/blocks.png");

    public GuiBase(Container container) {
        super(container);
    }

    public abstract ResourceLocation getComponentResource();

    public void drawTexture(int x, int y, int srcX, int srcY, int w, int h) {
        float scale = this.getScale();
        this.drawScaleFriendlyTexture(this.fixScaledCoordinate(this.guiLeft + x, scale, this.field_146297_k.field_71443_c), this.fixScaledCoordinate(this.guiTop + y, scale, this.field_146297_k.field_71440_d), this.fixScaledCoordinate(srcX, scale, 256), this.fixScaledCoordinate(srcY, scale, 256), this.fixScaledCoordinate(w, scale, this.field_146297_k.field_71443_c), this.fixScaledCoordinate(h, scale, this.field_146297_k.field_71440_d));
    }

    private double fixScaledCoordinate(int val, float scale, int size) {
        double d = (float)val / scale;
        d *= (double)size;
        d = Math.floor(d);
        d /= (double)size;
        return d *= (double)scale;
    }

    public void drawScaleFriendlyTexture(double x, double y, double srcX, double srcY, double w, double h) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + h, (double)this.field_73735_i, (srcX + 0.0) * (double)f, (srcY + h) * (double)f1);
        tessellator.func_78374_a(x + w, y + h, (double)this.field_73735_i, (srcX + w) * (double)f, (srcY + h) * (double)f1);
        tessellator.func_78374_a(x + w, y + 0.0, (double)this.field_73735_i, (srcX + w) * (double)f, (srcY + 0.0) * (double)f1);
        tessellator.func_78374_a(x + 0.0, y + 0.0, (double)this.field_73735_i, (srcX + 0.0) * (double)f, (srcY + 0.0) * (double)f1);
        tessellator.func_78381_a();
    }

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
    }

    public static ResourceLocation registerTexture(String name) {
        return new ResourceLocation("stevesfactory", "textures/gui/" + name + ".png");
    }

    public void drawString(String str, int x, int y, float mult, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_78276_b(str, (int)((float)(x + this.guiLeft) / mult), (int)((float)(y + this.guiTop) / mult), color);
        GuiBase.bindTexture(this.getComponentResource());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawSplitString(String str, int x, int y, int w, float mult, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_78279_b(str, (int)((float)(x + this.guiLeft) / mult), (int)((float)(y + this.guiTop) / mult), (int)((float)w / mult), color);
        GuiBase.bindTexture(this.getComponentResource());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawString(String str, int x, int y, int color) {
        this.drawString(str, x, y, 1.0f, color);
    }

    public void drawMouseOver(String str, int x, int y, int width) {
        this.drawMouseOver(this.getLinesFromText(str, width), x, y);
    }

    public List<String> getLinesFromText(String str, int width) {
        ArrayList<String> lst = new ArrayList<String>();
        String[] words = str.split(" ");
        String line = "";
        for (String word : words) {
            String newLine = line.equals("") ? word : line + " " + word;
            if (this.getStringWidth(newLine) < width) {
                line = newLine;
                continue;
            }
            lst.add(line);
            line = word;
        }
        lst.add(line);
        return lst;
    }

    private int getStringMaxWidth(List<String> lines) {
        int width = 0;
        if (lines != null) {
            for (String line : lines) {
                int w = this.field_146289_q.func_78256_a(line);
                if (w <= width) continue;
                width = w;
            }
        }
        return width;
    }

    private int renderLines(List<String> lines, int mX, int mY, boolean first) {
        return this.renderLines(lines, mX, mY, first, false);
    }

    private int renderLines(List<String> lines, int mX, int mY, boolean first, boolean fake) {
        if (lines != null) {
            for (String line : lines) {
                if (!fake) {
                    this.field_146289_q.func_78261_a(line, mX, mY, -1);
                }
                if (first) {
                    mY += 2;
                    first = false;
                }
                mY += 10;
            }
        }
        return mY;
    }

    public void drawMouseOver(IAdvancedTooltip tooltip, int mX, int mY) {
        this.drawMouseOver(tooltip, mX, mY, mX, mY);
    }

    public void drawMouseOver(IAdvancedTooltip tooltip, int x, int y, int mX, int mY) {
        if (tooltip != null) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            List<String> prefix = tooltip.getPrefix(this);
            List<String> suffix = tooltip.getSuffix(this);
            int prefixLength = prefix != null ? prefix.size() : 0;
            int suffixLength = suffix != null ? suffix.size() : 0;
            int extraHeight = tooltip.getExtraHeight(this);
            int width = Math.max(tooltip.getMinWidth(this), Math.max(this.getStringMaxWidth(prefix), this.getStringMaxWidth(suffix)));
            int height = extraHeight + (prefixLength + suffixLength) * 10 - 2;
            y += this.guiTop - 12;
            if ((x += this.guiLeft + 12) + width > this.field_146294_l) {
                x -= 28 + width;
            }
            if (y + height + 6 > this.field_146295_m) {
                y = this.field_146295_m - height - 6;
            }
            this.field_73735_i = 300.0f;
            GuiBase.field_146296_j.field_77023_b = 300.0f;
            int j1 = -267386864;
            this.func_73733_a(x - 3, y - 4, x + width + 3, y - 3, j1, j1);
            this.func_73733_a(x - 3, y + height + 3, x + width + 3, y + height + 4, j1, j1);
            this.func_73733_a(x - 3, y - 3, x + width + 3, y + height + 3, j1, j1);
            this.func_73733_a(x - 4, y - 3, x - 3, y + height + 3, j1, j1);
            this.func_73733_a(x + width + 3, y - 3, x + width + 4, y + height + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, k1, l1);
            this.func_73733_a(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, k1, l1);
            this.func_73733_a(x - 3, y - 3, x + width + 3, y - 3 + 1, k1, k1);
            this.func_73733_a(x - 3, y + height + 2, x + width + 3, y + height + 3, l1, l1);
            y = this.renderLines(prefix, x, y, true);
            tooltip.drawContent(this, x - this.guiLeft, y - this.guiTop, mX, mY);
            this.renderLines(suffix, x, y += extraHeight, false);
            this.field_73735_i = 0.0f;
            GuiBase.field_146296_j.field_77023_b = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public int getAdvancedToolTipContentStartX(IAdvancedTooltip tooltip) {
        return 12;
    }

    public int getAdvancedToolTipContentStartY(IAdvancedTooltip tooltip) {
        if (tooltip != null) {
            return this.renderLines(tooltip.getPrefix(this), 0, 0, true, true) - 12;
        }
        return 0;
    }

    public void drawMouseOver(String str, int x, int y) {
        this.drawMouseOver(Arrays.asList(str.split("\n")), x, y);
    }

    public void drawMouseOver(List lst, int x, int y) {
        if (lst != null) {
            this.drawHoveringText(lst, x + this.guiLeft, y + this.guiTop, this.field_146289_q);
        }
    }

    public void drawBlock(TileEntity te, int x, int y) {
        ItemStack item = this.getItemStackFromBlock(te);
        if (item != null) {
            this.drawItemStack(item, x, y);
        }
    }

    public String getBlockName(TileEntity te) {
        ItemStack item = this.getItemStackFromBlock(te);
        if (item != null) {
            return this.getItemName(item);
        }
        return "Unknown";
    }

    public String getItemName(ItemStack item) {
        try {
            List str = item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            if (str != null && str.size() > 0) {
                return (String)str.get(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Unknown";
    }

    private ItemStack getItemStackFromBlock(TileEntity te) {
        if (te != null) {
            if (te instanceof TileEntityClusterElement) {
                return ((TileEntityClusterElement)te).getItemStackFromBlock();
            }
            World world = te.func_145831_w();
            Block block = te.func_145838_q();
            if (world != null && block != null) {
                int x = te.field_145851_c;
                int y = te.field_145848_d;
                int z = te.field_145849_e;
                return this.getItemStackFromBlock(world, x, y, z, block, world.func_72805_g(x, y, z));
            }
        }
        return null;
    }

    public ItemStack getItemStackFromBlock(World world, int x, int y, int z) {
        Block block;
        if (world != null && (block = world.func_147439_a(x, y, z)) != null) {
            return this.getItemStackFromBlock(world, x, y, z, block, world.func_72805_g(x, y, z));
        }
        return null;
    }

    private ItemStack getItemStackFromBlock(World world, int x, int y, int z, Block block, int meta) {
        try {
            ItemStack item = block.getPickBlock(new MovingObjectPosition(x, y, z, 1, Vec3.func_72443_a((double)x, (double)y, (double)z)), world, x, y, z);
            if (item != null) {
                return item;
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            ArrayList items = block.getDrops(world, x, y, z, meta, 0);
            if (items != null && items.size() > 0 && items.get(0) != null) {
                return (ItemStack)items.get(0);
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        return new ItemStack(block, 1, meta);
    }

    public void drawItemAmount(ItemStack itemstack, int x, int y) {
        field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, x + this.guiLeft, y + this.guiTop);
        GuiBase.bindTexture(this.getComponentResource());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawItemStack(ItemStack itemstack, int x, int y) {
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GuiBase.field_146296_j.field_77023_b = 1.0f;
        try {
            field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, x + this.guiLeft, y + this.guiTop);
        }
        catch (Exception ex) {
            if (itemstack.func_77960_j() != 0) {
                ItemStack newStack = itemstack.func_77946_l();
                newStack.func_77964_b(0);
                this.drawItemStack(newStack, x, y);
            }
        }
        finally {
            GuiBase.field_146296_j.field_77023_b = 0.0f;
            GuiBase.bindTexture(this.getComponentResource());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public int getStringWidth(String str) {
        return this.field_146289_q.func_78256_a(str);
    }

    public void drawCenteredString(String str, int x, int y, float mult, int width, int color) {
        this.drawString(str, x + (width - (int)((float)this.getStringWidth(str) * mult)) / 2, y, mult, color);
    }

    public void drawCursor(int x, int y, int z, int color) {
        this.drawCursor(x, y, z, 1.0f, color);
    }

    public void drawCursor(int x, int y, int z, float size, int color) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
        GL11.glTranslatef((float)(x += this.guiLeft), (float)(y += this.guiTop), (float)0.0f);
        GL11.glScalef((float)size, (float)size, (float)0.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
        Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + 10), (int)color);
        GL11.glPopMatrix();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        GL11.glLineWidth((float)(1.0f + (float)(5 * this.field_146294_l) / 500.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)(this.guiLeft + x1), (float)(this.guiTop + y1), (float)0.0f);
        GL11.glVertex3f((float)(this.guiLeft + x2), (float)(this.guiTop + y2), (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public final void func_146276_q_() {
        super.func_146276_q_();
        this.startScaling();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(this.scaleX(x), this.scaleY(y), f);
        this.stopScaling();
    }

    private void startScaling() {
        GL11.glPushMatrix();
        float scale = this.getScale();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        GL11.glTranslatef((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
        GL11.glTranslatef((float)(((float)this.field_146294_l - (float)this.xSize * scale) / (2.0f * scale)), (float)(((float)this.field_146295_m - (float)this.ySize * scale) / (2.0f * scale)), (float)0.0f);
    }

    private void stopScaling() {
        GL11.glPopMatrix();
    }

    protected float getScale() {
        float h;
        float multY;
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        float w = (float)scaledresolution.func_78326_a() * 0.9f;
        float multX = w / (float)this.xSize;
        float mult = Math.min(multX, multY = (h = (float)scaledresolution.func_78328_b() * 0.9f) / (float)this.ySize);
        if (mult > 1.0f && !Settings.isEnlargeInterfaces()) {
            mult = 1.0f;
        }
        mult = (float)Math.floor(mult * 1000.0f) / 1000.0f;
        return mult;
    }

    protected int scaleX(float x) {
        float scale = this.getScale();
        x /= scale;
        x += (float)this.guiLeft;
        return (int)(x -= ((float)this.field_146294_l - (float)this.xSize * scale) / (2.0f * scale));
    }

    protected int scaleY(float y) {
        float scale = this.getScale();
        y /= scale;
        y += (float)this.guiTop;
        return (int)(y -= ((float)this.field_146295_m - (float)this.ySize * scale) / (2.0f * scale));
    }

    public void drawIcon(IIcon icon, int x, int y) {
        this.func_94065_a(this.guiLeft + x, this.guiTop + y, icon, 16, 16);
    }

    public void drawFluid(Fluid fluid, int x, int y) {
        IIcon icon = fluid.getIcon();
        if (icon == null) {
            if (FluidRegistry.WATER.equals(fluid)) {
                icon = Blocks.field_150355_j.func_149691_a(0, 0);
            } else if (FluidRegistry.LAVA.equals(fluid)) {
                icon = Blocks.field_150353_l.func_149691_a(0, 0);
            }
        }
        if (icon != null) {
            GuiBase.bindTexture(TERRAIN);
            this.setColor(fluid.getColor());
            this.drawIcon(icon, x, y);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBase.bindTexture(this.getComponentResource());
        }
    }

    private void setColor(int color) {
        float[] colorComponents = new float[3];
        for (int i = 0; i < colorComponents.length; ++i) {
            colorComponents[i] = (float)((color & 255 << i * 8) >> i * 8) / 255.0f;
        }
        GL11.glColor4f((float)colorComponents[2], (float)colorComponents[1], (float)colorComponents[0], (float)1.0f);
    }

    public int getFontHeight() {
        return this.field_146289_q.field_78288_b;
    }

    public int getLeft() {
        return this.guiLeft;
    }

    public int getTop() {
        return this.guiTop;
    }
}

