/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.settings;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.components.CheckBoxList;
import vswe.stevesfactory.components.ComponentType;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.interfaces.IInterfaceRenderer;
import vswe.stevesfactory.settings.Settings;

@SideOnly(value=Side.CLIENT)
public class SettingsScreen
implements IInterfaceRenderer {
    private TileEntityManager manager;
    private List<Button> buttons;
    private static final int CHECK_BOX_WIDTH = 100;
    private static final int START_X = 10;
    private static final int START_SETTINGS_X = 380;
    private static final int MARGIN_X = 30;
    private static final int START_Y = 20;
    private static final int MAX_Y = 250;
    private CheckBoxList checkBoxes;
    private String cachedString;
    private Localization localization = Localization.CLOSE_GROUP_LABEL;
    private int currentX;
    private int currentY;
    private int offsetY;
    private GuiManager cachedGui;
    private static final int BUTTON_SRC_X = 242;
    private static final int BUTTON_SRC_Y = 0;
    private static final int BUTTON_SIZE = 14;
    private static final int BUTTON_SIZE_INNER = 12;

    public SettingsScreen(final TileEntityManager manager) {
        this.manager = manager;
        this.buttons = new ArrayList<Button>();
        this.buttons.add(new Button(493, 5, Localization.GO_BACK, 231, 12 * ComponentType.values().length + 1){

            @Override
            protected void onClick() {
                manager.specialRenderer = null;
            }
        });
    }

    private int getXAndGenerateY(Localization name) {
        int height;
        this.currentY += this.offsetY;
        String str = name.toString();
        List<String> lines = this.cachedGui.getLinesFromText(str, 100);
        this.offsetY = height = (int)((float)((lines.size() + 1) * this.cachedGui.getFontHeight()) * 0.7f);
        if (this.currentY + height > 250) {
            this.currentY = 20;
            this.currentX += 130;
        }
        return this.currentX;
    }

    private void addCheckboxes(GuiManager gui) {
        this.cachedGui = gui;
        this.cachedString = this.localization.toString();
        this.checkBoxes = new CheckBoxList();
        this.currentX = 10;
        this.currentY = 20;
        this.offsetY = 0;
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.CLOSE_GROUP_LABEL){

            @Override
            public void setValue(boolean val) {
                Settings.setAutoCloseGroup(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isAutoCloseGroup();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.OPEN_MENU_LARGE_HIT_BOX){

            @Override
            public void setValue(boolean val) {
                Settings.setLargeOpenHitBox(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isLargeOpenHitBox();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.OPEN_MENU_LARGE_HIT_BOX_MENU){

            @Override
            public void setValue(boolean val) {
                Settings.setLargeOpenHitBoxMenu(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isLargeOpenHitBoxMenu();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.OPEN_GROUP_QUICK){

            @Override
            public void setValue(boolean val) {
                Settings.setQuickGroupOpen(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isQuickGroupOpen();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.SHOW_COMMAND_TYPE){

            @Override
            public void setValue(boolean val) {
                Settings.setCommandTypes(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isCommandTypes();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.AUTO_SIDE){

            @Override
            public void setValue(boolean val) {
                Settings.setAutoSide(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isAutoSide();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.AUTO_BLACK_LIST){

            @Override
            public void setValue(boolean val) {
                Settings.setAutoBlacklist(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isAutoBlacklist();
            }
        });
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.ENLARGE_INTERFACES){

            @Override
            public void setValue(boolean val) {
                Settings.setEnlargeInterfaces(val);
            }

            @Override
            public boolean getValue() {
                return Settings.isEnlargeInterfaces();
            }
        });
        this.currentX = 380;
        this.currentY = 20;
        this.offsetY = 0;
        this.checkBoxes.addCheckBox(new CheckBoxSetting(Localization.LIMITLESS){

            @Override
            public void setValue(boolean val) {
                Settings.setLimitless(SettingsScreen.this.manager, val);
            }

            @Override
            public boolean getValue() {
                return Settings.isLimitless(SettingsScreen.this.manager);
            }

            @Override
            public boolean isVisible() {
                return Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d;
            }
        });
    }

    @Override
    public void draw(GuiManager gui, int mX, int mY) {
        if (this.cachedString == null || !this.localization.toString().equals(this.cachedString)) {
            this.addCheckboxes(gui);
        }
        gui.drawString(Localization.PREFERENCES.toString(), 8, 6, 0x404040);
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            gui.drawString(Localization.SETTINGS.toString(), 378, 6, 0x404040);
        }
        this.checkBoxes.draw(gui, mX, mY);
        for (Button button : this.buttons) {
            button.draw(gui, mX, mY);
        }
    }

    @Override
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        for (Button button : this.buttons) {
            button.drawMouseOver(gui, mX, mY);
        }
    }

    @Override
    public void onClick(GuiManager gui, int mX, int mY, int b) {
        this.checkBoxes.onClick(mX, mY);
        for (Button button : this.buttons) {
            if (!button.inBounds(mX, mY)) continue;
            button.onClick();
            break;
        }
    }

    @Override
    public void onDrag(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onRelease(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onKeyTyped(GuiManager gui, char c, int k) {
    }

    @Override
    public void onScroll(int scroll) {
    }

    private abstract class Button {
        private int x;
        private int y;
        private Localization name;
        private int srcX;
        private int srcY;

        private Button(int x, int y, Localization name, int srcX, int srcY) {
            this.x = x;
            this.y = y;
            this.name = name;
            this.srcX = srcX;
            this.srcY = srcY;
        }

        private void draw(GuiManager gui, int mX, int mY) {
            int srcYButton = this.inBounds(mX, mY) ? 1 : 0;
            gui.drawTexture(this.x, this.y, 242, 0 + srcYButton * 14, 14, 14);
            gui.drawTexture(this.x + 2, this.y + 2, this.srcX, this.srcY, 12, 12);
        }

        private boolean inBounds(int mX, int mY) {
            return CollisionHelper.inBounds(this.x, this.y, 14, 14, mX, mY);
        }

        private void drawMouseOver(GuiManager gui, int mX, int mY) {
            if (this.inBounds(mX, mY)) {
                gui.drawMouseOver(this.name.toString(), mX, mY);
            }
        }

        protected abstract void onClick();
    }

    private abstract class CheckBoxSetting
    extends CheckBox {
        private CheckBoxSetting(Localization name) {
            super(name, SettingsScreen.this.getXAndGenerateY(name), SettingsScreen.this.currentY);
            this.setTextWidth(100);
        }

        @Override
        public void onUpdate() {
        }
    }
}

