/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil;

import CoroUtil.OldUtil;
import CoroUtil.config.ConfigCoroAI;
import CoroUtil.pathfinding.PFQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class DimensionChunkCache
implements IBlockAccess {
    public int chunkX;
    public int chunkZ;
    public int chunkXMax;
    public int chunkZMax;
    private Chunk[][] chunkArray;
    private boolean hasExtendedLevels;
    private World worldObj;
    public static List<Integer> listBlacklistIDs = new ArrayList<Integer>();
    public static List<String> listBlacklistNamess = new ArrayList<String>();
    public static HashMap<Integer, DimensionChunkCache> dimCacheLookup = new HashMap();

    public static void updateAllWorldCache() {
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            WorldServer world = worlds[i];
            boolean skip = false;
            if (ConfigCoroAI.chunkCacheOverworldOnly && i != 0) {
                skip = true;
            }
            if (listBlacklistIDs.contains(i)) {
                skip = true;
            }
            for (int j = 0; j < listBlacklistNamess.size(); ++j) {
                if (world == null || !world.field_73011_w.func_80007_l().contains(listBlacklistNamess.get(j))) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            dimCacheLookup.put(world.field_73011_w.field_76574_g, new DimensionChunkCache((World)world, true));
        }
    }

    public DimensionChunkCache(World world, boolean useLoadedChunks) {
        int chunkCount = 0;
        try {
            int minX = 0;
            int minZ = 0;
            int maxX = 0;
            int maxZ = 0;
            if (useLoadedChunks) {
                ArrayList chunks = null;
                try {
                    chunks = (ArrayList)OldUtil.getPrivateValue(ChunkProviderServer.class, world.func_72863_F(), "loadedChunks");
                }
                catch (Exception ex) {
                    try {
                        chunks = (ArrayList)OldUtil.getPrivateValueSRGMCP(ChunkProviderServer.class, world.func_72863_F(), OldUtil.refl_loadedChunks_obf, OldUtil.refl_loadedChunks_mcp);
                    }
                    catch (Exception ex2) {
                        System.out.println("SERIOUS REFLECTION FAIL IN DimensionChunkCache");
                    }
                }
                for (int i = 0; i < chunks.size(); ++i) {
                    Chunk chunk = (Chunk)chunks.get(i);
                    if (chunk.field_76635_g < minX) {
                        minX = chunk.field_76635_g;
                    }
                    if (chunk.field_76647_h < minZ) {
                        minZ = chunk.field_76647_h;
                    }
                    if (chunk.field_76635_g > maxX) {
                        maxX = chunk.field_76635_g;
                    }
                    if (chunk.field_76647_h <= maxZ) continue;
                    maxZ = chunk.field_76647_h;
                }
                this.worldObj = world;
                this.chunkX = minX;
                this.chunkZ = minZ;
                int var8 = maxX;
                int var9 = maxZ;
                this.chunkArray = new Chunk[var8 - this.chunkX + 1][var9 - this.chunkZ + 1];
                this.hasExtendedLevels = true;
                for (int i = 0; i < chunks.size(); ++i) {
                    Chunk chunk;
                    this.chunkArray[chunk.field_76635_g - this.chunkX][chunk.field_76647_h - this.chunkZ] = chunk = (Chunk)chunks.get(i);
                    ++chunkCount;
                }
            } else {
                int playerRadius = 8;
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityPlayer var5 = (EntityPlayer)world.field_73010_i.get(i);
                    if ((int)var5.field_70165_t < minX) {
                        minX = (int)var5.field_70165_t;
                    }
                    if ((int)var5.field_70161_v < minZ) {
                        minZ = (int)var5.field_70161_v;
                    }
                    if ((int)var5.field_70165_t > maxX) {
                        maxX = (int)var5.field_70165_t;
                    }
                    if ((int)var5.field_70161_v <= maxZ) continue;
                    maxZ = (int)var5.field_70161_v;
                }
                this.worldObj = world;
                this.chunkX = (minX -= playerRadius * 16) >> 4;
                this.chunkZ = (minZ -= playerRadius * 16) >> 4;
                int var8 = (maxX += playerRadius * 16) >> 4;
                int var9 = (maxZ += playerRadius * 16) >> 4;
                this.chunkXMax = var8;
                this.chunkZMax = var9;
                this.chunkArray = new Chunk[var8 - this.chunkX + 1][var9 - this.chunkZ + 1];
                this.hasExtendedLevels = true;
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityPlayer var5 = (EntityPlayer)world.field_73010_i.get(i);
                    int pChunkX = MathHelper.func_76128_c((double)(var5.field_70165_t / 16.0));
                    int pChunkZ = MathHelper.func_76128_c((double)(var5.field_70161_v / 16.0));
                    for (int xx = -playerRadius; xx <= playerRadius; ++xx) {
                        for (int zz = -playerRadius; zz <= playerRadius; ++zz) {
                            Chunk var12;
                            if (pChunkX + xx - this.chunkX < 0 || pChunkZ + zz - this.chunkZ < 0 || this.chunkArray[pChunkX + xx - this.chunkX][pChunkZ + zz - this.chunkZ] != null || (var12 = world.func_72964_e(pChunkX + xx, pChunkZ + zz)) == null) continue;
                            ++chunkCount;
                            this.chunkArray[pChunkX + xx - this.chunkX][pChunkZ + zz - this.chunkZ] = var12;
                        }
                    }
                }
            }
            PFQueue.lastChunkCacheCount = chunkCount;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("DimensionChunkCache crash, tell Corosus");
            PFQueue.lastChunkCacheCount = 0;
        }
    }

    public boolean func_72806_N() {
        return this.hasExtendedLevels;
    }

    public Block func_147439_a(int p_147439_1_, int p_147439_2_, int p_147439_3_) {
        Block block = Blocks.field_150350_a;
        if (p_147439_2_ >= 0 && p_147439_2_ < 256) {
            Chunk chunk;
            int l = (p_147439_1_ >> 4) - this.chunkX;
            int i1 = (p_147439_3_ >> 4) - this.chunkZ;
            if (l >= 0 && l < this.chunkArray.length && i1 >= 0 && i1 < this.chunkArray[l].length && (chunk = this.chunkArray[l][i1]) != null) {
                block = chunk.func_150810_a(p_147439_1_ & 0xF, p_147439_2_, p_147439_3_ & 0xF);
            }
        }
        return block;
    }

    public TileEntity func_147438_o(int p_147438_1_, int p_147438_2_, int p_147438_3_) {
        int l = (p_147438_1_ >> 4) - this.chunkX;
        int i1 = (p_147438_3_ >> 4) - this.chunkZ;
        if (l < 0 || l >= this.chunkArray.length || i1 < 0 || i1 >= this.chunkArray[l].length) {
            return null;
        }
        if (this.chunkArray[l][i1] == null) {
            return null;
        }
        return this.chunkArray[l][i1].func_150806_e(p_147438_1_ & 0xF, p_147438_2_, p_147438_3_ & 0xF);
    }

    public int func_72802_i(int par1, int par2, int par3, int par4) {
        int var5 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, par1, par2, par3);
        int var6 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Block, par1, par2, par3);
        if (var6 < par4) {
            var6 = par4;
        }
        return var5 << 20 | var6 << 4;
    }

    public int func_72805_g(int par1, int par2, int par3) {
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            return 0;
        }
        int var4 = (par1 >> 4) - this.chunkX;
        int var5 = (par3 >> 4) - this.chunkZ;
        if (var4 >= 0 && var4 < this.chunkArray.length && var5 >= 0 && var5 < this.chunkArray[var4].length) {
            Chunk var6 = this.chunkArray[var4][var5];
            return var6 == null ? 0 : var6.func_76628_c(par1 & 0xF, par2, par3 & 0xF);
        }
        return 0;
    }

    public BiomeGenBase func_72807_a(int par1, int par2) {
        return this.worldObj.func_72807_a(par1, par2);
    }

    public boolean func_147437_c(int p_147437_1_, int p_147437_2_, int p_147437_3_) {
        return this.func_147439_a(p_147437_1_, p_147437_2_, p_147437_3_).isAir((IBlockAccess)this, p_147437_1_, p_147437_2_, p_147437_3_);
    }

    public int getSkyBlockTypeBrightness(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            par3 = 255;
        }
        if (par3 >= 0 && par3 < 256 && par2 >= -30000000 && par4 >= -30000000 && par2 < 30000000 && par4 <= 30000000) {
            if (par1EnumSkyBlock == EnumSkyBlock.Sky && this.worldObj.field_73011_w.field_76576_e) {
                return 0;
            }
            if (this.func_147439_a(par2, par3, par4).func_149710_n()) {
                int l = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2, par3 + 1, par4);
                int i1 = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2 + 1, par3, par4);
                int j1 = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2 - 1, par3, par4);
                int k1 = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2, par3, par4 + 1);
                int l1 = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2, par3, par4 - 1);
                if (i1 > l) {
                    l = i1;
                }
                if (j1 > l) {
                    l = j1;
                }
                if (k1 > l) {
                    l = k1;
                }
                if (l1 > l) {
                    l = l1;
                }
                return l;
            }
            int l = (par2 >> 4) - this.chunkX;
            int i1 = (par4 >> 4) - this.chunkZ;
            return this.chunkArray[l][i1].func_76614_a(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
        }
        return par1EnumSkyBlock.field_77198_c;
    }

    public int getSpecialBlockBrightness(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            par3 = 255;
        }
        if (par3 >= 0 && par3 < 256 && par2 >= -30000000 && par4 >= -30000000 && par2 < 30000000 && par4 <= 30000000) {
            int var5 = (par2 >> 4) - this.chunkX;
            int var6 = (par4 >> 4) - this.chunkZ;
            return this.chunkArray[var5][var6].func_76614_a(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
        }
        return par1EnumSkyBlock.field_77198_c;
    }

    public int func_72800_K() {
        return 256;
    }

    public int func_72879_k(int par1, int par2, int par3, int par4) {
        return this.func_147439_a(par1, par2, par3).func_149748_c((IBlockAccess)this, par1, par2, par3, par4);
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return _default;
        }
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    public Chunk getChunkFromBlockCoords(int par1, int par2) {
        return this.getChunkFromChunkCoords(par1 >> 4, par2 >> 4);
    }

    public Chunk getChunkFromChunkCoords(int par1, int par2) {
        if ((par1 -= this.chunkX) > 0 && (par2 -= this.chunkZ) > 0 && par1 < this.chunkArray.length && par2 < this.chunkArray[par1].length) {
            return this.chunkArray[par1][par2];
        }
        return null;
    }

    public int getHeightValue(int par1, int par2) {
        if (par1 >= -30000000 && par2 >= -30000000 && par1 < 30000000 && par2 < 30000000) {
            Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par2 >> 4);
            if (chunk != null) {
                return chunk.func_76611_b(par1 & 0xF, par2 & 0xF);
            }
            return -1;
        }
        return 0;
    }

    public int getChunkHeightMapMinimum(int par1, int par2) {
        if (par1 >= -30000000 && par2 >= -30000000 && par1 < 30000000 && par2 < 30000000) {
            Chunk chunk = this.getChunkFromChunkCoords(par1 >> 4, par2 >> 4);
            return chunk.field_82912_p;
        }
        return 0;
    }
}

