/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.ability;

import CoroUtil.ability.IAbilityUsageCallback;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public class Ability {
    public EntityLivingBase owner;
    public String name = "";
    public int ticksToPerform = 10;
    public int ticksToCharge = 0;
    public int ticksToCooldown = 10;
    public float bestDist = 10.0f;
    public float bestDistRange = 10.0f;
    public int type = 0;
    public int curTickPerform = 0;
    public int curTickCharge = 0;
    public int curTickCooldown = 0;
    private boolean isActive = false;
    public IAbilityUsageCallback callback;
    public static int TYPE_MELEE = 0;
    public static int TYPE_RANGED = 1;
    public static int TYPE_SUPPORT = 2;
    public static int TYPE_MISC = 3;
    public boolean hasAppliedDamage = false;
    public int usageCount = 0;

    public Ability init(EntityLivingBase parOwner) {
        this.owner = parOwner;
        return this;
    }

    public void tick() {
        if (this.curTickCharge < this.ticksToCharge) {
            ++this.curTickCharge;
            this.tickChargeUp();
        } else if (this.curTickPerform < this.ticksToPerform) {
            ++this.curTickPerform;
            this.tickPerform();
        } else if (this.curTickCooldown < this.ticksToCooldown) {
            ++this.curTickCooldown;
            this.tickCooldown();
        } else {
            this.setFinishedEntirely();
        }
    }

    public void tickChargeUp() {
    }

    public void tickPerform() {
    }

    public void tickCooldown() {
    }

    @SideOnly(value=Side.CLIENT)
    public void tickRender(ModelBase model) {
    }

    public void setFinishedChargeUp() {
        this.curTickCharge = this.ticksToCharge;
    }

    public void setFinishedPerform() {
        this.curTickPerform = this.ticksToPerform;
    }

    public void setFinishedCooldown() {
        this.curTickCooldown = this.ticksToCooldown;
    }

    public void setTarget(Entity parTarget) {
    }

    public void setCallback(IAbilityUsageCallback parCallback) {
        this.callback = parCallback;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setFinishedEntirely() {
        if (this.isActive) {
            this.isActive = false;
            if (this.callback != null) {
                this.callback.abilityFinished(this);
            }
        }
        this.isActive = false;
        this.reset();
    }

    public void setActive() {
        if (!this.isActive) {
            ++this.usageCount;
        }
        this.isActive = true;
    }

    public void reset() {
        this.curTickPerform = 0;
        this.curTickCharge = 0;
        this.curTickCooldown = 0;
        this.hasAppliedDamage = false;
    }

    public void nbtLoad(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.type = nbt.func_74762_e("type");
    }

    public NBTTagCompound nbtSave() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("type", this.type);
        nbt.func_74757_a("fullSave", true);
        return nbt;
    }

    public void nbtSyncRead(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.usageCount = nbt.func_74762_e("usageCount");
        boolean wasActive = this.isActive;
        this.isActive = nbt.func_74767_n("isActive");
        if (!this.isActive && wasActive) {
            this.setFinishedEntirely();
        }
        this.curTickCharge = nbt.func_74762_e("curTickCharge");
        this.curTickPerform = nbt.func_74762_e("curTickPerform");
        this.curTickCooldown = nbt.func_74762_e("curTickCooldown");
    }

    public NBTTagCompound nbtSyncWrite() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("usageCount", this.usageCount);
        nbt.func_74757_a("isActive", this.isActive);
        nbt.func_74768_a("curTickCharge", this.curTickCharge);
        nbt.func_74768_a("curTickPerform", this.curTickPerform);
        nbt.func_74768_a("curTickCooldown", this.curTickCooldown);
        return nbt;
    }
}

