/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt;

import CoroUtil.bt.AIBTTamable;
import CoroUtil.bt.AIEventHandler;
import CoroUtil.bt.BlackboardBase;
import CoroUtil.bt.EntityMoveHelperCustom;
import CoroUtil.bt.IBTAgent;
import CoroUtil.bt.OrdersHandler;
import CoroUtil.bt.PathNavigateCustom;
import CoroUtil.bt.PersonalityProfile;
import CoroUtil.bt.actions.Delay;
import CoroUtil.bt.actions.OrdersUser;
import CoroUtil.bt.nodes.SelectorMoveToPathBest;
import CoroUtil.bt.nodes.SelectorMoveToPathClose;
import CoroUtil.bt.nodes.SelectorMoveToPosVec;
import CoroUtil.bt.nodes.SenseEnvironment;
import CoroUtil.bt.selector.Selector;
import CoroUtil.bt.selector.SelectorBoolean;
import CoroUtil.bt.selector.SelectorConcurrent;
import CoroUtil.bt.selector.SelectorSequence;
import CoroUtil.diplomacy.DiplomacyHelper;
import CoroUtil.diplomacy.TeamInstance;
import CoroUtil.diplomacy.TeamTypes;
import CoroUtil.pathfinding.PFQueue;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class AIBTAgent {
    public AIEventHandler eventHandler;
    public PersonalityProfile profile;
    public TeamInstance dipl_info = TeamTypes.getType("neutral");
    public BlackboardBase blackboard;
    public IBTAgent entInt;
    public EntityLivingBase ent;
    public OrdersHandler ordersHandler;
    public AIBTTamable tamable;
    public Selector btSenses;
    public Selector btAI;
    public Selector btMovement;
    public Selector btAttack;
    public PathNavigateCustom pathNav;
    public EntityMoveHelperCustom moveHelper;
    public float moveSpeed = 0.6f;
    public boolean canDespawn = false;
    public String acceptableOrders = "gather build guard_position";
    private boolean hasInit = false;
    public int tickAge = 0;
    public int tickDespawn = 0;
    public long lastAnimateUpdateTime = 0L;
    public static boolean DEBUGTREES = false;

    public AIBTAgent(IBTAgent parEnt) {
        this.ent = parEnt.getEntityLiving();
        this.entInt = parEnt;
        this.ordersHandler = new OrdersHandler(parEnt);
        this.blackboard = new BlackboardBase(this);
        this.eventHandler = new AIEventHandler(this);
        this.tamable = new AIBTTamable(this);
        this.profile = new PersonalityProfile(this);
        this.profile.init();
        this.pathNav = new PathNavigateCustom(this.ent, this.ent.field_70170_p);
        this.pathNav.setAvoidsWater(false);
        this.pathNav.setCanSwim(true);
        this.moveHelper = new EntityMoveHelperCustom(this.ent);
        this.ent.field_70144_Y = 0.2f;
    }

    public void entityInit() {
        this.ent.func_70096_w().func_75682_a(22, (Object)0);
        this.ent.func_70096_w().func_75682_a(24, (Object)0);
        this.ent.func_70096_w().func_75682_a(25, (Object)0);
    }

    public void initBTTemplate() {
        this.btSenses = new SelectorConcurrent(null);
        this.btSenses.add(new SenseEnvironment(this.btSenses, this.blackboard));
        Delay delay = new Delay(null, 0, 0);
        SelectorBoolean isFighting = new SelectorBoolean(null, this.blackboard.isFighting);
        isFighting.debug = "isFighting";
        isFighting.add(this.profile.btIdling);
        isFighting.add(delay);
        SelectorSequence selOrdersPerform = new SelectorSequence(null);
        selOrdersPerform.debug = "selOrdersPerform";
        selOrdersPerform.add(new OrdersUser(selOrdersPerform, this.ordersHandler, this.getAcceptableOrders()));
        SelectorBoolean shouldFollowOrders = new SelectorBoolean(null, this.blackboard.shouldFollowOrders);
        shouldFollowOrders.debug = "shouldFollowOrders";
        SelectorBoolean shouldSurvive = new SelectorBoolean(null, this.blackboard.shouldTrySurvival);
        shouldSurvive.debug = "shouldSurvive";
        shouldFollowOrders.add(shouldSurvive);
        shouldFollowOrders.add(selOrdersPerform);
        shouldSurvive.add(isFighting);
        shouldSurvive.add(this.profile.btSurviving);
        this.btAI = new SelectorConcurrent(null);
        this.btAI.add(shouldFollowOrders);
        SelectorBoolean selLongPath = new SelectorBoolean(this.btMovement, this.blackboard.isLongPath);
        SelectorMoveToPathBest sel1_PathBest = new SelectorMoveToPathBest(selLongPath, this.entInt, this.blackboard);
        SelectorBoolean selSafeOrClosePath = new SelectorBoolean(selLongPath, this.blackboard.isSafeOrClosePath);
        SelectorMoveToPathClose sel_PathClosePartial = new SelectorMoveToPathClose(null, this.entInt, this.blackboard, 1, true);
        SelectorMoveToPathClose sel_PathCloseExact = new SelectorMoveToPathClose(null, this.entInt, this.blackboard, 1, false);
        SelectorMoveToPosVec sel_MoveToPos = new SelectorMoveToPosVec(selSafeOrClosePath, this.entInt, this.blackboard, 2.0f);
        selLongPath.add(selSafeOrClosePath);
        selLongPath.add(sel1_PathBest);
        sel1_PathBest.add(sel_PathClosePartial);
        sel1_PathBest.add(delay);
        selSafeOrClosePath.add(sel_PathCloseExact);
        selSafeOrClosePath.add(sel_MoveToPos);
        sel_MoveToPos.add(delay);
        sel_MoveToPos.add(delay);
        this.btMovement = new SelectorConcurrent(null);
        this.btMovement.add(selLongPath);
        SelectorBoolean shouldAttackPerform = new SelectorBoolean(null, this.blackboard.isFighting);
        shouldAttackPerform.add(new Delay(null, 0, 0));
        shouldAttackPerform.add(this.profile.btAttacking);
        this.btAttack = new SelectorConcurrent(null);
        this.btAttack.add(shouldAttackPerform);
    }

    public String getAcceptableOrders() {
        return this.acceptableOrders;
    }

    public void setSpeedNormalBase(float var) {
        this.moveSpeed = var;
    }

    public void applyEntityAttributes() {
        this.ent.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
    }

    public void tickAI() {
        if (this.ent.field_70170_p == null || this.ent.field_70170_p.field_73011_w == null) {
            return;
        }
        if (this.btSenses != null) {
            this.btSenses.tick();
        }
        if (this.btAI != null) {
            this.btAI.tick();
        }
        if (this.btMovement != null) {
            this.btMovement.tick();
        }
        if (this.btAttack != null) {
            this.btAttack.tick();
        }
        this.tamable.tick();
        this.tickMovement();
        this.tickAgeEntity();
        this.ent.field_70144_Y = 0.2f;
    }

    public void tickMovement() {
        double entSpeed = Math.sqrt(this.ent.field_70159_w + this.ent.field_70159_w * this.ent.field_70181_x + this.ent.field_70181_x * this.ent.field_70179_y + this.ent.field_70179_y);
        if (this.blackboard.canSwimPath.getValue().booleanValue()) {
            this.ent.func_70050_g(300);
        }
        if (this.ent.func_70090_H() && !this.blackboard.canFlyPath.getValue().booleanValue() && !this.blackboard.canSwimPath.getValue().booleanValue()) {
            Random rand = new Random();
            if (entSpeed < 0.5) {
                this.ent.field_70159_w *= (double)1.4f;
                this.ent.field_70179_y *= (double)1.4f;
            }
            this.ent.field_70181_x += 0.25;
        }
        double speed = 0.2;
        Block block = this.ent.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.ent.field_70165_t), (int)this.ent.field_70121_D.field_72338_b, MathHelper.func_76128_c((double)this.ent.field_70161_v));
        if (PFQueue.isFenceLike(block)) {
            Random rand = new Random();
            this.ent.field_70159_w += rand.nextDouble() * speed - rand.nextDouble() * speed;
            this.ent.field_70181_x = 0.2f;
            this.ent.field_70179_y += rand.nextDouble() * speed - rand.nextDouble() * speed;
            this.blackboard.posMoveTo = null;
        } else {
            block = this.ent.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.ent.field_70165_t), (int)this.ent.field_70121_D.field_72338_b - 1, MathHelper.func_76128_c((double)this.ent.field_70161_v));
            if (PFQueue.isFenceLike(block)) {
                Random rand = new Random();
                this.ent.field_70159_w += rand.nextDouble() * speed - rand.nextDouble() * speed;
                this.ent.field_70181_x = 0.2f;
                this.ent.field_70179_y += rand.nextDouble() * speed - rand.nextDouble() * speed;
                this.blackboard.posMoveTo = null;
            }
        }
        if (!this.ent.field_70122_E || this.ent.field_70123_F) {
            // empty if block
        }
        if (this.blackboard.canFlyPath.getValue().booleanValue() || this.blackboard.canSwimPath.getValue().booleanValue()) {
            this.ent.field_70143_R = 0.0f;
        }
        this.moveHelper.onUpdateMoveHelper();
        if (this.ent instanceof EntityLiving) {
            ((EntityLiving)this.ent).func_70671_ap().func_75649_a();
            ((EntityLiving)this.ent).func_70683_ar().func_75661_b();
        }
    }

    public void setMoveTo(double par1, double par3, double par5) {
        this.moveHelper.setMoveTo(par1, par3, par5, this.moveSpeed);
    }

    public void tickLiving() {
        if (this.profile.abilities.size() > 0) {
            this.profile.tickAbilities();
        }
        if (this.blackboard.canFlyPath.getValue().booleanValue() || this.blackboard.canSwimPath.getValue().booleanValue()) {
            this.ent.field_70143_R = 0.0f;
            if (this.ent.field_70170_p.field_72995_K) {
                this.ent.field_70181_x = 0.0;
            }
        }
    }

    public boolean isEnemy(Entity ent) {
        return DiplomacyHelper.shouldTargetEnt(this.entInt, ent);
    }

    public void initPost(boolean fromDisk) {
        this.hasInit = true;
        this.postFullInit();
    }

    public void postFullInit() {
        this.profile.updateListCache();
        this.profile.syncAbilitiesFull(true);
    }

    public IEntityLivingData onSpawnEvent(IEntityLivingData par1EntityLivingData) {
        this.initPost(false);
        return par1EntityLivingData;
    }

    public void nbtRead(NBTTagCompound par1nbtTagCompound) {
        this.tickAge = par1nbtTagCompound.func_74762_e("tickAge");
        this.canDespawn = par1nbtTagCompound.func_74767_n("canDespawn");
        this.profile.nbtRead(par1nbtTagCompound);
        this.tamable.setTamedByOwner(par1nbtTagCompound.func_74779_i("owner"));
        this.initPost(true);
    }

    public void nbtWrite(NBTTagCompound par1nbtTagCompound) {
        par1nbtTagCompound.func_74768_a("tickAge", this.tickAge);
        par1nbtTagCompound.func_74757_a("canDespawn", this.canDespawn);
        this.profile.nbtWrite(par1nbtTagCompound);
        par1nbtTagCompound.func_74778_a("owner", this.tamable.owner);
    }

    public void nbtDataFromServer(NBTTagCompound nbt) {
        String command = nbt.func_74779_i("command");
        if (command.equals("syncAbilities")) {
            this.profile.nbtSyncRead(nbt);
        }
    }

    public void tickAgeEntity() {
        ++this.tickAge;
        if (this.canDespawn) {
            EntityPlayer entityplayer;
            this.tickDespawn = this.pathNav.noPath() || this.blackboard.getTarget() == null ? ++this.tickDespawn : 0;
            if (this.ent.field_70170_p.func_82737_E() % 20L == 0L && (entityplayer = this.ent.field_70170_p.func_72890_a((Entity)this.ent, -1.0)) != null) {
                double d0 = entityplayer.field_70165_t - this.ent.field_70165_t;
                double d1 = entityplayer.field_70163_u - this.ent.field_70163_u;
                double d2 = entityplayer.field_70161_v - this.ent.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                Random rand = new Random();
                boolean despawn = false;
                if (d3 > 128.0) {
                    despawn = true;
                }
                if (this.tickDespawn > 600) {
                    if (d3 > 32.0) {
                        despawn = true;
                    } else if (d3 < 128.0) {
                        this.tickDespawn = 0;
                    }
                }
                if (despawn) {
                    this.ent.func_70106_y();
                }
            }
        } else {
            this.tickDespawn = 0;
        }
    }

    public void cleanup() {
        PFQueue.pfDelays.remove(this.ent);
        this.ent = null;
        this.ordersHandler = null;
        this.eventHandler.cleanup();
        this.entInt.cleanup();
        this.entInt = null;
    }
}

