/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt;

import CoroUtil.ability.Ability;
import CoroUtil.bt.AIBTAgent;
import CoroUtil.bt.nodes.AttackMeleeBest;
import CoroUtil.bt.nodes.AttackRangedBest;
import CoroUtil.bt.nodes.CombatLogic;
import CoroUtil.bt.nodes.Flee;
import CoroUtil.bt.nodes.TrackTarget;
import CoroUtil.bt.nodes.Wander;
import CoroUtil.bt.selector.Selector;
import CoroUtil.bt.selector.SelectorConcurrent;
import CoroUtil.entity.render.AnimationStateObject;
import CoroUtil.entity.render.TechneModelCoroAI;
import CoroUtil.forge.CoroAI;
import CoroUtil.packet.PacketHelper;
import CoroUtil.util.CoroUtilAbility;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PersonalityProfile {
    public AIBTAgent agent;
    public Selector btSurviving;
    public Selector btAttacking;
    public Selector btIdling;
    public float aggression = 0.5f;
    public float intelligence = 0.5f;
    public float loyalty_job = 0.8f;
    public float loyalty_personal = 0.8f;
    public ConcurrentHashMap<String, Ability> abilities = new ConcurrentHashMap();
    public List<Ability> listAbilitiesMelee = new ArrayList<Ability>();
    public List<Ability> listAbilitiesRanged = new ArrayList<Ability>();
    public float abilitySyncRange = 64.0f;
    @SideOnly(value=Side.CLIENT)
    public ConcurrentHashMap<String, AnimationStateObject> animationData;

    public PersonalityProfile(AIBTAgent parAgent) {
        this.agent = parAgent;
        this.abilities = new ConcurrentHashMap();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.animationData = new ConcurrentHashMap();
        }
    }

    public void addAbilityRemap(Ability parAbility, String addAsName, int type) {
        System.out.println("warning: addAbilityRemap fails to remap for entity nbt reloads, needs fix or removal");
        this.abilities.put(addAsName, parAbility);
        parAbility.type = type;
        if (type == Ability.TYPE_MELEE) {
            this.listAbilitiesMelee.add(parAbility);
        } else if (type == Ability.TYPE_RANGED) {
            this.listAbilitiesRanged.add(parAbility);
        }
    }

    public void addAbility(Ability parAbility, int type) {
        this.abilities.put(parAbility.name, parAbility);
        parAbility.type = type;
        if (type == Ability.TYPE_MELEE) {
            this.listAbilitiesMelee.add(parAbility);
        } else if (type == Ability.TYPE_RANGED) {
            this.listAbilitiesRanged.add(parAbility);
        }
    }

    public void addAbilityMelee(Ability parAbility) {
        this.addAbilityMelee(parAbility.name, parAbility);
    }

    public void addAbilityMelee(String name, Ability parAbility) {
        if (this.abilities.contains(name)) {
            System.out.println("AI warning, adding ability " + name + " overtop preexisting one");
        }
        this.abilities.put(name, parAbility);
        parAbility.type = Ability.TYPE_MELEE;
        this.listAbilitiesMelee.add(parAbility);
    }

    public void addAbilityRanged(Ability parAbility) {
        this.addAbilityRanged(parAbility.name, parAbility);
    }

    public void addAbilityRanged(String name, Ability parAbility) {
        this.abilities.put(name, parAbility);
        parAbility.type = Ability.TYPE_RANGED;
        this.listAbilitiesRanged.add(parAbility);
    }

    public void updateListCache() {
        this.listAbilitiesMelee.clear();
        this.listAbilitiesRanged.clear();
        for (Map.Entry<String, Ability> entry : this.abilities.entrySet()) {
            if (entry.getValue().type == Ability.TYPE_MELEE) {
                this.listAbilitiesMelee.add(entry.getValue());
                continue;
            }
            if (entry.getValue().type != Ability.TYPE_RANGED) continue;
            this.listAbilitiesRanged.add(entry.getValue());
        }
    }

    public void tickAbilities() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            Ability ability;
            if (this.agent.blackboard.isMoving.getValue().booleanValue()) {
                ability = this.abilities.get("Walk");
                if (ability != null) {
                    Ability ability2;
                    if (!ability.isActive()) {
                        this.abilityStart(ability, null);
                    }
                    if ((ability2 = this.abilities.get("Idle")) != null && !ability2.isActive()) {
                        ability2.setFinishedEntirely();
                        this.syncAbility(ability2);
                    }
                }
            } else if (this.agent.blackboard.getTarget() == null && (ability = this.abilities.get("Idle")) != null && !ability.isActive()) {
                this.abilityStart(ability, null);
            }
        }
        for (Map.Entry<String, Ability> entry : this.abilities.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            entry.getValue().tick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickAbilitiesRender(TechneModelCoroAI model) {
        for (Map.Entry<String, Ability> entry : this.abilities.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            entry.getValue().tickRender(model);
        }
    }

    public void init() {
        this.btSurviving = new SelectorConcurrent(null);
        this.btAttacking = new SelectorConcurrent(null);
        this.btIdling = new SelectorConcurrent(null);
    }

    public void initDefaultProfile() {
        this.btSurviving.add(new Flee(this.btSurviving, this.agent.entInt, this.agent.blackboard));
        this.btIdling.add(new Wander(this.btIdling, this.agent.entInt, this.agent.blackboard, 8.0f));
        this.btAttacking.add(new TrackTarget(null, this.agent.entInt, this.agent.blackboard));
        CombatLogic selCombat = new CombatLogic(null, this.agent.entInt);
        selCombat.add(new AttackMeleeBest(null, this.agent.entInt));
        selCombat.add(new AttackRangedBest(null, this.agent.entInt));
        this.btAttacking.add(selCombat);
    }

    public void initProfile(int profileType) {
        this.initDefaultProfile();
    }

    public void syncAbilitiesFull(boolean rangeOverride) {
        System.out.println("full sync abilities - " + this.agent.ent);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("command", "syncAbilities");
        nbt.func_74768_a("entityID", this.agent.ent.func_145782_y());
        nbt.func_74782_a("abilities", (NBTBase)CoroUtilAbility.nbtSaveAbilities(this.abilities));
        FMLProxyPacket packet = PacketHelper.getNBTPacket(nbt, CoroAI.eventChannelName);
        if (rangeOverride) {
            CoroAI.eventChannel.sendToDimension(packet, this.agent.ent.field_70170_p.field_73011_w.field_76574_g);
        } else {
            CoroAI.eventChannel.sendToAllAround(packet, new NetworkRegistry.TargetPoint(this.agent.ent.field_70170_p.field_73011_w.field_76574_g, this.agent.ent.field_70165_t, this.agent.ent.field_70163_u, this.agent.ent.field_70161_v, (double)this.abilitySyncRange));
        }
    }

    public void syncAbility(Ability ability) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("command", "syncAbilities");
        nbt.func_74768_a("entityID", this.agent.ent.func_145782_y());
        nbt.func_74782_a("abilities", (NBTBase)CoroUtilAbility.nbtSyncWriteAbility(ability, false));
        FMLProxyPacket packet = PacketHelper.getNBTPacket(nbt, CoroAI.eventChannelName);
        CoroAI.eventChannel.sendToAllAround(packet, new NetworkRegistry.TargetPoint(this.agent.ent.field_70170_p.field_73011_w.field_76574_g, this.agent.ent.field_70165_t, this.agent.ent.field_70163_u, this.agent.ent.field_70161_v, (double)this.abilitySyncRange));
    }

    public void nbtSyncRead(NBTTagCompound par1nbtTagCompound) {
    }

    public void nbtRead(NBTTagCompound par1nbtTagCompound) {
    }

    public void nbtWrite(NBTTagCompound par1nbtTagCompound) {
        par1nbtTagCompound.func_74782_a("abilities", (NBTBase)CoroUtilAbility.nbtSaveAbilities(this.abilities));
    }

    public boolean shouldFollowOrders() {
        float healthRatio = this.agent.ent.func_110143_aJ() / this.agent.ent.func_110138_aP();
        return !(healthRatio < 1.0f - (this.loyalty_job + this.aggression) / 2.0f);
    }

    public boolean shouldTrySurvival() {
        float healthRatio = this.agent.ent.func_110143_aJ() / this.agent.ent.func_110138_aP();
        return healthRatio < 1.0f - this.aggression;
    }

    public void updateAttackInfo() {
    }

    public boolean canMelee() {
        boolean hasMeleeSkill;
        boolean bl = hasMeleeSkill = this.listAbilitiesMelee.size() > 0;
        return hasMeleeSkill;
    }

    public boolean canRanged() {
        boolean hasRangedSkill;
        boolean bl = hasRangedSkill = this.listAbilitiesRanged.size() > 0;
        return hasRangedSkill;
    }

    public boolean shouldMelee(float curRange) {
        return this.canMelee();
    }

    public boolean shouldRanged(float curRange) {
        return this.canRanged();
    }

    public void abilityStart(Ability ability, Entity parTarget) {
        ability.reset();
        ability.setTarget(parTarget);
        ability.setActive();
        this.syncAbility(ability);
    }
}

