/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.componentAI.ICoroAI;
import CoroUtil.entity.IEntityPacket;
import CoroUtil.packet.INBTPacketHandler;
import CoroUtil.packet.NBTDataManager;
import CoroUtil.packet.PacketHelper;
import CoroUtil.tile.ITilePacket;
import CoroUtil.util.CoroUtilEntity;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EventHandlerPacket {
    @SideOnly(value=Side.CLIENT)
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @SideOnly(value=Side.CLIENT)
    public INBTPacketHandler getClientDataInterface() {
        if (Minecraft.func_71410_x().field_71462_r instanceof INBTPacketHandler) {
            return (INBTPacketHandler)Minecraft.func_71410_x().field_71462_r;
        }
        return null;
    }

    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound(event.packet.payload());
            String command = nbt.func_74779_i("command");
            System.out.println("CoroUtil packet command from server: " + command);
            if (command.equals("CoroAI_Inv")) {
                int entID = nbt.func_74762_e("entID");
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemstack"));
                Entity entity = this.getClientWorld().func_73045_a(entID);
                if (entity instanceof ICoroAI && entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70062_b(0, is);
                }
            } else if (!command.equals("CoroAI_TEntDW")) {
                if (command.equals("NBTData_GUI")) {
                    NBTDataManager.nbtDataFromServer(nbt);
                } else if (command.equals("NBTData_CONT")) {
                    INBTPacketHandler nbtHandler = this.getClientDataInterface();
                    if (nbtHandler != null) {
                        nbtHandler.nbtDataFromServer(nbt);
                    }
                } else if (command.equals("CoroAI_Ent")) {
                    int entID = nbt.func_74762_e("entityID");
                    Entity entity = this.getClientWorld().func_73045_a(entID);
                    if (entity instanceof IEntityPacket) {
                        ((IEntityPacket)entity).handleNBTFromServer(nbt);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP entP = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound(event.packet.payload());
            String command = nbt.func_74779_i("command");
            System.out.println("CoroUtil packet command from client: " + command);
            if (command.equals("CoroAI_TEntCmd")) {
                TileEntity tEnt;
                int dimID = nbt.func_74762_e("dimID");
                int x = nbt.func_74762_e("x");
                int y = nbt.func_74762_e("y");
                int z = nbt.func_74762_e("z");
                NBTTagCompound nbtData = nbt.func_74775_l("data");
                WorldServer world = DimensionManager.getWorld((int)dimID);
                if (world != null && (tEnt = world.func_147438_o(x, y, z)) instanceof ITilePacket) {
                    ((ITilePacket)tEnt).handleClientSentNBT(CoroUtilEntity.getName((Entity)entP), nbt);
                }
            } else if (command.equals("NBTData_CONT")) {
                if (entP.field_71070_bA instanceof INBTPacketHandler) {
                    ((INBTPacketHandler)entP.field_71070_bA).nbtDataFromClient(CoroUtilEntity.getName((Entity)entP), nbt);
                }
            } else if (command.equals("NBTData_GUI")) {
                NBTDataManager.nbtDataFromClient(CoroUtilEntity.getName((Entity)entP), nbt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

