/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.pathfinding;

import net.minecraft.util.MathHelper;

public class PathPointEx {
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    public final int hash;
    public int index = -1;
    public float totalPathDistance;
    public float distanceToNext;
    public float distanceToTarget;
    public PathPointEx previous;
    public boolean isFirst = false;

    public PathPointEx(int i, int j, int k) {
        this.xCoord = i;
        this.yCoord = j;
        this.zCoord = k;
        this.hash = PathPointEx.makeHash(i, j, k);
    }

    public static int makeHash(int i, int j, int k) {
        return j & 0xFF | (i & Short.MAX_VALUE) << 8 | (k & Short.MAX_VALUE) << 24 | (i >= 0 ? 0 : Integer.MIN_VALUE) | (k >= 0 ? 0 : 32768);
    }

    public float distanceTo(PathPointEx pathpoint) {
        float f = pathpoint.xCoord - this.xCoord;
        float f1 = pathpoint.yCoord - this.yCoord;
        float f2 = pathpoint.zCoord - this.zCoord;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathPointEx) {
            PathPointEx pathpoint = (PathPointEx)obj;
            return this.hash == pathpoint.hash && this.xCoord == pathpoint.xCoord && this.yCoord == pathpoint.yCoord && this.zCoord == pathpoint.zCoord;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAssigned() {
        return this.index >= 0;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord;
    }
}

