/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest.quests;

import CoroUtil.quest.EnumQuestState;
import CoroUtil.quest.quests.ActiveQuest;
import CoroUtil.util.CoroUtilItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class ItemQuest
extends ActiveQuest {
    public String neededItemID;
    public int neededItemCount;
    public boolean returnToQuestGiver;
    public int curItemCount;

    public ItemQuest() {
        this.questType = "getItem";
    }

    public void initCustomData(String itemID, int count, boolean parReturnToQuestGiver) {
        super.initCustomData();
        this.neededItemID = itemID;
        this.neededItemCount = count;
        this.returnToQuestGiver = parReturnToQuestGiver;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.curState == EnumQuestState.ASSIGNED) {
            if (this.curItemCount >= this.neededItemCount) {
                if (this.returnToQuestGiver) {
                    this.setState(EnumQuestState.CONCLUDING);
                } else {
                    this.setState(EnumQuestState.COMPLETE);
                }
            }
        } else if (this.curState == EnumQuestState.CONCLUDING) {
            // empty if block
        }
    }

    public void pickupEvent(EntityItemPickupEvent event) {
        if (event.entityPlayer.equals((Object)this.playerQuests.getPlayer()) && CoroUtilItem.getNameByItem(event.item.func_92059_d().func_77973_b()).equals(this.neededItemID)) {
            ++this.curItemCount;
            this.saveAndSync();
            System.out.println("quest item inc");
        }
    }

    @Override
    public void eventComplete() {
        super.eventComplete();
    }

    @Override
    public void load(NBTTagCompound parNBT) {
        super.load(parNBT);
        this.neededItemID = parNBT.func_74779_i("neededItemID");
        this.neededItemCount = parNBT.func_74762_e("neededItemCount");
        this.returnToQuestGiver = parNBT.func_74767_n("returnToQuestGiver");
    }

    @Override
    public void save(NBTTagCompound parNBT) {
        super.save(parNBT);
        parNBT.func_74778_a("neededItemID", this.neededItemID);
        parNBT.func_74768_a("neededItemCount", this.neededItemCount);
        parNBT.func_74757_a("returnToQuestGiver", this.returnToQuestGiver);
    }
}

