/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.ability.Ability;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CoroUtilAbility {
    public static NBTTagCompound nbtSyncWriteAbility(String abilityName, ConcurrentHashMap<String, Ability> abilities, boolean fullSync) {
        NBTTagCompound nbt = new NBTTagCompound();
        Ability ability = abilities.get(abilityName);
        if (ability != null) {
            nbt = CoroUtilAbility.nbtSyncWriteAbility(ability, fullSync);
        } else {
            System.out.println("Error: failed to find ability to sync: " + abilityName);
        }
        return nbt;
    }

    public static NBTTagCompound nbtSyncWriteAbility(Ability ability, boolean fullSync) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (fullSync) {
            nbt.func_74782_a(ability.name, (NBTBase)ability.nbtSave());
        } else {
            nbt.func_74782_a(ability.name, (NBTBase)ability.nbtSyncWrite());
        }
        return nbt;
    }

    public static NBTTagCompound nbtSyncWriteAbilities(ConcurrentHashMap<String, Ability> abilities) {
        return CoroUtilAbility.nbtWriteAbilities(abilities, true);
    }

    public static NBTTagCompound nbtSaveAbilities(ConcurrentHashMap<String, Ability> abilities) {
        return CoroUtilAbility.nbtWriteAbilities(abilities, false);
    }

    public static NBTTagCompound nbtWriteAbilities(ConcurrentHashMap<String, Ability> abilities, boolean syncOnly) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<String, Ability> entry : abilities.entrySet()) {
            if (syncOnly) {
                nbt.func_74782_a(entry.getValue().name, (NBTBase)entry.getValue().nbtSyncWrite());
                continue;
            }
            nbt.func_74782_a(entry.getValue().name, (NBTBase)entry.getValue().nbtSave());
        }
        return nbt;
    }
}

