/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.api.weather.WindHandler;
import CoroUtil.entity.EntityTropicalFishHook;
import extendedrenderer.particle.entity.EntityRotFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import weather2.ClientTickHandler;
import weather2.entity.EntityMovingBlock;
import weather2.util.WeatherUtilParticle;
import weather2.weathersystem.wind.WindManager;

public class WeatherUtilEntity {
    public static int playerInAirTime = 0;

    public static float getWeight(Entity entity1) {
        return WeatherUtilEntity.getWeight(entity1, false);
    }

    public static float getWeight(Entity entity1, boolean forTornado) {
        float var;
        if (entity1 instanceof IWindHandler) {
            return ((IWindHandler)entity1).getWindWeight();
        }
        if (entity1 instanceof WindHandler) {
            return ((WindHandler)entity1).getWindWeight();
        }
        if (entity1 instanceof EntityMovingBlock) {
            return 1.0f + (float)((EntityMovingBlock)entity1).age / 200.0f;
        }
        if (entity1 instanceof EntityPlayer) {
            playerInAirTime = entity1.field_70122_E || entity1.func_70072_I() ? 0 : ++playerInAirTime;
            if (((EntityPlayer)entity1).field_71075_bZ.field_75098_d) {
                return 1.0E8f;
            }
            int extraWeight = 0;
            if (((EntityPlayer)entity1).field_71071_by != null && ((EntityPlayer)entity1).field_71071_by.field_70460_b[2] != null && ((EntityPlayer)entity1).field_71071_by.field_70460_b[2].func_77973_b() == Items.field_151030_Z) {
                extraWeight = 2;
            }
            if (((EntityPlayer)entity1).field_71071_by != null && ((EntityPlayer)entity1).field_71071_by.field_70460_b[2] != null && ((EntityPlayer)entity1).field_71071_by.field_70460_b[2].func_77973_b() == Items.field_151163_ad) {
                extraWeight = 4;
            }
            if (forTornado) {
                return 4.5f + (float)extraWeight + (float)(playerInAirTime / 400);
            }
            return 5.0f + (float)extraWeight + (float)(playerInAirTime / 400);
        }
        if (entity1.field_70170_p.field_72995_K && entity1 instanceof EntityRotFX && (var = WeatherUtilParticle.getParticleWeight((EntityRotFX)entity1)) != -1.0f) {
            return var;
        }
        if (entity1 instanceof EntitySquid) {
            return 400.0f;
        }
        if (entity1 instanceof EntityLivingBase) {
            int airTime = entity1.getEntityData().func_74762_e("timeInAir");
            airTime = entity1.field_70122_E || entity1.func_70072_I() ? 0 : ++airTime;
            entity1.getEntityData().func_74768_a("timeInAir", airTime);
            if (forTornado) {
                return 0.5f + (float)airTime / 800.0f;
            }
            return 500.0f + (entity1.field_70122_E ? 2.0f : 0.0f) + (float)(airTime / 400);
        }
        if (entity1 instanceof EntityBoat || entity1 instanceof EntityItem || entity1 instanceof EntityTropicalFishHook || entity1 instanceof EntityFishHook) {
            return 4000.0f;
        }
        if (entity1 instanceof EntityMinecart) {
            return 80.0f;
        }
        return 1.0f;
    }

    public static boolean canPushEntity(Entity ent) {
        WindManager windMan = ClientTickHandler.weatherManager.windMan;
        double speed = 10.0;
        int startX = (int)(ent.field_70165_t - speed * (double)(-MathHelper.func_76126_a((float)(windMan.getWindAngleForPriority() / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.0f)));
        int startZ = (int)(ent.field_70161_v - speed * (double)(MathHelper.func_76134_b((float)(windMan.getWindAngleForPriority() / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.0f)));
        if (ent instanceof EntityPlayer) {
            boolean bool = true;
        }
        return ent.field_70170_p.func_72933_a(Vec3.func_72443_a((double)ent.field_70165_t, (double)(ent.field_70163_u + (double)ent.func_70047_e()), (double)ent.field_70161_v), Vec3.func_72443_a((double)startX, (double)(ent.field_70163_u + (double)ent.func_70047_e()), (double)startZ)) == null;
    }

    public static boolean isEntityOutside(Entity parEnt) {
        return WeatherUtilEntity.isEntityOutside(parEnt, false);
    }

    public static boolean isEntityOutside(Entity parEnt, boolean cheapCheck) {
        return WeatherUtilEntity.isPosOutside(parEnt.field_70170_p, Vec3.func_72443_a((double)parEnt.field_70165_t, (double)parEnt.field_70163_u, (double)parEnt.field_70161_v), cheapCheck);
    }

    public static boolean isPosOutside(World parWorld, Vec3 parPos) {
        return WeatherUtilEntity.isPosOutside(parWorld, parPos, false);
    }

    public static boolean isPosOutside(World parWorld, Vec3 parPos, boolean cheapCheck) {
        int rangeCheck = 5;
        boolean yOffset = true;
        if ((double)parWorld.func_72976_f(MathHelper.func_76128_c((double)parPos.field_72450_a), MathHelper.func_76128_c((double)parPos.field_72449_c)) < parPos.field_72448_b + 1.0) {
            return true;
        }
        if (cheapCheck) {
            return false;
        }
        Vec3 vecTry = Vec3.func_72443_a((double)(parPos.field_72450_a + (double)(ForgeDirection.NORTH.offsetX * rangeCheck)), (double)(parPos.field_72448_b + (double)yOffset), (double)(parPos.field_72449_c + (double)(ForgeDirection.NORTH.offsetZ * rangeCheck)));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = Vec3.func_72443_a((double)(parPos.field_72450_a + (double)(ForgeDirection.SOUTH.offsetX * rangeCheck)), (double)(parPos.field_72448_b + (double)yOffset), (double)(parPos.field_72449_c + (double)(ForgeDirection.SOUTH.offsetZ * rangeCheck)));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = Vec3.func_72443_a((double)(parPos.field_72450_a + (double)(ForgeDirection.EAST.offsetX * rangeCheck)), (double)(parPos.field_72448_b + (double)yOffset), (double)(parPos.field_72449_c + (double)(ForgeDirection.EAST.offsetZ * rangeCheck)));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = Vec3.func_72443_a((double)(parPos.field_72450_a + (double)(ForgeDirection.WEST.offsetX * rangeCheck)), (double)(parPos.field_72448_b + (double)yOffset), (double)(parPos.field_72449_c + (double)(ForgeDirection.WEST.offsetZ * rangeCheck)));
        return WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry);
    }

    public static boolean checkVecOutside(World parWorld, Vec3 parPos, Vec3 parCheckPos) {
        boolean dirNorth;
        boolean bl = dirNorth = parWorld.func_72933_a(parPos, parCheckPos) == null;
        return dirNorth && (double)parWorld.func_72976_f(MathHelper.func_76128_c((double)parCheckPos.field_72450_a), MathHelper.func_76128_c((double)parCheckPos.field_72449_c)) < parCheckPos.field_72448_b;
    }
}

