/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt.entity;

import CoroUtil.ability.Ability;
import CoroUtil.ability.IAbilityUser;
import CoroUtil.bt.AIBTAgent;
import CoroUtil.bt.IBTAgent;
import CoroUtil.entity.IEntityPacket;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityMobBase
extends EntityMob
implements IBTAgent,
IAbilityUser,
IEntityPacket {
    public AIBTAgent agent;

    public EntityMobBase(World par1World) {
        super(par1World);
        this.initAIProfile();
        this.agent.initBTTemplate();
    }

    protected boolean func_70650_aV() {
        return true;
    }

    @Override
    public AIBTAgent getAIBTAgent() {
        return this.agent;
    }

    @Override
    public EntityLivingBase getEntityLiving() {
        return this;
    }

    @Override
    public void cleanup() {
        this.agent = null;
    }

    @Override
    public Ability activateAbility(String ability, Object ... objects) {
        Ability abilityObj = this.agent.profile.abilities.get(ability);
        if (abilityObj != null) {
            abilityObj.setActive();
        }
        return abilityObj;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        this.initRPGStats();
        return super.func_110161_a(this.getAIBTAgent().onSpawnEvent(par1EntityLivingData));
    }

    @Override
    public ConcurrentHashMap getAbilities() {
        return this.agent.profile.abilities;
    }

    public void checkAgent() {
        if (this.agent == null) {
            this.agent = new AIBTAgent(this);
        }
    }

    public void initRPGStats() {
    }

    public void initAIProfile() {
        this.agent.profile.init();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.agent.setSpeedNormalBase(0.3f);
        this.agent.applyEntityAttributes();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public void func_70619_bc() {
        this.agent.tickAI();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.checkAgent();
        this.agent.entityInit();
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        this.checkAgent();
        return this.agent.eventHandler.interact(par1EntityPlayer);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        this.checkAgent();
        if (!(this.field_70170_p.field_72995_K || this.agent != null && this.agent.ent != null)) {
            return false;
        }
        boolean result = this.agent.eventHandler.attackEntityFrom(par1DamageSource, par2);
        if (result) {
            return true;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.checkAgent();
        this.agent.nbtRead(par1nbtTagCompound);
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        this.agent.nbtWrite(par1nbtTagCompound);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.agent.tickLiving();
    }

    @Override
    public void handleNBTFromClient(NBTTagCompound par1nbtTagCompound) {
    }

    @Override
    public void handleNBTFromServer(NBTTagCompound par1nbtTagCompound) {
        this.agent.nbtDataFromServer(par1nbtTagCompound);
    }
}

