/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.componentAI.jobSystem;

import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumJobState;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

public class JobHunt
extends JobBase {
    public long huntRange = 24L;
    public boolean xRay = false;

    public JobHunt(JobManager jm) {
        super(jm);
    }

    @Override
    public void tick() {
        super.tick();
        this.jobHunter();
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public boolean shouldContinue() {
        return this.ai.entityToAttack == null || this.ai.entityToAttack.func_70032_d((Entity)this.ent) > (float)this.huntRange;
    }

    @Override
    public void onLowHealth() {
        super.onLowHealth();
        if (this.hitAndRunDelay == 0 && this.ent.func_70032_d(this.ai.lastFleeEnt) > 3.0f) {
            this.hitAndRunDelay = this.entInt.getCooldownRanged() + 1;
            this.ai.entityToAttack = this.ai.lastFleeEnt;
            if (this.ai.entityToAttack != null) {
                this.ai.faceEntity(this.ai.entityToAttack, 180.0f, 180.0f);
                this.entInt.attackRanged(this.ai.entityToAttack, this.ent.func_70032_d(this.ai.lastFleeEnt));
            }
        }
    }

    @Override
    public boolean hookHit(DamageSource ds, int damage) {
        if (this.ai.retaliateEnable) {
            this.ai.setTargetRetaliate(ds.func_76346_g());
        }
        if (this.ent.func_110143_aJ() < this.ent.func_110138_aP() / 2.0f) {
            // empty if block
        }
        return true;
    }

    @Override
    public void setJobItems() {
    }

    protected void jobHunter() {
        EntityPlayer entP;
        this.ai.maxDistanceFromHome = 48.0;
        this.setJobState(EnumJobState.IDLE);
        EntityLiving protectEnt = this.ent;
        if (this.tamable.isTame() && (entP = this.ent.field_70170_p.func_72924_a(this.tamable.owner)) != null) {
            protectEnt = entP;
        }
        if (this.ai.entityToAttack == null || this.ai.rand.nextInt(20) == 0) {
            boolean found = false;
            Entity clEnt = null;
            float closest = 9999.0f;
            List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, protectEnt.field_70121_D.func_72314_b((double)this.huntRange, (double)(this.huntRange / 2L), (double)this.huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (!this.isEnemy(entity1) || !this.xRay && !((EntityLivingBase)entity1).func_70685_l((Entity)protectEnt) || !this.sanityCheck(entity1) || !((dist = protectEnt.func_70032_d(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                if (this.ai.entityToAttack != clEnt) {
                    this.ai.huntTarget(clEnt);
                } else {
                    this.ai.huntTarget(clEnt);
                }
            }
        } else if (this.ai.entityToAttack != null && this.ent.func_70661_as().func_75500_f() && this.ent.field_70170_p.func_72820_D() % 10L == 0L) {
            this.ai.huntTarget(this.ai.entityToAttack);
        }
        this.ent.field_70735_aL = this.ent.func_110143_aJ();
    }

    @Override
    public boolean sanityCheckHelp(Entity caller, Entity target) {
        if (this.ai.shouldAvoid && this.ent.func_110143_aJ() < 10.0f) {
            return false;
        }
        if (this.dontStrayFromHome && target.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) > this.ai.maxDistanceFromHome * 1.5) {
            return false;
        }
        return this.ai.rand.nextInt(2) == 0;
    }

    @Override
    public boolean sanityCheck(Entity target) {
        EntityPlayer entP;
        if (this.ai.shouldAvoid && this.ent.func_110143_aJ() < 6.0f) {
            return false;
        }
        if (this.dontStrayFromHome && target.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) > this.ai.maxDistanceFromHome) {
            return false;
        }
        return !this.dontStrayFromOwner || !this.tamable.isTame() || (entP = this.ai.ent.field_70170_p.func_72924_a(this.tamable.owner)) == null || !((double)entP.func_70032_d(target) > this.tamable.strayDistMax);
    }
}

