/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.componentAI.jobSystem;

import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumJobState;
import CoroUtil.pathfinding.PFQueue;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class JobHuntRanged
extends JobBase {
    public long huntRange = 24L;
    public long keepDistantRange = 14L;
    public boolean xRay = false;
    public boolean useMelee = false;
    public int useMeleeCountdown = 0;
    public int useMeleeCountdownMax = 80;
    public Vec3 targetLastPos = null;
    public int targetNoMoveTicks = 0;
    public int targetNoMoveTicksMax = 4;

    public JobHuntRanged(JobManager jm) {
        super(jm);
    }

    @Override
    public void tick() {
        super.tick();
        this.jobHunter();
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public boolean shouldContinue() {
        return this.ai.entityToAttack == null || this.ai.entityToAttack.func_70032_d((Entity)this.ent) > (float)this.huntRange;
    }

    @Override
    public void onLowHealth() {
        super.onLowHealth();
        if (this.hitAndRunDelay == 0 && this.ent.func_70032_d(this.ai.lastFleeEnt) > 3.0f) {
            this.hitAndRunDelay = this.entInt.getCooldownRanged() + 1;
            this.ai.entityToAttack = this.ai.lastFleeEnt;
            if (this.ai.entityToAttack != null) {
                this.ai.faceEntity(this.ai.entityToAttack, 180.0f, 180.0f);
                this.entInt.attackRanged(this.ai.entityToAttack, this.ent.func_70032_d(this.ai.lastFleeEnt));
            }
        } else {
            this.ai.entityToAttack = null;
        }
    }

    @Override
    public boolean shouldTickCloseCombat() {
        if (!this.useMelee) {
            return false;
        }
        return super.shouldTickCloseCombat();
    }

    @Override
    public boolean hookHit(DamageSource ds, int damage) {
        if (this.isEnemy(ds.func_76346_g())) {
            this.ai.entityToAttack = ds.func_76346_g();
        }
        return true;
    }

    @Override
    public void setJobItems() {
    }

    @Override
    public boolean checkDangers() {
        if (!this.useMelee && this.ai.entityToAttack != null && this.ai.entityToAttack.func_70032_d((Entity)this.ai.ent) < (float)(this.keepDistantRange - 2L)) {
            return true;
        }
        return this.checkHealth();
    }

    protected void jobHunter() {
        this.dontStrayFromHome = false;
        this.ai.maxDistanceFromHome = 48.0;
        if (this.ai.entityToAttack != null && this.targetLastPos != null) {
            if (this.ent.field_70170_p.func_72820_D() % 10L == 0L) {
                this.targetNoMoveTicks = this.ai.entityToAttack.func_70011_f(this.targetLastPos.field_72450_a, this.targetLastPos.field_72448_b, this.targetLastPos.field_72449_c) < 0.5 ? ++this.targetNoMoveTicks : 0;
            }
            if (this.targetNoMoveTicks >= this.targetNoMoveTicksMax) {
                this.useMeleeCountdown = this.useMeleeCountdownMax;
            }
        } else {
            this.useMeleeCountdown = 0;
        }
        if (this.useMeleeCountdown > 0) {
            --this.useMeleeCountdown;
            this.useMelee = true;
        } else {
            this.useMelee = false;
        }
        this.setJobState(EnumJobState.IDLE);
        if (this.ent.func_110143_aJ() > this.ent.func_110138_aP() * 0.9f && (this.ai.entityToAttack == null || this.ai.rand.nextInt(20) == 0)) {
            boolean found = false;
            Entity clEnt = null;
            float closest = 9999.0f;
            List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b((double)this.huntRange, (double)(this.huntRange / 2L), (double)this.huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (!this.isEnemy(entity1) || !this.xRay && !((EntityLivingBase)entity1).func_70685_l((Entity)this.ent) || !this.sanityCheck(entity1) || !((dist = this.ent.func_70032_d(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                if (this.ai.entityToAttack != clEnt) {
                    this.ai.setTarget(clEnt);
                } else {
                    this.ai.setTarget(clEnt);
                }
            }
        } else if (this.ai.entityToAttack != null) {
            if (!this.useMelee && this.ai.entityToAttack.func_70032_d((Entity)this.ent) < (float)this.keepDistantRange) {
                this.ent.func_70661_as().func_75499_g();
            }
            if (this.ent.func_70661_as().func_75500_f() && (this.ent.func_70032_d(this.ai.entityToAttack) > (float)(this.keepDistantRange + 1L) || this.useMelee)) {
                PFQueue.getPath((Entity)this.ent, this.ai.entityToAttack, this.ai.maxPFRange);
            } else if (!this.useMelee && !this.ai.fleeing && this.ai.entityToAttack.func_70032_d((Entity)this.ent) < (float)this.keepDistantRange) {
                this.ent.func_70661_as().func_75499_g();
            }
        }
        if (this.ent.field_70170_p.func_72820_D() % 10L == 0L && this.ai.entityToAttack != null) {
            this.targetLastPos = Vec3.func_72443_a((double)this.ai.entityToAttack.field_70165_t, (double)this.ai.entityToAttack.field_70163_u, (double)this.ai.entityToAttack.field_70161_v);
        }
        this.ent.field_70735_aL = this.ent.func_110143_aJ();
    }

    @Override
    public boolean sanityCheckHelp(Entity caller, Entity target) {
        if (this.ent.func_110143_aJ() < 10.0f) {
            return false;
        }
        if (this.dontStrayFromHome && target.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) > this.ai.maxDistanceFromHome * 1.5) {
            return false;
        }
        return this.ai.rand.nextInt(2) == 0;
    }

    @Override
    public boolean sanityCheck(Entity target) {
        if (this.ent.func_110143_aJ() < 6.0f) {
            return false;
        }
        return !this.dontStrayFromHome || !(target.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) > this.ai.maxDistanceFromHome);
    }
}

