/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.playerdata;

import CoroUtil.playerdata.IPlayerData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerDataObject {
    public String username;
    public HashMap<String, IPlayerData> playerData = new HashMap();
    public HashMap<IPlayerData, String> playerDataReverseLookup = new HashMap();
    public ArrayList tickList = new ArrayList();

    public PlayerDataObject(String parUsername) {
        this.username = parUsername;
    }

    public void addObject(String name, IPlayerData ipd) {
        this.playerData.put(name, ipd);
        this.playerDataReverseLookup.put(ipd, name);
    }

    public IPlayerData get(String objectName) {
        return this.playerData.get(objectName);
    }

    public void nbtLoadAll(NBTTagCompound parNBT) {
        for (Map.Entry<String, IPlayerData> pairs : this.playerData.entrySet()) {
            String entryModule = pairs.getKey();
            IPlayerData pdo = pairs.getValue();
            pdo.init(this.username);
            NBTTagCompound nbt = parNBT.func_74775_l(entryModule);
            if (nbt != null) {
                pdo.nbtLoad(nbt);
                continue;
            }
            System.out.println("fresh!");
        }
    }

    public void nbtSyncAll(NBTTagCompound parNBT) {
        NBTTagCompound data = new NBTTagCompound();
        for (Map.Entry<String, IPlayerData> pairs : this.playerData.entrySet()) {
            String entryModule = pairs.getKey();
            IPlayerData pdo = pairs.getValue();
            NBTTagCompound nbt = data.func_74775_l(entryModule);
            if (nbt == null) continue;
            pdo.nbtSyncFromServer(nbt);
        }
    }
}

