/*
 * Decompiled with CFR 0.152.
 */
package weather2.client;

import CoroUtil.OldUtil;
import CoroUtil.api.weather.WindHandler;
import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.EntityTexBiomeColorFX;
import extendedrenderer.particle.entity.EntityTexFX;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import weather2.ClientTickHandler;
import weather2.Weather;
import weather2.api.WindReader;
import weather2.client.entity.particle.EntityFallingRainFX;
import weather2.client.entity.particle.EntityFallingSnowFX;
import weather2.client.entity.particle.EntityWaterfallFX;
import weather2.config.ConfigMisc;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilConfig;
import weather2.util.WeatherUtilEntity;
import weather2.util.WeatherUtilParticle;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.wind.WindManager;

@SideOnly(value=Side.CLIENT)
public class SceneEnhancer
implements Runnable {
    public World lastWorldDetected = null;
    public static ParticleBehaviors pm;
    public static List<EntityFX> spawnQueueNormal;
    public static List<Entity> spawnQueue;
    public static long threadLastWorldTickTime;
    public static int lastTickFoundBlocks;
    public static long lastTickAmbient;
    public static ArrayList<ChunkCoordinatesBlock> soundLocations;
    public static HashMap<ChunkCoordinatesBlock, Long> soundTimeLocations;
    public static Block SOUNDMARKER_WATER;
    public static Block SOUNDMARKER_LEAVES;
    public static float curPrecipStr;
    public static float curPrecipStrTarget;
    public static float curOvercastStr;
    public static float curOvercastStrTarget;

    public SceneEnhancer() {
        pm = new ParticleBehaviors(null);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.tickClientThreaded();
                    Thread.sleep(ConfigMisc.Thread_Particle_Process_Delay);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void tickClient() {
        if (!WeatherUtil.isPaused()) {
            this.tryParticleSpawning();
            this.tickParticlePrecipitation();
            Minecraft mc = FMLClientHandler.instance().getClient();
            SceneEnhancer.tryWind((World)mc.field_71441_e);
        }
    }

    public void tickClientThreaded() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e != null && this.lastWorldDetected != mc.field_71441_e) {
            this.lastWorldDetected = mc.field_71441_e;
            this.reset();
        }
        if (mc.field_71441_e != null && mc.field_71439_g != null && WeatherUtilConfig.listDimensionsWindEffects.contains(mc.field_71441_e.field_73011_w.field_76574_g)) {
            this.profileSurroundings();
            SceneEnhancer.tryAmbientSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void tryAmbientSounds() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient worldRef = mc.field_71441_e;
        EntityClientPlayerMP player = mc.field_71439_g;
        Random rand = new Random();
        if (lastTickAmbient < System.currentTimeMillis()) {
            lastTickAmbient = System.currentTimeMillis() + 500L;
            int size = 32;
            int hsize = size / 2;
            int curX = (int)player.field_70165_t;
            int curY = (int)player.field_70163_u;
            int curZ = (int)player.field_70161_v;
            for (int i = 0; i < soundLocations.size(); ++i) {
                ChunkCoordinatesBlock cCor = soundLocations.get(i);
                if (Math.sqrt(cCor.func_71569_e(curX, curY, curZ)) > (double)size) {
                    soundLocations.remove(i--);
                    soundTimeLocations.remove(cCor);
                    continue;
                }
                Block block = SceneEnhancer.getBlock((World)worldRef, cCor.field_71574_a, cCor.field_71572_b, cCor.field_71573_c);
                if (block == null || block.func_149688_o() != Material.field_151586_h && block.func_149688_o() != Material.field_151584_j) {
                    soundLocations.remove(i);
                    soundTimeLocations.remove(cCor);
                    continue;
                }
                long lastPlayTime = 0L;
                if (soundTimeLocations.containsKey(cCor)) {
                    lastPlayTime = soundTimeLocations.get(cCor);
                }
                if (lastPlayTime >= System.currentTimeMillis()) continue;
                if (cCor.block == SOUNDMARKER_WATER) {
                    soundTimeLocations.put(cCor, System.currentTimeMillis() + 2500L + (long)rand.nextInt(50));
                    mc.field_71441_e.func_72980_b((double)cCor.field_71574_a, (double)cCor.field_71572_b, (double)cCor.field_71573_c, Weather.modID + ":env.waterfall", (float)ConfigMisc.volWaterfallScale, 0.75f + rand.nextFloat() * 0.05f, false);
                    System.out.println("play waterfall at: " + cCor.field_71574_a + " - " + cCor.field_71572_b + " - " + cCor.field_71573_c);
                    continue;
                }
                if (cCor.block != SOUNDMARKER_LEAVES) continue;
                float windSpeed = WindReader.getWindSpeed((World)mc.field_71441_e, Vec3.func_72443_a((double)cCor.field_71574_a, (double)cCor.field_71572_b, (double)cCor.field_71573_c), WindReader.WindType.EVENT);
                if (windSpeed > 0.2f) {
                    soundTimeLocations.put(cCor, System.currentTimeMillis() + 12000L + (long)rand.nextInt(50));
                    mc.field_71441_e.func_72980_b((double)cCor.field_71574_a, (double)cCor.field_71572_b, (double)cCor.field_71573_c, Weather.modID + ":env.wind_calmfade", (float)((double)(windSpeed * 4.0f) * ConfigMisc.volWindTreesScale), 0.7f + rand.nextFloat() * 0.1f, false);
                    continue;
                }
                windSpeed = WindReader.getWindSpeed((World)mc.field_71441_e, Vec3.func_72443_a((double)cCor.field_71574_a, (double)cCor.field_71572_b, (double)cCor.field_71573_c));
                if (mc.field_71441_e.field_73012_v.nextInt(15) != 0) continue;
                soundTimeLocations.put(cCor, System.currentTimeMillis() + 12000L + (long)rand.nextInt(50));
                mc.field_71441_e.func_72980_b((double)cCor.field_71574_a, (double)cCor.field_71572_b, (double)cCor.field_71573_c, Weather.modID + ":env.wind_calmfade", (float)((double)(windSpeed * 2.0f) * ConfigMisc.volWindTreesScale), 0.7f + rand.nextFloat() * 0.1f, false);
            }
            for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
                for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                    for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                        Block block = SceneEnhancer.getBlock((World)worldRef, xx, yy, zz);
                        if (block == null) continue;
                        if (ConfigMisc.Wind_Particle_waterfall && block.func_149688_o() == Material.field_151586_h) {
                            Block id2;
                            int meta = SceneEnhancer.getBlockMetadata((World)worldRef, xx, yy, zz);
                            if ((meta & 8) == 0) continue;
                            int bottomY = yy;
                            int index = 0;
                            while (yy - index > 0 && ((id2 = SceneEnhancer.getBlock((World)worldRef, xx, yy - index, zz)) == null || id2.func_149688_o() == Material.field_151586_h)) {
                                ++index;
                            }
                            bottomY = yy - index + 1;
                            int meta2 = SceneEnhancer.getBlockMetadata((World)worldRef, xx, bottomY + 10, zz);
                            Block block2 = SceneEnhancer.getBlock((World)worldRef, xx, bottomY + 10, zz);
                            if (index < 4 || block2 == null || block2.func_149688_o() != Material.field_151586_h || (meta2 & 8) == 0) continue;
                            boolean proxFail = false;
                            for (int j = 0; j < soundLocations.size(); ++j) {
                                if (!(Math.sqrt(soundLocations.get(j).func_71569_e(xx, bottomY, zz)) < 5.0)) continue;
                                proxFail = true;
                                break;
                            }
                            if (proxFail) continue;
                            soundLocations.add(new ChunkCoordinatesBlock(xx, bottomY, zz, SOUNDMARKER_WATER, 0));
                            continue;
                        }
                        if (!(ConfigMisc.volWindTreesScale > 0.0) || block.func_149688_o() != Material.field_151584_j) continue;
                        boolean proxFail = false;
                        for (int j = 0; j < soundLocations.size(); ++j) {
                            if (!(Math.sqrt(soundLocations.get(j).func_71569_e(xx, yy, zz)) < 15.0)) continue;
                            proxFail = true;
                            break;
                        }
                        if (proxFail) continue;
                        soundLocations.add(new ChunkCoordinatesBlock(xx, yy, zz, SOUNDMARKER_LEAVES, 0));
                    }
                }
            }
        }
    }

    public void reset() {
        if (ExtendedRenderer.rotEffRenderer != null) {
            for (int i = 0; i < ExtendedRenderer.rotEffRenderer.layers; ++i) {
                if (ExtendedRenderer.rotEffRenderer.fxLayers[i] == null) continue;
                ExtendedRenderer.rotEffRenderer.fxLayers[i].clear();
            }
        }
        this.lastWorldDetected.field_73007_j.clear();
        WeatherUtilParticle.getFXLayers();
    }

    public void tickParticlePrecipitation() {
        block3: {
            float maxPrecip;
            float curPrecipVal;
            EntityClientPlayerMP entP;
            block4: {
                if (!ConfigMisc.Particle_RainSnow) break block3;
                entP = FMLClientHandler.instance().getClient().field_71439_g;
                curPrecipVal = SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)entP);
                maxPrecip = 0.5f;
                int precipitationHeight = entP.field_70170_p.func_72874_g(MathHelper.func_76128_c((double)entP.field_70165_t), MathHelper.func_76128_c((double)entP.field_70161_v));
                BiomeGenBase biomegenbase = entP.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)entP.field_70165_t), MathHelper.func_76128_c((double)entP.field_70161_v));
                float temperature = biomegenbase.func_150564_a(MathHelper.func_76128_c((double)entP.field_70165_t), MathHelper.func_76128_c((double)entP.field_70163_u), MathHelper.func_76128_c((double)entP.field_70161_v));
                if (!(entP.field_70170_p.func_72959_q().func_76939_a(temperature, precipitationHeight) >= 0.15f)) break block4;
                if (!((curPrecipVal = Math.min(maxPrecip, Math.abs(curPrecipVal))) > 0.0f) || !entP.field_70170_p.func_72951_B(MathHelper.func_76128_c((double)entP.field_70165_t), MathHelper.func_76128_c((double)entP.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)entP.field_70161_v))) break block3;
                int i = 0;
                while ((double)i < (double)(curPrecipVal * 20.0f) * ConfigMisc.Particle_Precipitation_effect_rate) {
                    int spawnAreaSize = 15;
                    EntityFallingRainFX ent = new EntityFallingRainFX(entP.field_70170_p, entP.field_70165_t + (double)entP.field_70170_p.field_73012_v.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u + 15.0, entP.field_70161_v + (double)entP.field_70170_p.field_73012_v.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), 0.0, -5.0 - (double)entP.field_70170_p.field_73012_v.nextInt(5) * -1.0, 0.0, 1.5, 3);
                    ent.severityOfRainRate = (int)(curPrecipVal * 5.0f);
                    ent.field_70155_l = 1.0;
                    ent.func_70105_a(1.2f, 1.2f);
                    ent.field_70177_z = (float)ent.field_70170_p.field_73012_v.nextInt(360) - 180.0f;
                    ent.setGravity(1.0E-5f);
                    ent.spawnAsWeatherEffect();
                    ++i;
                }
                break block3;
            }
            if ((curPrecipVal = Math.min(maxPrecip, Math.abs(curPrecipVal))) > 0.0f) {
                int i = 0;
                while ((double)i < (double)(curPrecipVal * 5.0f) * ConfigMisc.Particle_Precipitation_effect_rate) {
                    int spawnAreaSize = 50;
                    int spawnAbove = 10;
                    EntityFallingSnowFX ent = new EntityFallingSnowFX(entP.field_70170_p, entP.field_70165_t + (double)entP.field_70170_p.field_73012_v.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u + (double)spawnAbove, entP.field_70161_v + (double)entP.field_70170_p.field_73012_v.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), 0.0, -5.0 - (double)entP.field_70170_p.field_73012_v.nextInt(5) * -1.0, 0.0, 5.5, 6);
                    ent.severityOfRainRate = (int)(curPrecipVal * 5.0f);
                    ent.field_70155_l = 1.0;
                    ent.func_70105_a(1.2f, 1.2f);
                    ent.field_70177_z = (float)ent.field_70170_p.field_73012_v.nextInt(360) - 180.0f;
                    ent.setGravity(1.0E-5f);
                    ent.spawnAsWeatherEffect();
                    ++i;
                }
            }
        }
    }

    public static float getRainStrengthAndControlVisuals(EntityPlayer entP) {
        return SceneEnhancer.getRainStrengthAndControlVisuals(entP, false);
    }

    public static float getRainStrengthAndControlVisuals(EntityPlayer entP, boolean forOvercast) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        double maxStormDist = 384.0;
        Vec3 plPos = Vec3.func_72443_a((double)entP.field_70165_t, (double)StormObject.static_YPos_layer0, (double)entP.field_70161_v);
        StormObject storm = null;
        ClientTickHandler.checkClientWeather();
        storm = ClientTickHandler.weatherManager.getClosestStorm(plPos, maxStormDist, StormObject.STATE_FORMING, true);
        if (forOvercast) {
            // empty if block
        }
        boolean closeEnough = false;
        double stormDist = 9999.0;
        float tempAdj = 1.0f;
        float sizeToUse = 0.0f;
        float overcastModeMinPrecip = 0.2f;
        if (storm != null) {
            sizeToUse = storm.size;
            if (forOvercast) {
                sizeToUse *= 1.0f;
            }
            if ((double)sizeToUse > (stormDist = storm.pos.func_72438_d(plPos))) {
                closeEnough = true;
            }
        }
        if (closeEnough) {
            double stormIntensity = ((double)sizeToUse - stormDist) / (double)sizeToUse;
            float f = tempAdj = storm.levelTemperature > 0.0f ? 1.0f : -1.0f;
            if (storm.levelCurIntensityStage == StormObject.STATE_NORMAL && stormIntensity > 0.3) {
                stormIntensity = 0.3;
            }
            if (ConfigMisc.Storm_NoRainVisual) {
                stormIntensity = 0.0;
            }
            mc.field_71441_e.func_72912_H().func_76084_b(true);
            mc.field_71441_e.func_72912_H().func_76069_a(true);
            if (forOvercast) {
                curOvercastStrTarget = (float)stormIntensity;
            } else {
                curPrecipStrTarget = (float)stormIntensity;
            }
        } else if (!ConfigMisc.overcastMode) {
            mc.field_71441_e.func_72912_H().func_76084_b(false);
            mc.field_71441_e.func_72912_H().func_76069_a(false);
            if (forOvercast) {
                curOvercastStrTarget = 0.0f;
            } else {
                curPrecipStrTarget = 0.0f;
            }
        } else if (ClientTickHandler.weatherManager.isVanillaRainActiveOnServer) {
            mc.field_71441_e.func_72912_H().func_76084_b(true);
            mc.field_71441_e.func_72912_H().func_76069_a(true);
            if (forOvercast) {
                curOvercastStrTarget = overcastModeMinPrecip;
            } else {
                curPrecipStrTarget = overcastModeMinPrecip;
            }
        } else if (forOvercast) {
            curOvercastStrTarget = 0.0f;
        } else {
            curPrecipStrTarget = 0.0f;
        }
        if (forOvercast) {
            if (curOvercastStr > curOvercastStrTarget) {
                curOvercastStr -= 0.001f;
            } else if (curOvercastStr < curOvercastStrTarget) {
                curOvercastStr += 0.001f;
            }
            if ((double)curOvercastStr < 1.0E-4 && curOvercastStr > -1.0E-4f) {
                curOvercastStr = 0.0f;
            }
            return curOvercastStr * tempAdj;
        }
        if (curPrecipStr > curPrecipStrTarget) {
            curPrecipStr -= 0.001f;
        } else if (curPrecipStr < curPrecipStrTarget) {
            curPrecipStr += 0.001f;
        }
        if ((double)curPrecipStr < 1.0E-4 && curPrecipStr > -1.0E-4f) {
            curPrecipStr = 0.0f;
        }
        return curPrecipStr * tempAdj;
    }

    public synchronized void tryParticleSpawning() {
        if (spawnQueue.size() > 0) {
            // empty if block
        }
        try {
            Entity ent;
            int i;
            for (i = 0; i < spawnQueue.size(); ++i) {
                ent = spawnQueue.get(i);
                if (ent == null || ent.field_70170_p == null) continue;
                if (ent instanceof EntityRotFX) {
                    ((EntityRotFX)ent).spawnAsWeatherEffect();
                    continue;
                }
                ent.field_70170_p.func_72942_c(ent);
            }
            for (i = 0; i < spawnQueueNormal.size(); ++i) {
                ent = spawnQueueNormal.get(i);
                if (ent == null || ent.field_70170_p == null) continue;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)ent);
            }
        }
        catch (Exception ex) {
            System.out.println("Error handling particle spawn queue: ");
            ex.printStackTrace();
        }
        spawnQueue.clear();
        spawnQueueNormal.clear();
    }

    public void profileSurroundings() {
        Block id;
        Minecraft mc = FMLClientHandler.instance().getClient();
        World worldRef = this.lastWorldDetected;
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        WeatherManagerClient manager = ClientTickHandler.weatherManager;
        if (worldRef == null || player == null || manager == null || manager.windMan == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (threadLastWorldTickTime == worldRef.func_72820_D()) {
            return;
        }
        threadLastWorldTickTime = worldRef.func_72820_D();
        Random rand = new Random();
        int size = 40;
        int hsize = size / 2;
        int curX = (int)player.field_70165_t;
        int curY = (int)player.field_70163_u;
        int curZ = (int)player.field_70161_v;
        float windStr = manager.windMan.getWindSpeedForPriority();
        if (mc.field_71476_x != null && CoroUtilBlock.isAir((Block)(id = mc.field_71441_e.func_147439_a(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d))) && id.func_149688_o() == Material.field_151575_d) {
            float var5 = 0.0f;
            var5 = ((Float)OldUtil.getPrivateValueSRGMCP(PlayerControllerMP.class, (Object)mc.field_71442_b, (String)OldUtil.refl_curBlockDamageMP_obf, (String)OldUtil.refl_curBlockDamageMP_mcp)).floatValue();
            if (var5 > 0.0f) {
                // empty if block
            }
        }
        if (!(ConfigMisc.Wind_Particle_leafs || ConfigMisc.Wind_Particle_air || ConfigMisc.Wind_Particle_sand || ConfigMisc.Wind_Particle_waterfall)) {
            return;
        }
        int spawnRate = (int)(30.0 / ((double)windStr + 0.001));
        float lastBlockCount = lastTickFoundBlocks;
        float particleCreationRate = (float)ConfigMisc.Wind_Particle_effect_rate;
        float maxScaleSample = 15000.0f;
        if (lastBlockCount > maxScaleSample) {
            lastBlockCount = maxScaleSample - 1.0f;
        }
        float scaleRate = (maxScaleSample - lastBlockCount) / maxScaleSample;
        spawnRate = (int)((float)spawnRate / (scaleRate + 0.001f) / (particleCreationRate + 0.001f));
        int BlockCountRate = (int)((300.0f / scaleRate + 0.001f) / (particleCreationRate + 0.001f));
        spawnRate *= mc.field_71474_y.field_74362_aa + 1;
        BlockCountRate *= mc.field_71474_y.field_74362_aa + 1;
        if ((spawnRate /= 2) < 40) {
            spawnRate = 40;
        }
        if (BlockCountRate < 80) {
            BlockCountRate = 80;
        }
        if (BlockCountRate > 5000) {
            BlockCountRate = 5000;
        }
        lastTickFoundBlocks = 0;
        for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
            for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                    Block block = SceneEnhancer.getBlock(worldRef, xx, yy, zz);
                    if (block != null && (block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151582_l)) {
                        ++lastTickFoundBlocks;
                        if (worldRef.field_73012_v.nextInt(spawnRate) != 0 || !ConfigMisc.Wind_Particle_leafs || !CoroUtilBlock.isAir((Block)SceneEnhancer.getBlock(worldRef, xx, yy - 1, zz)) && !CoroUtilBlock.isAir((Block)SceneEnhancer.getBlock(worldRef, xx - 1, yy, zz))) continue;
                        EntityTexBiomeColorFX var31 = new EntityTexBiomeColorFX(worldRef, (double)xx, (double)yy - 0.5, (double)zz, 0.0, 0.0, 0.0, 10.0, 0, WeatherUtilParticle.effLeafID, SceneEnhancer.getBlockMetadata(worldRef, xx, yy, zz), xx, yy, zz);
                        var31.setGravity(0.1f);
                        var31.field_70177_z = rand.nextInt(360);
                        var31.field_70125_A = rand.nextInt(360);
                        spawnQueue.add((Entity)var31);
                        continue;
                    }
                    if (ConfigMisc.Wind_Particle_waterfall && player.func_70011_f((double)xx, (double)yy, (double)zz) < 16.0 && block != null && block.func_149688_o() == Material.field_151586_h) {
                        int meta = SceneEnhancer.getBlockMetadata(worldRef, xx, yy, zz);
                        if ((meta & 8) == 0) continue;
                        lastTickFoundBlocks += 70;
                        int chance = (int)(1.0f + (float)BlockCountRate / 120.0f);
                        Block block2 = SceneEnhancer.getBlock(worldRef, xx, yy - 1, zz);
                        int meta2 = SceneEnhancer.getBlockMetadata(worldRef, xx, yy - 1, zz);
                        Block block3 = SceneEnhancer.getBlock(worldRef, xx, yy + 10, zz);
                        if ((block2 != null && block2.func_149688_o() == Material.field_151586_h && (meta2 & 8) != 0 || block3 == null || block3.func_149688_o() != Material.field_151586_h) && worldRef.field_73012_v.nextInt(chance) != 0) continue;
                        float range = 0.5f;
                        EntityWaterfallFX waterP = new EntityWaterfallFX(worldRef, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), 0.0, 0.0, 0.0, 6.0, 2);
                        if ((block2 == null || block2.func_149688_o() != Material.field_151586_h || (meta2 & 8) == 0) && block3 != null && block3.func_149688_o() == Material.field_151586_h) {
                            range = 2.0f;
                            float speed = 0.2f;
                            for (int i = 0; i < 10; ++i) {
                                if (worldRef.field_73012_v.nextInt(chance / 2) != 0) continue;
                                waterP = new EntityWaterfallFX(worldRef, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + (double)0.7f + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), rand.nextFloat() * speed - speed / 2.0f, rand.nextFloat() * speed - speed / 2.0f, rand.nextFloat() * speed - speed / 2.0f, 2.0, 3);
                                ((EntityFX)waterP).field_70181_x = 4.5;
                                spawnQueueNormal.add((EntityFX)waterP);
                            }
                            continue;
                        }
                        waterP = new EntityWaterfallFX(worldRef, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), 0.0, 0.0, 0.0, 6.0, 2);
                        ((EntityFX)waterP).field_70181_x = 0.5;
                        spawnQueueNormal.add((EntityFX)waterP);
                        continue;
                    }
                    if (!ConfigMisc.Wind_Particle_fire || block == null || block != Blocks.field_150480_ab) continue;
                    ++lastTickFoundBlocks;
                    if (worldRef.field_73012_v.nextInt(Math.max(1, spawnRate / 100)) != 0) continue;
                    double speed = 0.15;
                    EntityRotFX entityfx = pm.spawnNewParticleIconFX(worldRef, ParticleRegistry.smoke, (double)xx + rand.nextDouble(), (double)yy + 0.2 + rand.nextDouble() * 0.2, (double)zz + rand.nextDouble(), (rand.nextDouble() - rand.nextDouble()) * speed, 0.03, (rand.nextDouble() - rand.nextDouble()) * speed);
                    ParticleBehaviors.setParticleRandoms((EntityRotFX)entityfx, (boolean)true, (boolean)true);
                    ParticleBehaviors.setParticleFire((EntityRotFX)entityfx);
                    entityfx.setMaxAge(100 + rand.nextInt(300));
                    spawnQueueNormal.add((EntityFX)entityfx);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void tryWind(World world) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        int dist = 60;
        List list = null;
        list = world.field_72996_f;
        Random rand = new Random();
        int handleCount = 0;
        if ((double)ClientTickHandler.weatherManager.windMan.getWindSpeedForPriority() >= 0.1) {
            for (int i = 0; i < world.field_73007_j.size(); ++i) {
                ++handleCount;
                Entity entity1 = (Entity)world.field_73007_j.get(i);
                if (entity1 instanceof EntityLightningBolt || !(entity1 instanceof EntityFX) || entity1 == null) continue;
                if (world.func_72976_f(MathHelper.func_76128_c((double)entity1.field_70165_t), MathHelper.func_76128_c((double)entity1.field_70161_v)) - 1 < (int)entity1.field_70163_u + 1 || entity1 instanceof EntityTexFX) {
                    if (entity1 instanceof EntityFlameFX) {
                        WeatherUtilParticle.setParticleAge((EntityFX)entity1, WeatherUtilParticle.getParticleAge((EntityFX)entity1) + 2);
                    } else if (entity1 instanceof WindHandler) {
                        if (((WindHandler)entity1).getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge((EntityFX)entity1) % 2 == 0) {
                            WeatherUtilParticle.setParticleAge((EntityFX)entity1, WeatherUtilParticle.getParticleAge((EntityFX)entity1) + ((WindHandler)entity1).getParticleDecayExtra());
                        }
                    } else if (WeatherUtilParticle.getParticleAge((EntityFX)entity1) % 2 == 0) {
                        WeatherUtilParticle.setParticleAge((EntityFX)entity1, WeatherUtilParticle.getParticleAge((EntityFX)entity1) + 1);
                    }
                    if (entity1 instanceof EntityTexFX && ((EntityTexFX)entity1).getParticleTextureIndex() == WeatherUtilParticle.effLeafID) {
                        if (entity1.field_70159_w < (double)0.01f && entity1.field_70179_y < (double)0.01f) {
                            entity1.field_70181_x += rand.nextDouble() * 0.02;
                        }
                        entity1.field_70181_x -= (double)0.01f;
                    }
                }
                SceneEnhancer.applyWindForce(entity1);
                SceneEnhancer.applyWindForce(entity1);
            }
        }
        WindManager windMan = ClientTickHandler.weatherManager.windMan;
        if (WeatherUtilParticle.fxLayers != null && (double)windMan.getWindSpeedForPriority() >= 0.1) {
            Entity entity1;
            int i;
            int layer;
            for (layer = 0; layer < 4; ++layer) {
                for (i = 0; i < WeatherUtilParticle.fxLayers[layer].size(); ++i) {
                    String className;
                    entity1 = (Entity)WeatherUtilParticle.fxLayers[layer].get(i);
                    if (ConfigMisc.Particle_VanillaAndWeatherOnly && !(className = entity1.getClass().getName()).contains("net.minecraft.") && !className.contains("weather2.") || world.func_72976_f(MathHelper.func_76128_c((double)entity1.field_70165_t), MathHelper.func_76128_c((double)entity1.field_70161_v)) - 1 >= (int)entity1.field_70163_u + 1 && !(entity1 instanceof EntityTexFX)) continue;
                    if (entity1 instanceof EntityFlameFX) {
                        if ((double)windMan.getWindSpeedForPriority() >= 0.5) {
                            WeatherUtilParticle.setParticleAge((EntityFX)entity1, WeatherUtilParticle.getParticleAge((EntityFX)entity1) + 2);
                        }
                    } else if (entity1 instanceof WindHandler) {
                        if (((WindHandler)entity1).getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge((EntityFX)entity1) % 2 == 0) {
                            WeatherUtilParticle.setParticleAge((EntityFX)entity1, WeatherUtilParticle.getParticleAge((EntityFX)entity1) + ((WindHandler)entity1).getParticleDecayExtra());
                        }
                    } else if (WeatherUtilParticle.getParticleAge((EntityFX)entity1) % 2 == 0) {
                        WeatherUtilParticle.setParticleAge((EntityFX)entity1, WeatherUtilParticle.getParticleAge((EntityFX)entity1) + 1);
                    }
                    if (!(entity1 instanceof EntityWaterfallFX)) {
                        if (entity1.field_70122_E) {
                            entity1.field_70181_x += rand.nextDouble() * entity1.field_70159_w;
                        }
                        if (entity1.field_70159_w < (double)0.01f && entity1.field_70179_y < (double)0.01f) {
                            entity1.field_70181_x += rand.nextDouble() * 0.02;
                        }
                    }
                    SceneEnhancer.applyWindForce(entity1);
                }
            }
            for (layer = 0; layer < ExtendedRenderer.rotEffRenderer.layers; ++layer) {
                for (i = 0; i < ExtendedRenderer.rotEffRenderer.fxLayers[layer].size(); ++i) {
                    entity1 = (Entity)ExtendedRenderer.rotEffRenderer.fxLayers[layer].get(i);
                }
            }
        }
        float volScaleFar = windMan.getWindSpeedForPriority() * 1.0f;
        if (windMan.getWindSpeedForPriority() <= 0.07f) {
            volScaleFar = 0.0f;
        }
        volScaleFar = (float)((double)volScaleFar * ConfigMisc.volWindScale);
    }

    public static void applyWindForce(Entity ent) {
        SceneEnhancer.applyWindForce(ent, 1.0);
    }

    public static void applyWindForce(Entity ent, double multiplier) {
        WindManager windMan = ClientTickHandler.weatherManager.windMan;
        float windSpeed = windMan.getWindSpeedForPriority();
        float windAngle = windMan.getWindAngleForPriority();
        double speed = (double)windSpeed * 0.1 / (double)WeatherUtilEntity.getWeight(ent);
        speed *= multiplier;
        if (ent.field_70122_E && (double)windSpeed < 0.7 && speed < 0.3) {
            speed = 0.0;
        }
        ent.field_70159_w += speed * (double)(-MathHelper.func_76126_a((float)(windAngle / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.0f));
        ent.field_70179_y += speed * (double)(MathHelper.func_76134_b((float)(windAngle / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.0f));
    }

    @SideOnly(value=Side.CLIENT)
    private static Block getBlock(World parWorld, int x, int y, int z) {
        try {
            if (!parWorld.func_72904_c(x, 0, z, x, 128, z)) {
                return null;
            }
            return parWorld.func_147439_a(x, y, z);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static int getBlockMetadata(World parWorld, int x, int y, int z) {
        if (!parWorld.func_72904_c(x, 0, z, x, 128, z)) {
            return 0;
        }
        return parWorld.func_72805_g(x, y, z);
    }

    static {
        spawnQueueNormal = new ArrayList<EntityFX>();
        spawnQueue = new ArrayList<Entity>();
        soundLocations = new ArrayList();
        soundTimeLocations = new HashMap();
        SOUNDMARKER_WATER = Blocks.field_150355_j;
        SOUNDMARKER_LEAVES = Blocks.field_150362_t;
        curPrecipStr = 0.0f;
        curPrecipStrTarget = 0.0f;
        curOvercastStr = 0.0f;
        curOvercastStrTarget = 0.0f;
    }
}

