/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import weather2.CommonProxy;
import weather2.config.ConfigMisc;

public class WeatherUtil {
    public static HashMap<Block, Boolean> blockIDToUseMapping = new HashMap();

    public static boolean isPaused() {
        return FMLClientHandler.instance().getClient().func_147113_T();
    }

    public static boolean shouldGrabBlock(World parWorld, Block id) {
        try {
            ItemStack itemStr = new ItemStack(Items.field_151056_x);
            Block block = id;
            boolean result = true;
            if (ConfigMisc.Storm_Tornado_GrabCond_StrengthGrabbing) {
                float strMin = 0.0f;
                float strMax = 0.74f;
                if (block == null) {
                    result = false;
                    return result;
                }
                float strVsBlock = block.func_149712_f(parWorld, 0, 0, 0) - (itemStr.func_150997_a(block) - 1.0f) / 4.0f;
                if (strVsBlock <= strMax && strVsBlock >= strMin || block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151580_n || block.func_149688_o() == Material.field_151585_k || block instanceof BlockTallGrass) {
                    if (!WeatherUtil.safetyCheck(block)) {
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
            if (ConfigMisc.Storm_Tornado_GrabCond_List) {
                if (!ConfigMisc.Storm_Tornado_GrabListBlacklistMode) {
                    if (!blockIDToUseMapping.get(id).booleanValue()) {
                        result = false;
                    }
                } else if (blockIDToUseMapping.get(id).booleanValue()) {
                    result = false;
                }
            }
            if (ConfigMisc.Storm_Tornado_RefinedGrabRules && (id == Blocks.field_150346_d || id == Blocks.field_150349_c || id == Blocks.field_150354_m || block instanceof BlockLog)) {
                result = false;
            }
            if (id == CommonProxy.blockWeatherMachine) {
                result = false;
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean safetyCheck(Block id) {
        return id != Blocks.field_150357_h && id != Blocks.field_150364_r && id != Blocks.field_150486_ae && id != Blocks.field_150421_aI;
    }

    public static boolean shouldRemoveBlock(Block blockID) {
        return blockID.func_149688_o() != Material.field_151586_h;
    }

    public static boolean isOceanBlock(Block blockID) {
        return false;
    }

    public static boolean isSolidBlock(Block id) {
        return id == Blocks.field_150348_b || id == Blocks.field_150347_e || id == Blocks.field_150322_A;
    }

    public static void doBlockList() {
        blockIDToUseMapping.clear();
        String[] splEnts = ConfigMisc.Storm_Tornado_GrabList.split(",");
        if (splEnts.length > 0) {
            for (int i = 0; i < splEnts.length; ++i) {
                splEnts[i] = splEnts[i].trim();
            }
        }
        blockIDToUseMapping.put(Blocks.field_150350_a, false);
        Set set = Block.field_149771_c.func_148742_b();
        for (String tagName : set) {
            Block block = (Block)Block.field_149771_c.func_82594_a(tagName);
            if (block == null) continue;
            boolean foundEnt = false;
            for (int j = 0; j < splEnts.length; ++j) {
                Block blockEntry = (Block)Block.field_149771_c.func_82594_a(splEnts[j]);
                if (blockEntry == null || block != blockEntry) continue;
                foundEnt = true;
                break;
            }
            blockIDToUseMapping.put(block, foundEnt);
        }
    }
}

