/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.volcano.VolcanoObject;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.wind.WindManager;

public class WeatherManagerBase {
    public int dim;
    private List<StormObject> listStormObjects = new ArrayList<StormObject>();
    public HashMap<Long, StormObject> lookupStormObjectsByID = new HashMap();
    public HashMap<Integer, ArrayList<StormObject>> lookupStormObjectsByLayer = new HashMap();
    private List<VolcanoObject> listVolcanoes = new ArrayList<VolcanoObject>();
    public HashMap<Long, VolcanoObject> lookupVolcanoes = new HashMap();
    public WindManager windMan = new WindManager(this);
    public boolean isVanillaRainActiveOnServer = false;

    public WeatherManagerBase(int parDim) {
        this.dim = parDim;
        this.lookupStormObjectsByLayer.put(0, new ArrayList());
        this.lookupStormObjectsByLayer.put(1, new ArrayList());
        this.lookupStormObjectsByLayer.put(2, new ArrayList());
    }

    public void reset() {
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            StormObject so = this.getStormObjects().get(i);
            so.reset();
        }
        this.getStormObjects().clear();
        this.lookupStormObjectsByID.clear();
        try {
            this.lookupStormObjectsByLayer.get(0).clear();
            this.lookupStormObjectsByLayer.get(1).clear();
            this.lookupStormObjectsByLayer.get(2).clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < this.getVolcanoObjects().size(); ++i) {
            VolcanoObject vo = this.getVolcanoObjects().get(i);
            vo.reset();
        }
        this.getVolcanoObjects().clear();
        this.lookupVolcanoes.clear();
        this.windMan.reset();
        StormObject.lastUsedStormID = 0L;
    }

    public World getWorld() {
        return null;
    }

    public void tick() {
        World world = this.getWorld();
        if (world != null) {
            int i;
            List<StormObject> list = this.getStormObjects();
            for (i = 0; i < list.size(); ++i) {
                StormObject so = list.get(i);
                if (this instanceof WeatherManagerServer && so.isDead) {
                    this.removeStormObject(so.ID);
                    ((WeatherManagerServer)this).syncStormRemove(so);
                    continue;
                }
                if (!so.isDead) {
                    so.tick();
                    continue;
                }
                if (!this.getWorld().field_72995_K) continue;
                Weather.dbg("WARNING!!! - detected isDead storm object still in client side list, had to remove storm object with ID " + so.ID + " from client side, wasnt properly removed via main channels");
                this.removeStormObject(so.ID);
            }
            for (i = 0; i < this.getVolcanoObjects().size(); ++i) {
                this.getVolcanoObjects().get(i).tick();
            }
            this.windMan.tick();
        }
    }

    public void tickRender(float partialTick) {
        World world = this.getWorld();
        if (world != null) {
            for (int i = 0; i < this.getStormObjects().size(); ++i) {
                this.getStormObjects().get(i).tickRender(partialTick);
            }
        }
    }

    public List<StormObject> getStormObjects() {
        return this.listStormObjects;
    }

    public List<StormObject> getStormObjectsByLayer(int layer) {
        return this.lookupStormObjectsByLayer.get(layer);
    }

    public void addStormObject(StormObject so) {
        if (!this.lookupStormObjectsByID.containsKey(so.ID)) {
            this.listStormObjects.add(so);
            this.lookupStormObjectsByID.put(so.ID, so);
            this.lookupStormObjectsByLayer.get(so.layer).add(so);
        } else {
            Weather.dbg("Weather2 WARNING!!! Client received new storm create for an ID that is already active! design bug");
        }
    }

    public void removeStormObject(long ID) {
        StormObject so = this.lookupStormObjectsByID.get(ID);
        if (so != null) {
            so.setDead();
            this.listStormObjects.remove(so);
            this.lookupStormObjectsByID.remove(ID);
            this.lookupStormObjectsByLayer.get(so.layer).remove(so);
        } else {
            Weather.dbg("error looking up storm ID on server for removal: " + ID + " - lookup count: " + this.lookupStormObjectsByID.size() + " - last used ID: " + StormObject.lastUsedStormID);
        }
    }

    public List<VolcanoObject> getVolcanoObjects() {
        return this.listVolcanoes;
    }

    public void addVolcanoObject(VolcanoObject so) {
        if (!this.lookupVolcanoes.containsKey(so.ID)) {
            this.listVolcanoes.add(so);
            this.lookupVolcanoes.put(so.ID, so);
        } else {
            Weather.dbg("Weather2 WARNING!!! Client received new volcano create for an ID that is already active! design bug");
        }
    }

    public void removeVolcanoObject(long ID) {
        VolcanoObject vo = this.lookupVolcanoes.get(ID);
        if (vo != null) {
            vo.setDead();
            this.listVolcanoes.remove(vo);
            this.lookupVolcanoes.remove(ID);
            Weather.dbg("removing volcano");
        }
    }

    public StormObject getClosestStormAny(Vec3 parPos, double maxDist) {
        return this.getClosestStorm(parPos, maxDist, -1, true);
    }

    public StormObject getClosestStorm(Vec3 parPos, double maxDist, int severityFlagMin) {
        return this.getClosestStorm(parPos, maxDist, severityFlagMin, false);
    }

    public StormObject getClosestStorm(Vec3 parPos, double maxDist, int severityFlagMin, boolean orRain) {
        StormObject closestStorm = null;
        double closestDist = 9999999.0;
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            double dist;
            StormObject storm = this.getStormObjects().get(i);
            if (storm.isDead || !((dist = storm.pos.func_72438_d(parPos)) < closestDist) || !(dist <= maxDist) || (!storm.attrib_precipitation || !orRain) && severityFlagMin != -1 && storm.levelCurIntensityStage < severityFlagMin) continue;
            closestStorm = storm;
            closestDist = dist;
        }
        return closestStorm;
    }

    public List<StormObject> getStormsAround(Vec3 parPos, double maxDist) {
        ArrayList<StormObject> storms = new ArrayList<StormObject>();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            StormObject storm = this.getStormObjects().get(i);
            if (storm.isDead || !(storm.pos.func_72438_d(parPos) < maxDist) || !storm.attrib_precipitation && storm.levelCurIntensityStage <= StormObject.STATE_NORMAL) continue;
            storms.add(storm);
        }
        return storms;
    }

    public void writeToFile() {
        NBTTagCompound mainNBT = new NBTTagCompound();
        NBTTagCompound listVolcanoesNBT = new NBTTagCompound();
        for (int i = 0; i < this.listVolcanoes.size(); ++i) {
            VolcanoObject td = this.listVolcanoes.get(i);
            NBTTagCompound teamNBT = new NBTTagCompound();
            td.writeToNBT(teamNBT);
            listVolcanoesNBT.func_74782_a("volcano_" + td.ID, (NBTBase)teamNBT);
        }
        mainNBT.func_74782_a("volcanoData", (NBTBase)listVolcanoesNBT);
        mainNBT.func_74772_a("lastUsedID", VolcanoObject.lastUsedID);
        String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "weather2" + File.separator;
        try {
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "VolcanoData.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)mainNBT, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readFromFile() {
        NBTTagCompound rtsNBT = new NBTTagCompound();
        String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "weather2" + File.separator;
        boolean readFail = false;
        try {
            if (new File(saveFolder + "VolcanoData.dat").exists()) {
                rtsNBT = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "VolcanoData.dat"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            readFail = true;
        }
        if (!readFail) {
            try {
                File tmp = new File(saveFolder + "VolcanoData_BACKUP0.dat");
                if (tmp.exists()) {
                    FileUtils.copyFile((File)tmp, (File)new File(saveFolder + "VolcanoData_BACKUP1.dat"));
                }
                if (new File(saveFolder + "VolcanoData.dat").exists()) {
                    FileUtils.copyFile((File)new File(saveFolder + "VolcanoData.dat"), (File)new File(saveFolder + "VolcanoData_BACKUP0.dat"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("WARNING! Weather2 File: VolcanoData.dat failed to load, automatically restoring to backup from previous game run");
            try {
                if (new File(saveFolder + "VolcanoData_BACKUP0.dat").exists()) {
                    rtsNBT = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "VolcanoData_BACKUP0.dat"));
                } else {
                    System.out.println("WARNING! Failed to find backup file VolcanoData_BACKUP0.dat, nothing loaded");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("WARNING! Error loading backup file VolcanoData_BACKUP0.dat, nothing loaded");
            }
        }
        VolcanoObject.lastUsedID = rtsNBT.func_74763_f("lastUsedID");
        NBTTagCompound teamDataList = rtsNBT.func_74775_l("volcanoData");
        for (String tagName : teamDataList.func_150296_c()) {
            NBTTagCompound teamData = rtsNBT.func_74775_l(tagName);
            VolcanoObject to = new VolcanoObject(ServerTickHandler.lookupDimToWeatherMan.get(0));
            try {
                to.readFromNBT(teamData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.addVolcanoObject(to);
            ((WeatherManagerServer)this).syncVolcanoNew(to);
            to.initPost();
        }
    }
}

