package mods.immibis.microblocks;

import java.util.List;

import mods.immibis.core.api.APILocator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

/**
 * Used for transformed blocks that don't normally have tile entities e.g. torches
 */
public class TileDummy extends TileEntity {
	public static Void ImmibisMicroblocks_TransformableTileEntityMarker;
	
	@Override public boolean canUpdate() {return false;}

	public void removeTile() {
		PacketDummyTEDestroy packet = new PacketDummyTEDestroy();
		packet.x = xCoord; packet.y = yCoord; packet.z = zCoord;
		for(EntityPlayer p : (List<EntityPlayer>)worldObj.playerEntities) {
			if(p instanceof EntityPlayerMP)
				APILocator.getNetManager().sendToClient(packet, (EntityPlayerMP)p);
		}
		
		worldObj.setTileEntity(xCoord, yCoord, zCoord, null);
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
		worldObj.notifyBlocksOfNeighborChange(xCoord, yCoord, zCoord, getBlockType());
	}
	
	@Override
	public Packet getDescriptionPacket() {
		return APILocator.getNetManager().wrap(new PacketDummyTEDesc(xCoord, yCoord, zCoord), true);
	}
}
