/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.client.model.rotations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import xelitez.frostcraft.client.model.rotations.EnumAxis;

public class EntryList {
    private HashMap<String, Entry> entries = new HashMap();

    public void addEntry(String name) {
        this.entries.put(name, new Entry());
    }

    public Entry getEntry(String name) {
        for (String string : this.entries.keySet()) {
            if (!string.matches(name)) continue;
            return this.entries.get(string);
        }
        System.err.println("No entry found with name: " + name);
        return null;
    }

    public Collection<Entry> getAllEntries() {
        return this.entries.values();
    }

    public Set<String> getAllKeys() {
        return this.entries.keySet();
    }

    public class Entry {
        private float rotationX = 0.0f;
        private float rotationY = 0.0f;
        private float rotationZ = 0.0f;
        private float targetRotationX = 0.0f;
        private float targetRotationY = 0.0f;
        private float targetRotationZ = 0.0f;
        private float startRotationX = 0.0f;
        private float startRotationY = 0.0f;
        private float startRotationZ = 0.0f;
        private long targetTimeX = 0L;
        private long targetTimeY = 0L;
        private long targetTimeZ = 0L;
        private long startTimeX = 0L;
        private long startTimeY = 0L;
        private long startTimeZ = 0L;

        public float getRotation(EnumAxis ax) {
            if (ax == EnumAxis.X) {
                float rotationChange = this.targetRotationX - this.startRotationX;
                float progress = this.targetTimeX < System.currentTimeMillis() ? 1.0f : (float)(System.currentTimeMillis() - this.startTimeX) / (float)(this.targetTimeX - this.startTimeX);
                this.rotationX = this.targetTimeX < System.currentTimeMillis() ? this.targetRotationX : this.startRotationX + rotationChange * progress;
                return this.rotationX * (float)Math.PI;
            }
            if (ax == EnumAxis.Y) {
                float rotationChange = this.targetRotationY - this.startRotationY;
                float progress = this.targetTimeY < System.currentTimeMillis() ? 1.0f : (float)(System.currentTimeMillis() - this.startTimeY) / (float)(this.targetTimeY - this.startTimeY);
                this.rotationY = this.targetTimeY < System.currentTimeMillis() ? this.targetRotationY : this.startRotationY + rotationChange * progress;
                return this.rotationY * (float)Math.PI;
            }
            if (ax == EnumAxis.Z) {
                float rotationChange = this.targetRotationZ - this.startRotationZ;
                float progress = this.targetTimeZ < System.currentTimeMillis() ? 1.0f : (float)(System.currentTimeMillis() - this.startTimeZ) / (float)(this.targetTimeZ - this.startTimeZ);
                this.rotationZ = this.targetTimeZ < System.currentTimeMillis() ? this.targetRotationZ : this.startRotationZ + rotationChange * progress;
                return this.rotationZ * (float)Math.PI;
            }
            return 0.0f;
        }

        public float getRawRotation(EnumAxis ax) {
            if (ax == EnumAxis.X) {
                float rotationChange = this.targetRotationX - this.startRotationX;
                float progress = this.targetTimeX < System.currentTimeMillis() ? 1.0f : (float)(System.currentTimeMillis() - this.startTimeX) / (float)(this.targetTimeX - this.startTimeX);
                this.rotationX = this.targetTimeX < System.currentTimeMillis() ? this.targetRotationX : this.startRotationX + rotationChange * progress;
                return this.rotationX;
            }
            if (ax == EnumAxis.Y) {
                float rotationChange = this.targetRotationY - this.startRotationY;
                float progress = this.targetTimeY < System.currentTimeMillis() ? 1.0f : (float)(System.currentTimeMillis() - this.startTimeY) / (float)(this.targetTimeY - this.startTimeY);
                this.rotationY = this.targetTimeY < System.currentTimeMillis() ? this.targetRotationY : this.startRotationY + rotationChange * progress;
                return this.rotationY;
            }
            if (ax == EnumAxis.Z) {
                float rotationChange = this.targetRotationZ - this.startRotationZ;
                float progress = this.targetTimeZ < System.currentTimeMillis() ? 1.0f : (float)(System.currentTimeMillis() - this.startTimeZ) / (float)(this.targetTimeZ - this.startTimeZ);
                this.rotationZ = this.targetTimeZ < System.currentTimeMillis() ? this.targetRotationZ : this.startRotationZ + rotationChange * progress;
                return this.rotationZ;
            }
            return 0.0f;
        }

        public void setRotation(EnumAxis ax, float rotation) {
            if (ax == EnumAxis.X) {
                this.startRotationX = this.getRawRotation(ax);
                this.targetRotationX = rotation;
                this.targetTimeX = 0L;
            }
            if (ax == EnumAxis.Y) {
                this.startRotationY = this.getRawRotation(ax);
                this.targetRotationY = rotation;
                this.targetTimeY = 0L;
            }
            if (ax == EnumAxis.Z) {
                this.startRotationZ = this.getRawRotation(ax);
                this.targetRotationZ = rotation;
                this.targetTimeZ = 0L;
            }
        }

        public void addRotation(EnumAxis ax, float rotation, int duration) {
            if (ax == EnumAxis.X) {
                this.startRotationX = this.getRawRotation(ax);
                this.targetRotationX = rotation;
                this.startTimeX = System.currentTimeMillis();
                this.targetTimeX = System.currentTimeMillis() + (long)duration;
            }
            if (ax == EnumAxis.Y) {
                this.startRotationY = this.getRawRotation(ax);
                this.targetRotationY = rotation;
                this.startTimeY = System.currentTimeMillis();
                this.targetTimeY = System.currentTimeMillis() + (long)duration;
            }
            if (ax == EnumAxis.Z) {
                this.startRotationZ = this.getRawRotation(ax);
                this.targetRotationZ = rotation;
                this.startTimeZ = System.currentTimeMillis();
                this.targetTimeZ = System.currentTimeMillis() + (long)duration;
            }
        }

        public boolean isDoneRotating(EnumAxis ax) {
            if (ax == EnumAxis.X) {
                return this.targetTimeX < System.currentTimeMillis();
            }
            if (ax == EnumAxis.Y) {
                return this.targetTimeY < System.currentTimeMillis();
            }
            if (ax == EnumAxis.Z) {
                return this.targetTimeZ < System.currentTimeMillis();
            }
            return false;
        }
    }
}

