/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import xelitez.frostcraft.client.model.ModelFrostWingLow;
import xelitez.frostcraft.client.model.rotations.EnumAxis;
import xelitez.frostcraft.client.model.rotations.ModelRotationAssistant;
import xelitez.frostcraft.effect.EffectTicker;
import xelitez.frostcraft.effect.FCPotion;
import xelitez.frostcraft.entity.EntityFrostBall;
import xelitez.frostcraft.entity.EntityFrostWingIcicleDropping;
import xelitez.frostcraft.registry.IdMap;

public class EntityFrostWing
extends EntityCreature
implements IBossDisplayData,
IMob {
    private int heightOffsetUpdateTime;
    public boolean isFlying;
    private int flyingTime = 0;
    private int amountOfAttacks = 5;
    private int attackCooldown = 0;
    private boolean pathSet = false;
    private Vec3 path = null;
    private ChunkCoordinates ck = new ChunkCoordinates(0, 0, 0);
    public ModelRotationAssistant rotationHelper = new ModelRotationAssistant(ModelFrostWingLow.class);

    public EntityFrostWing() {
        this(null);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public EntityFrostWing(World par1World) {
        super(par1World);
        if (par1World != null) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 0, true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true));
            this.field_70129_M *= 2.5f;
            if (this.field_70170_p.field_72995_K) {
                this.func_70105_a(0.75f, 1.3f);
            } else {
                this.func_70105_a(0.8f, 1.3f);
            }
            this.func_70105_a(this.field_70130_N * 2.5f, this.field_70131_O * 2.5f);
            this.addRotationOverTime("body", EnumAxis.X, -0.3f, 1);
            this.addRotationOverTime("wingLeft", EnumAxis.Z, -0.3f, 1);
            this.addRotationOverTime("wingRight", EnumAxis.Z, 0.3f, 1);
            this.addRotationOverTime("wingLeftOuter", EnumAxis.X, -0.4f, 1);
            this.addRotationOverTime("wingRightOuter", EnumAxis.X, -0.4f, 1);
            this.addRotationOverTime("tailPiece", EnumAxis.X, 0.1f, 1);
            this.addRotationOverTime("leftLeg", EnumAxis.X, 0.3f, 1);
            this.addRotationOverTime("rightLeg", EnumAxis.X, 0.3f, 1);
            this.field_70747_aH = 0.15f;
        }
    }

    public EntityFrostWing(World par1World, int statX, int statY, int statZ) {
        this(par1World);
        this.ck = new ChunkCoordinates(statX, statY, statZ);
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.1;
    }

    public void addRotationOverTime(String entry, EnumAxis axis, float rotateAngle, int milliseconds) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.rotationHelper.getEntryList().getEntry(entry).addRotation(axis, rotateAngle, milliseconds);
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70163_u <= 0.0) {
                this.func_70106_y();
            }
            if (this.field_70173_aa == Integer.MAX_VALUE) {
                this.field_70173_aa = 0;
            }
            ++this.field_70173_aa;
            if (this.field_70173_aa % 150 == 0 && !this.field_70128_L && this.func_110143_aJ() > 0.0f) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
            }
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
            }
        }
        if (!(this.field_70122_E || !(this.field_70181_x < 0.0) || !this.func_70661_as().func_75500_f() && this.func_70661_as().func_75505_d().func_75878_a((Entity)this).field_72448_b > this.field_70163_u && this.path != null && this.path.field_72448_b > this.field_70163_u)) {
            this.field_70181_x *= 0.25;
        }
        if (this.field_70181_x < 0.0 && (this.func_70661_as().func_75500_f() || !(this.func_70661_as().func_75505_d().func_75878_a((Entity)this).field_72448_b > this.field_70163_u) || this.path == null || !(this.path.field_72448_b > this.field_70163_u))) {
            this.field_70181_x *= 2.0;
        }
        if (!this.func_70661_as().func_75500_f() && this.func_70661_as().func_75505_d().func_75878_a((Entity)this).field_72448_b > this.field_70163_u || this.path != null && this.path.field_72448_b > this.field_70163_u) {
            this.field_70181_x = 0.1;
        }
        if (!(this.isFlying || this.field_70122_E || this.getAttackTime() != 0 && this.getAttack() == 1)) {
            this.addRotationOverTime("wingLeftOuter", EnumAxis.X, -0.4f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.X, -0.4f, 100);
            this.addRotationOverTime("wingLeft", EnumAxis.Z, -0.7f, 100);
            this.addRotationOverTime("wingRight", EnumAxis.Z, 0.7f, 100);
            this.addRotationOverTime("wingLeftOuter", EnumAxis.Z, -0.2f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.Z, 0.2f, 100);
            boolean bl = this.isFlying = !this.field_70122_E;
        }
        if (this.isFlying && this.field_70122_E && (this.getAttackTime() == 0 || this.getAttack() != 1)) {
            this.addRotationOverTime("wingLeftOuter", EnumAxis.X, 0.0f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.X, 0.0f, 100);
            this.addRotationOverTime("wingLeft", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("wingRight", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("wingLeftOuter", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("body", EnumAxis.X, -0.3f, 25);
            boolean bl = this.isFlying = !this.field_70122_E;
        }
        this.flyingTime = this.isFlying ? ++this.flyingTime : 0;
        this.executeAttack();
        if (this.func_70638_az() != null) {
            if (this.func_70638_az().func_70032_d((Entity)this) < 14.0f && this.path == null || this.func_70638_az().func_70032_d((Entity)this) < 10.0f) {
                if (this.amountOfAttacks > 0 && this.attackCooldown == 0 && this.getAttack() == 0) {
                    this.func_70661_as().func_75499_g();
                    this.path = null;
                    this.performAttack(this.getAttackByChance(this.field_70146_Z.nextInt(this.getTotalAttackChance()) + 1));
                    this.attackCooldown = 10;
                }
            } else if (!this.isFlying && this.func_70661_as().func_75500_f()) {
                this.func_70661_as().func_75484_a(this.field_70170_p.func_72865_a((Entity)this, (Entity)this.func_70638_az(), (float)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), true, true, true, true), 1.0);
            } else if (this.isFlying) {
                if (this.path != null && this.func_70011_f(this.path.field_72450_a, this.path.field_72448_b, this.path.field_72449_c) < 14.0) {
                    this.path = null;
                }
                if (this.path == null) {
                    this.path = Vec3.func_72443_a((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70163_u, (double)this.func_70638_az().field_70161_v);
                }
                this.func_70605_aq().func_75642_a(this.path.field_72450_a, this.path.field_72448_b, this.path.field_72449_c, 1.0);
            }
        } else if (this.path != null) {
            this.path = null;
            this.func_70661_as().func_75499_g();
        }
        if (this.attackCooldown > 0 && !this.field_70170_p.field_72995_K) {
            --this.attackCooldown;
        }
        super.func_70636_d();
        if (this.field_70703_bu) {
            if (!this.func_70090_H() && !this.func_70058_J()) {
                if (!this.field_70122_E) {
                    this.func_70664_aZ();
                }
            } else {
                this.field_70181_x += (double)0.04f;
            }
        }
    }

    private void executeAttack() {
        switch (this.getAttack()) {
            case 1: {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.func_70638_az() != null) {
                    this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                }
                if (this.getAttackTime() > 57) {
                    this.addRotationOverTime("body", EnumAxis.X, -0.5f, 200);
                    this.addRotationOverTime("wingLeft", EnumAxis.Z, -0.5f, 200);
                    this.addRotationOverTime("wingRight", EnumAxis.Z, 0.5f, 200);
                    this.addRotationOverTime("wingLeft", EnumAxis.X, -0.05f, 200);
                    this.addRotationOverTime("wingRight", EnumAxis.X, -0.05f, 200);
                    this.addRotationOverTime("wingLeftOuter", EnumAxis.X, -0.5f, 200);
                    this.addRotationOverTime("wingRightOuter", EnumAxis.X, -0.5f, 200);
                    this.addRotationOverTime("wingLeftOuter", EnumAxis.Z, 0.0f, 200);
                    this.addRotationOverTime("wingRightOuter", EnumAxis.Z, 0.0f, 200);
                }
                if (this.getAttackTime() % 5 == 0 && !this.field_70170_p.field_72995_K) {
                    double size = 17.5;
                    int var3 = MathHelper.func_76128_c((double)(this.field_70165_t - size - 1.0));
                    int var4 = MathHelper.func_76128_c((double)(this.field_70165_t + size + 1.0));
                    int var5 = MathHelper.func_76128_c((double)(this.field_70163_u - size - 1.0));
                    int var29 = MathHelper.func_76128_c((double)(this.field_70163_u + size + 1.0));
                    int var7 = MathHelper.func_76128_c((double)(this.field_70161_v - size - 1.0));
                    int var30 = MathHelper.func_76128_c((double)(this.field_70161_v + size + 1.0));
                    List var9 = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)var3, (double)var5, (double)var7, (double)var4, (double)var29, (double)var30));
                    for (int var11 = 0; var11 < var9.size(); ++var11) {
                        double var19;
                        double var17;
                        double var15;
                        double var34;
                        Entity var32 = (Entity)var9.get(var11);
                        double var13 = var32.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) / size;
                        if (!(var13 <= 1.0) || (var34 = (double)MathHelper.func_76133_a((double)((var15 = var32.field_70165_t - this.field_70165_t) * var15 + (var17 = var32.field_70163_u + (double)var32.func_70047_e() - this.field_70163_u) * var17 + (var19 = var32.field_70161_v - this.field_70161_v) * var19))) == 0.0 || var32.func_85032_ar() || (!(var32 instanceof EntityPlayer) || ((EntityPlayer)var32).field_71075_bZ.field_75098_d) && var32 != this.func_70638_az() && !(var32 instanceof EntityAnimal) && !(var32 instanceof EntityMob)) continue;
                        EntityFrostWingIcicleDropping icicle = new EntityFrostWingIcicleDropping(this.field_70170_p, (Entity)this);
                        icicle.field_70165_t = var32.field_70165_t;
                        icicle.field_70163_u = var32.field_70163_u + 17.5;
                        icicle.field_70161_v = var32.field_70161_v;
                        this.field_70170_p.func_72838_d((Entity)icicle);
                    }
                }
                if (this.getAttackTime() > 5) break;
                this.resetRotations(300);
                this.attackCooldown = 40;
                break;
            }
            case 2: {
                if (!this.field_70170_p.field_72995_K) {
                    this.tryToEvadeTarget();
                }
                if (this.getAttackTime() != 1) break;
                this.attackCooldown = 40;
                break;
            }
            case 3: {
                if (this.func_70638_az() != null && (this.func_70638_az().func_70032_d((Entity)this) < 12.0f || MathHelper.func_76128_c((double)this.func_70638_az().field_70163_u) > MathHelper.func_76128_c((double)this.field_70163_u))) {
                    this.func_70091_d(0.0, 0.25, 0.0);
                    break;
                }
                this.attackCooldown = 0;
                this.field_70180_af.func_75692_b(17, (Object)0);
                break;
            }
            case 4: {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                if (this.getAttackTime() % 20 != 10 || this.field_70170_p.field_72995_K) break;
                double size = 17.5;
                int var3 = MathHelper.func_76128_c((double)(this.field_70165_t - size - 1.0));
                int var4 = MathHelper.func_76128_c((double)(this.field_70165_t + size + 1.0));
                int var5 = MathHelper.func_76128_c((double)(this.field_70163_u - size - 1.0));
                int var29 = MathHelper.func_76128_c((double)(this.field_70163_u + size + 1.0));
                int var7 = MathHelper.func_76128_c((double)(this.field_70161_v - size - 1.0));
                int var30 = MathHelper.func_76128_c((double)(this.field_70161_v + size + 1.0));
                List var9 = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)var3, (double)var5, (double)var7, (double)var4, (double)var29, (double)var30));
                ArrayList<Entity> var10 = new ArrayList<Entity>();
                for (int i = 0; i < var9.size(); ++i) {
                    Entity entity = (Entity)var9.get(i);
                    if ((!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71075_bZ.field_75098_d) && (this.func_70638_az() == null || !entity.func_70028_i((Entity)this.func_70638_az()))) continue;
                    var10.add(entity);
                }
                for (int var11 = 0; var11 < 5; ++var11) {
                    double var19;
                    double var17;
                    double var15;
                    double var34;
                    double var13;
                    Entity var32 = null;
                    if (var10.size() > 1) {
                        var32 = (Entity)var10.get(this.field_70146_Z.nextInt(var10.size()));
                    } else if (var10.size() == 1) {
                        var32 = (Entity)var10.get(0);
                    }
                    if (var32 == null || !((var13 = var32.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) / size) <= 1.0) || (var34 = (double)MathHelper.func_76133_a((double)((var15 = var32.field_70165_t - this.field_70165_t) * var15 + (var17 = var32.field_70163_u + (double)var32.func_70047_e() - this.field_70163_u) * var17 + (var19 = var32.field_70161_v - this.field_70161_v) * var19))) == 0.0 || var32.func_85032_ar() || (!(var32 instanceof EntityPlayer) || ((EntityPlayer)var32).field_71075_bZ.field_75098_d) && var32 != this.func_70638_az()) continue;
                    EntityFrostBall entity = new EntityFrostBall(this.field_70170_p, (Entity)this, var32);
                    entity.field_70165_t = this.field_70165_t;
                    entity.field_70163_u = this.field_70163_u + 1.0;
                    entity.field_70161_v = this.field_70161_v;
                    entity.field_70159_w = (double)MathHelper.func_76126_a((float)((float)var11 * 2.0f * (float)Math.PI / 5.0f)) * 0.25;
                    entity.field_70179_y = (double)MathHelper.func_76134_b((float)((float)var11 * 2.0f * (float)Math.PI / 5.0f)) * 0.25;
                    this.field_70170_p.func_72838_d((Entity)entity);
                }
                break;
            }
            case 5: {
                if (!this.field_70122_E) {
                    if (this.getAttackTime() == 30) {
                        this.field_70170_p.func_72869_a("frostTrail", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                    }
                    this.field_70159_w = 0.0;
                    this.field_70181_x = -1.5;
                    this.field_70179_y = 0.0;
                    break;
                }
                this.field_70170_p.func_72869_a("frostNova", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                double size = 10.0;
                int var3 = MathHelper.func_76128_c((double)(this.field_70165_t - size - 1.0));
                int var4 = MathHelper.func_76128_c((double)(this.field_70165_t + size + 1.0));
                int var5 = MathHelper.func_76128_c((double)(this.field_70163_u - size - 1.0));
                int var29 = MathHelper.func_76128_c((double)(this.field_70163_u + size + 1.0));
                int var7 = MathHelper.func_76128_c((double)(this.field_70161_v - size - 1.0));
                int var30 = MathHelper.func_76128_c((double)(this.field_70161_v + size + 1.0));
                List var9 = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)var3, (double)var5, (double)var7, (double)var4, (double)var29, (double)var30));
                for (int var11 = 0; var11 < var9.size(); ++var11) {
                    double var19;
                    double var17;
                    double var15;
                    double var34;
                    Entity var32 = (Entity)var9.get(var11);
                    double var13 = var32.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) / size;
                    if (!(var13 <= 1.0) || (var34 = (double)MathHelper.func_76133_a((double)((var15 = var32.field_70165_t - this.field_70165_t) * var15 + (var17 = var32.field_70163_u + (double)var32.func_70047_e() - this.field_70163_u) * var17 + (var19 = var32.field_70161_v - this.field_70161_v) * var19))) == 0.0 || var32.func_85032_ar() || (!(var32 instanceof EntityPlayer) || ((EntityPlayer)var32).field_71075_bZ.field_75098_d) && var32 != this.func_70638_az() && !(var32 instanceof EntityAnimal) && !(var32 instanceof EntityMob)) continue;
                    EffectTicker.addEffect(var32, new PotionEffect(FCPotion.freeze.field_76415_H, var32 instanceof EntityPlayer ? 20 : 40), new Object[0]);
                    EffectTicker.addEffect(var32, new PotionEffect(FCPotion.frostburn.field_76415_H, 80), new Object[]{this});
                }
                if (this.getAttackTime() <= 1) break;
                this.field_70180_af.func_75692_b(17, (Object)1);
            }
        }
        if (this.getAttackTime() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(17, (Object)(this.getAttackTime() - 1));
            }
        } else if (!this.field_70170_p.field_72995_K && this.getAttack() != 0) {
            this.field_70180_af.func_75692_b(16, (Object)0);
        }
    }

    private void tryToEvadeTarget() {
        if (this.func_70638_az() != null && !this.pathSet && this.func_70661_as().func_75500_f() && this.getAttackTime() > 5 && !this.isFlying) {
            for (int i = 0; i < 15; ++i) {
                int x = this.field_70146_Z.nextInt(10) - 5 + (int)this.field_70165_t;
                int z = this.field_70146_Z.nextInt(10) - 5 + (int)this.field_70161_v;
                int y = this.field_70146_Z.nextInt(10) - 5 + (int)this.field_70163_u;
                if (!(this.func_70638_az().func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) + 3.0 < this.func_70638_az().func_70011_f((double)x, (double)y, (double)z)) || this.field_70170_p.func_147439_a(x, y, z).func_149688_o() != Material.field_151579_a) continue;
                this.func_70661_as().func_75484_a(this.field_70170_p.func_72844_a((Entity)this, MathHelper.func_76128_c((double)x), y, MathHelper.func_76128_c((double)z), (float)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), true, true, true, true), 1.0);
                if (this.func_70661_as().func_75500_f()) continue;
                this.attackCooldown = this.getAttackTime();
                this.pathSet = true;
                break;
            }
        } else if (this.getAttackTime() >= 5 && this.isFlying && !this.pathSet) {
            if (!this.func_70661_as().func_75500_f()) {
                this.func_70661_as().func_75499_g();
            }
            for (int i = 0; i < 15; ++i) {
                int x = this.field_70146_Z.nextInt(10) - 5 + (int)this.field_70165_t;
                int z = this.field_70146_Z.nextInt(10) - 5 + (int)this.field_70161_v;
                int y = this.field_70146_Z.nextInt(10) - 5 + (int)this.field_70163_u;
                if (this.func_70638_az() == null || !(this.func_70638_az().func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) + 3.0 < this.func_70638_az().func_70011_f((double)x, (double)y, (double)z)) || this.field_70170_p.func_147439_a(x, y, z).func_149688_o() != Material.field_151579_a) continue;
                this.path = Vec3.func_72443_a((double)x, (double)y, (double)z);
                if (this.path == null) continue;
                this.attackCooldown = this.getAttackTime();
                this.pathSet = true;
                break;
            }
        }
        if (this.path != null && this.pathSet) {
            this.func_70605_aq().func_75642_a(this.path.field_72450_a, this.path.field_72448_b, this.path.field_72449_c, 1.0);
        }
        if ((this.func_70661_as().func_75505_d() != null && this.func_70661_as().func_75505_d().func_75879_b() || this.path != null && MathHelper.func_76128_c((double)this.path.field_72450_a) == MathHelper.func_76128_c((double)this.field_70165_t) && MathHelper.func_76128_c((double)this.path.field_72448_b) == MathHelper.func_76128_c((double)this.field_70163_u) && MathHelper.func_76128_c((double)this.path.field_72449_c) == MathHelper.func_76128_c((double)this.field_70161_v)) && this.getAttackTime() > 5) {
            this.attackCooldown = 0;
            this.field_70180_af.func_75692_b(17, (Object)5);
        }
        if (this.func_70638_az() != null && (double)this.func_70638_az().func_70032_d((Entity)this) > 19.0) {
            this.attackCooldown = 0;
            this.field_70180_af.func_75692_b(17, (Object)5);
        }
        if (this.getAttackTime() <= 5) {
            this.attackCooldown = 0;
            this.func_70661_as().func_75499_g();
            this.pathSet = false;
            this.path = null;
        }
    }

    private void performAttack(int attack) {
        switch (attack) {
            case 1: {
                this.field_70180_af.func_75692_b(17, (Object)60);
                this.field_70180_af.func_75692_b(16, (Object)attack);
                break;
            }
            case 2: {
                this.field_70180_af.func_75692_b(17, (Object)100);
                this.field_70180_af.func_75692_b(16, (Object)attack);
                break;
            }
            case 3: {
                this.field_70180_af.func_75692_b(17, (Object)80);
                this.field_70180_af.func_75692_b(16, (Object)attack);
                break;
            }
            case 4: {
                this.field_70180_af.func_75692_b(17, (Object)60);
                this.field_70180_af.func_75692_b(16, (Object)attack);
                break;
            }
            case 5: {
                this.field_70180_af.func_75692_b(17, (Object)30);
                this.field_70180_af.func_75692_b(16, (Object)attack);
            }
        }
    }

    private int getTotalAttackChance() {
        int total = 0;
        for (int i = 0; i < this.amountOfAttacks; ++i) {
            total += this.getAttackChance(i + 1);
        }
        return total;
    }

    private int getAttackChance(int attack) {
        switch (attack) {
            case 1: {
                return 2;
            }
            case 2: {
                if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityAnimal) {
                    return 0;
                }
                if (this.func_110143_aJ() / this.func_110138_aP() < 0.25f) {
                    return 3;
                }
                if (this.func_110143_aJ() / this.func_110138_aP() < 0.5f) {
                    return 2;
                }
                return 1;
            }
            case 3: {
                if (this.func_70638_az() != null && this.func_70638_az().field_70163_u > this.field_70163_u && this.func_70638_az().func_70032_d((Entity)this) > 10.0f) {
                    return 7;
                }
                if (this.func_70638_az() != null && this.func_70638_az().func_70032_d((Entity)this) < 5.0f) {
                    return 4;
                }
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                if (this.isFlying && this.flyingTime > 70 && this.func_70638_az() != null && this.func_70638_az().field_70122_E && this.func_70638_az().func_70011_f(this.field_70165_t, this.func_70638_az().field_70163_u, this.field_70163_u) < 9.0) {
                    return 3;
                }
                if (this.isFlying && this.flyingTime > 70) {
                    return 2;
                }
                return 0;
            }
        }
        return 0;
    }

    private int getAttackByChance(int chance) {
        int counter = 0;
        for (int i = 1; i < this.amountOfAttacks + 1; ++i) {
            if (chance > (counter += this.getAttackChance(i))) continue;
            return i;
        }
        return 0;
    }

    public int getAttack() {
        return this.field_70180_af.func_75679_c(16);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void onRotationFinish(String name, EnumAxis axis) {
        if (name.matches("wingLeft") && axis == EnumAxis.X) {
            if (this.rotationHelper.getEntryList().getEntry(name).getRawRotation(axis) == 0.0f) {
                if (this.getAttackTime() > 5 && this.getAttack() == 1) {
                    this.addRotationOverTime("wingLeft", EnumAxis.X, -0.05f, 75);
                    this.addRotationOverTime("wingRight", EnumAxis.X, -0.05f, 75);
                    this.addRotationOverTime("wingLeftOuter", EnumAxis.X, -0.55f, 75);
                    this.addRotationOverTime("wingRightOuter", EnumAxis.X, -0.55f, 75);
                }
                return;
            }
            if (this.rotationHelper.getEntryList().getEntry(name).getRawRotation(axis) == -0.05f) {
                if (this.getAttackTime() > 5 && this.getAttack() == 1) {
                    this.addRotationOverTime("wingLeft", EnumAxis.X, -0.0f, 75);
                    this.addRotationOverTime("wingRight", EnumAxis.X, -0.0f, 75);
                    this.addRotationOverTime("wingLeftOuter", EnumAxis.X, -0.5f, 75);
                    this.addRotationOverTime("wingRightOuter", EnumAxis.X, -0.5f, 75);
                }
                return;
            }
        }
        if (name.matches("wingLeft") && axis == EnumAxis.Z) {
            if (this.rotationHelper.getEntryList().getEntry(name).getRawRotation(axis) == -0.1f || this.rotationHelper.getEntryList().getEntry(name).getRawRotation(axis) == -0.3f) {
                this.addRotationOverTime("wingLeft", EnumAxis.Z, -0.7f, 500);
                this.addRotationOverTime("wingRight", EnumAxis.Z, 0.7f, 500);
                this.addRotationOverTime("wingLeftOuter", EnumAxis.Z, -0.2f, 500);
                this.addRotationOverTime("wingRightOuter", EnumAxis.Z, 0.2f, 500);
                this.addRotationOverTime("body", EnumAxis.X, -0.33f, 500);
                return;
            }
            if (this.rotationHelper.getEntryList().getEntry(name).getRawRotation(axis) == -0.7f) {
                this.addRotationOverTime("wingLeft", EnumAxis.Z, -0.1f, 250);
                this.addRotationOverTime("wingRight", EnumAxis.Z, 0.1f, 250);
                this.addRotationOverTime("wingLeftOuter", EnumAxis.Z, 0.2f, 250);
                this.addRotationOverTime("wingRightOuter", EnumAxis.Z, -0.2f, 250);
                this.addRotationOverTime("body", EnumAxis.X, -0.27f, 250);
                return;
            }
        }
    }

    public void resetRotations(int time) {
        this.addRotationOverTime("body", EnumAxis.X, -0.3f, 1);
        this.addRotationOverTime("body", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("body", EnumAxis.Z, 0.0f, time);
        this.addRotationOverTime("head", EnumAxis.X, 0.0f, time);
        this.addRotationOverTime("head", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("head", EnumAxis.Z, 0.0f, time);
        this.addRotationOverTime("wingLeft", EnumAxis.X, 0.0f, time);
        this.addRotationOverTime("wingLeft", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("wingRight", EnumAxis.X, 0.0f, time);
        this.addRotationOverTime("wingRight", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("wingLeftOuter", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("wingRightOuter", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("tailPiece", EnumAxis.X, 0.1f, time);
        this.addRotationOverTime("tailPiece", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("tailPiece", EnumAxis.Z, 0.0f, time);
        this.addRotationOverTime("leftLeg", EnumAxis.X, 0.3f, time);
        this.addRotationOverTime("leftLeg", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("leftLeg", EnumAxis.Z, 0.0f, time);
        this.addRotationOverTime("rightLeg", EnumAxis.X, 0.3f, time);
        this.addRotationOverTime("rightLeg", EnumAxis.Y, 0.0f, time);
        this.addRotationOverTime("rightLeg", EnumAxis.Z, 0.0f, time);
        if (this.isFlying) {
            this.addRotationOverTime("wingLeftOuter", EnumAxis.X, -0.4f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.X, -0.4f, 100);
            this.addRotationOverTime("wingLeft", EnumAxis.Z, -0.7f, 100);
            this.addRotationOverTime("wingRight", EnumAxis.Z, 0.7f, 100);
            this.addRotationOverTime("wingLeftOuter", EnumAxis.Z, -0.2f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.Z, 0.2f, 100);
        } else {
            this.addRotationOverTime("wingLeftOuter", EnumAxis.X, 0.0f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.X, 0.0f, 100);
            this.addRotationOverTime("wingLeft", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("wingRight", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("wingLeftOuter", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("wingRightOuter", EnumAxis.Z, 0.0f, 100);
            this.addRotationOverTime("body", EnumAxis.X, -0.3f, 25);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70650_aV() {
        return this.getAttack() != 1 || !this.isFlying;
    }

    protected boolean func_70780_i() {
        return this.getAttack() == 1;
    }

    protected Entity func_70782_k() {
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return entityplayer != null && this.func_70685_l((Entity)entityplayer) ? entityplayer : null;
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
        if (this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            this.field_70160_al = true;
            float f1 = MathHelper.func_76133_a((double)(par3 * par3 + par5 * par5));
            float f2 = 0.4f;
            this.field_70159_w /= 2.0;
            this.field_70181_x /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= par3 / (double)f1 * (double)f2;
            this.field_70181_x += (double)f2;
            this.field_70179_y -= par5 / (double)f1 * (double)f2;
            if (this.field_70181_x > (double)0.4f) {
                this.field_70181_x = 0.4f;
            }
            if (this.isFlying) {
                this.field_70181_x = -0.7;
                this.attackCooldown = 20;
            }
        }
    }

    public int func_70658_aO() {
        return 5;
    }

    protected void func_70069_a(float par1) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Attack", this.getAttack());
        par1NBTTagCompound.func_74768_a("ATime", this.getAttackTime());
        par1NBTTagCompound.func_74768_a("AttackCooldown", this.attackCooldown);
        par1NBTTagCompound.func_74768_a("StatueX", this.ck.field_71574_a);
        par1NBTTagCompound.func_74768_a("StatueY", this.ck.field_71572_b);
        par1NBTTagCompound.func_74768_a("StatueZ", this.ck.field_71573_c);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.field_70180_af.func_75692_b(16, (Object)par1NBTTagCompound.func_74762_e("Attack"));
        this.field_70180_af.func_75692_b(17, (Object)par1NBTTagCompound.func_74762_e("ATime"));
        this.attackCooldown = par1NBTTagCompound.func_74762_e("AttackCooldown");
        int x = par1NBTTagCompound.func_74762_e("StatueX");
        int y = par1NBTTagCompound.func_74762_e("StatueY");
        int z = par1NBTTagCompound.func_74762_e("StatueZ");
        this.ck = new ChunkCoordinates(x, y, z);
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (this.ck.field_71574_a != 0 || this.ck.field_71572_b != 0 || this.ck.field_71573_c != 0) {
            ItemStack itemOrb = new ItemStack(IdMap.itemFrostOrb);
            if (itemOrb.field_77990_d == null) {
                itemOrb.field_77990_d = new NBTTagCompound();
            }
            itemOrb.func_77978_p().func_74768_a("xCoord", this.ck.field_71574_a);
            itemOrb.func_77978_p().func_74768_a("yCoord", this.ck.field_71572_b);
            itemOrb.func_77978_p().func_74768_a("zCoord", this.ck.field_71573_c);
            itemOrb.func_77978_p().func_74757_a("removed", false);
            this.func_70099_a(itemOrb, 0.0f);
        }
    }
}

