/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import xelitez.frostcraft.enums.EnumWeaponClass;
import xelitez.frostcraft.registry.IdMap;

public class EntityAIAttackUsingWeapon
extends EntityAIBase {
    EntityCreature attacker;
    int attackTick;
    double speedTowardsTarget;
    boolean longMemory;
    int followTicks = 0;
    PathEntity entityPathEntity;
    Class<?> classTarget;
    private int field_75445_i;
    private double field_151497_i;
    private double field_151495_j;
    private double field_151496_k;
    private int failedPathFindingPenalty;
    private Item WeaponItem;
    private EnumWeaponClass weaponClass;
    private EntityLivingBase attackTarget;
    private int field_75318_f;
    private int field_96561_g;
    private int maxRangedAttackTime;
    private float field_96562_i;
    private float field_82642_h;

    public EntityAIAttackUsingWeapon(EntityCreature par1EntityCreature, Class<?> par2Class, double par3, boolean par5, Item weaponItem, EnumWeaponClass weaponClass, Object ... rangedData) {
        this(par1EntityCreature, par3, par5, weaponItem, weaponClass, rangedData);
        this.classTarget = par2Class;
    }

    public EntityAIAttackUsingWeapon(EntityCreature par1EntityCreature, double par2, boolean par4, Item weaponItem, EnumWeaponClass weaponClass, Object ... rangedData) {
        this.attacker = par1EntityCreature;
        this.WeaponItem = weaponItem;
        this.speedTowardsTarget = par2;
        this.longMemory = par4;
        this.func_75248_a(3);
        this.weaponClass = weaponClass;
        if (weaponClass == EnumWeaponClass.RANGED && !(par1EntityCreature instanceof IRangedAttackMob)) {
            throw new IllegalArgumentException("RANGED attack entities require Mob implements RangedAttackMob");
        }
        if (this.weaponClass == EnumWeaponClass.RANGED) {
            this.field_96561_g = (Integer)rangedData[0];
            this.maxRangedAttackTime = (Integer)rangedData[1];
            this.field_96562_i = ((Float)rangedData[2]).floatValue();
            this.field_82642_h = ((Float)rangedData[2]).floatValue() * ((Float)rangedData[2]).floatValue();
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (this.WeaponItem != null && this.attacker.func_70694_bm() != null && this.WeaponItem != this.attacker.func_70694_bm().func_77973_b()) {
            return false;
        }
        if (this.weaponClass == EnumWeaponClass.MELEE) {
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.classTarget != null && !this.classTarget.isAssignableFrom(entitylivingbase.getClass())) {
                return false;
            }
            if (--this.field_75445_i <= 0) {
                this.entityPathEntity = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.field_75445_i = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.entityPathEntity != null;
            }
            return true;
        }
        if (entitylivingbase == null || entitylivingbase == this.attacker) {
            return false;
        }
        if (this.attackTarget != entitylivingbase) {
            this.followTicks = 0;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        ++this.followTicks;
        if (this.attacker.func_70638_az() != null && this.isValidBlock(this.attacker.func_70638_az().field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.attacker.func_70638_az().field_70165_t), MathHelper.func_76128_c((double)this.attacker.func_70638_az().field_70163_u) - 1, MathHelper.func_76128_c((double)this.attacker.func_70638_az().field_70161_v)))) {
            this.followTicks = 0;
        }
        if (this.followTicks > 400) {
            return false;
        }
        if (this.weaponClass == EnumWeaponClass.MELEE) {
            EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (!this.longMemory ? !this.attacker.func_70661_as().func_75500_f() : this.attacker.func_110176_b(MathHelper.func_76128_c((double)entitylivingbase.field_70165_t), MathHelper.func_76128_c((double)entitylivingbase.field_70163_u), MathHelper.func_76128_c((double)entitylivingbase.field_70161_v))));
        }
        return this.func_75250_a() || !this.attacker.func_70661_as().func_75500_f();
    }

    private boolean isValidBlock(Block block) {
        if (block == IdMap.blockBlackFrost) {
            return true;
        }
        if (block == IdMap.blockBlackFrostStair) {
            return true;
        }
        if (block == IdMap.blockBlackFrostStairBrick) {
            return true;
        }
        if (block == IdMap.blockBlackFrostStairCobble) {
            return true;
        }
        if (block == IdMap.blockBlackFrostSingleSlabSet) {
            return true;
        }
        return block == IdMap.blockBlackFrostDoubleSlabSet;
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.entityPathEntity, this.speedTowardsTarget);
        this.field_75445_i = 0;
    }

    public void func_75251_c() {
        this.attacker.func_70661_as().func_75499_g();
        this.attacker.func_70624_b(null);
    }

    public void func_75246_d() {
        if (this.weaponClass == EnumWeaponClass.MELEE) {
            EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            double d0 = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.field_70121_D.field_72338_b, entitylivingbase.field_70161_v);
            double d1 = this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + entitylivingbase.field_70130_N;
            --this.field_75445_i;
            if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.field_75445_i <= 0 && (this.field_151497_i == 0.0 && this.field_151495_j == 0.0 && this.field_151496_k == 0.0 || entitylivingbase.func_70092_e(this.field_151497_i, this.field_151495_j, this.field_151496_k) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
                PathPoint finalPathPoint;
                this.field_151497_i = entitylivingbase.field_70165_t;
                this.field_151495_j = entitylivingbase.field_70121_D.field_72338_b;
                this.field_151496_k = entitylivingbase.field_70161_v;
                this.field_75445_i = this.failedPathFindingPenalty + 4 + this.attacker.func_70681_au().nextInt(7);
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                if (d0 > 1024.0) {
                    this.field_75445_i += 10;
                } else if (d0 > 256.0) {
                    this.field_75445_i += 5;
                }
                if (!this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                    this.field_75445_i += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (d0 <= d1 && this.attackTick <= 20) {
                this.attackTick = 20;
                if (this.attacker.func_70694_bm() != null) {
                    this.attacker.func_71038_i();
                }
                this.attacker.func_70652_k((Entity)entitylivingbase);
            }
        } else {
            double d0 = this.attacker.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
            boolean flag = this.attacker.func_70635_at().func_75522_a((Entity)this.attackTarget);
            this.field_75318_f = flag ? ++this.field_75318_f : 0;
            if (d0 <= (double)this.field_82642_h && this.field_75318_f >= 20) {
                this.attacker.func_70661_as().func_75499_g();
            } else {
                this.attacker.func_70661_as().func_75497_a((Entity)this.attackTarget, this.speedTowardsTarget);
            }
            this.attacker.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.attackTick == 0) {
                float f;
                if (d0 > (double)this.field_82642_h || !flag) {
                    return;
                }
                float f1 = f = MathHelper.func_76133_a((double)d0) / this.field_96562_i;
                if (f < 0.1f) {
                    f1 = 0.1f;
                }
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                ((IRangedAttackMob)this.attacker).func_82196_d(this.attackTarget, f1);
                this.attackTick = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.field_96561_g) + (float)this.field_96561_g));
            } else if (this.attackTick < 0) {
                float f = MathHelper.func_76133_a((double)d0) / this.field_96562_i;
                this.attackTick = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.field_96561_g) + (float)this.field_96561_g));
            }
        }
    }
}

