/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.scf.content;

import edgarallen.scf.gui.inventory.DualInventoryWrapper;
import edgarallen.scf.platform.Config;
import edgarallen.scf.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCraftingFrame
extends TileEntity {
    public InventoryCrafting craftMatrix = new InternalInventoryCrafting();
    public InventoryCraftResult craftResult = new InventoryCraftResult();

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < this.craftMatrix.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = this.craftMatrix.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", slot);
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a("matrix", (NBTBase)list);
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        NBTTagList list = data.func_74761_m("matrix");
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = (NBTTagCompound)list.func_74743_b(entry);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.craftMatrix.func_70302_i_()) continue;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            this.craftMatrix.func_70299_a((int)slot, stack);
        }
        this.craftResult.func_70299_a(0, this.findMatchingRecipe(this.craftMatrix));
    }

    public Packet func_70319_e() {
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < this.craftMatrix.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = this.craftMatrix.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", slot);
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a("matrix", (NBTBase)list);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, data);
    }

    public void onDataPacket(INetworkManager manager, Packet132TileEntityData packet) {
        this.clearInventory(this.craftMatrix);
        NBTTagCompound data = packet.field_73331_e;
        NBTTagList list = data.func_74761_m("matrix");
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = (NBTTagCompound)list.func_74743_b(entry);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.craftMatrix.func_70302_i_()) continue;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            this.craftMatrix.func_70299_a((int)slot, stack);
        }
        this.craftResult.func_70299_a(0, this.findMatchingRecipe(this.craftMatrix));
    }

    private void clearInventory(InventoryCrafting craftMatrix) {
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            craftMatrix.func_70299_a(i, null);
        }
    }

    private ItemStack findMatchingRecipe(InventoryCrafting craftMatrix) {
        return CraftingManager.func_77594_a().func_82787_a(craftMatrix, this.field_70331_k);
    }

    public void craftStack(EntityPlayer player) {
        ItemStack stack = this.craftResult.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack result = stack.func_77946_l();
            result.field_77994_a = result.func_77976_d();
            Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, result);
            return;
        }
        IInventory inv = Utils.getAttachedInventory(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        int numCrafted = 0;
        block0: while (numCrafted < stack.func_77976_d()) {
            ItemStack result;
            if (Config.checkInventory && inv != null) {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack1 = inv.func_70301_a(i);
                    if (!Utils.isMatchingItem(stack, stack1)) continue;
                    ItemStack result2 = inv.func_70298_a(i, 1);
                    Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, result2);
                    ++numCrafted;
                    continue block0;
                }
            }
            if (!this.hasIngredients(player, inv) || (result = this.doCraft(player, inv)) == null) break;
            numCrafted += result.field_77994_a;
            Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, result);
        }
    }

    public void craftItem(EntityPlayer player) {
        ItemStack stack = this.craftResult.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack result = stack.func_77946_l();
            result.field_77994_a = 1;
            Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, result);
            return;
        }
        IInventory inv = Utils.getAttachedInventory(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (Config.checkInventory && inv != null) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack1 = inv.func_70301_a(i);
                if (!Utils.isMatchingItem(stack, stack1)) continue;
                ItemStack result = inv.func_70298_a(i, 1);
                Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, result);
                return;
            }
        }
        if (this.hasIngredients(player, inv)) {
            ItemStack result = this.doCraft(player, inv);
            Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, result);
        }
    }

    private ItemStack doCraft(EntityPlayer player, IInventory attachedInventory) {
        InventoryCrafting tempMatrix = this.getTempCraftingMatrix();
        InventoryCraftResult tempResult = new InventoryCraftResult();
        SlotCrafting slotCrafting = new SlotCrafting(player, (IInventory)tempMatrix, (IInventory)tempResult, 0, 0, 0);
        DualInventoryWrapper di = new DualInventoryWrapper(attachedInventory, player.field_71071_by);
        int[] bindings = new int[9];
        block0: for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack mstack = this.craftMatrix.func_70301_a(i);
            if (mstack == null) {
                bindings[i] = -1;
                continue;
            }
            for (int j = 0; j < di.func_70302_i_(); ++j) {
                ItemStack istack = di.func_70301_a(j);
                if (istack == null || !Utils.isItemEquivalent(mstack, istack, true)) continue;
                bindings[i] = j;
                tempMatrix.func_70299_a(i, di.func_70298_a(j, 1));
                continue block0;
            }
        }
        ItemStack result = this.findMatchingRecipe(tempMatrix);
        if (result != null) {
            slotCrafting.func_82870_a(player, result);
            for (int i = 0; i < tempMatrix.func_70302_i_(); ++i) {
                ItemStack tms = tempMatrix.func_70301_a(i);
                if (tms == null) continue;
                tempMatrix.func_70299_a(i, null);
                ItemStack tmp = di.func_70301_a(bindings[i]);
                if (tmp == null) {
                    di.func_70299_a(bindings[i], tms);
                    continue;
                }
                Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, result);
            }
        }
        player.field_71069_bz.func_75142_b();
        return result;
    }

    private boolean hasIngredients(EntityPlayer player, IInventory attachedInventory) {
        DualInventoryWrapper inv = new DualInventoryWrapper(attachedInventory, player.field_71071_by);
        int[] hitcount = new int[inv.func_70302_i_()];
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack mstack = this.craftMatrix.func_70301_a(i);
            if (mstack == null) continue;
            boolean found = false;
            for (int j = 0; j < inv.func_70302_i_(); ++j) {
                ItemStack istack = inv.func_70301_a(j);
                if (istack == null || !Utils.isItemEquivalent(mstack, istack, true) || hitcount[j] >= istack.field_77994_a || hitcount[j] >= istack.func_77976_d()) continue;
                int n = j;
                hitcount[n] = hitcount[n] + 1;
                found = true;
                break;
            }
            if (found) continue;
            player.func_71035_c("Missing ingredient: " + mstack.func_82833_r());
            return false;
        }
        return true;
    }

    private InventoryCrafting getTempCraftingMatrix() {
        return new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }
        }, 3, 3);
    }

    private final class InternalInventoryCrafting
    extends InventoryCrafting {
        public InternalInventoryCrafting() {
            super(new Container(){

                public boolean func_75145_c(EntityPlayer entityplayer) {
                    return false;
                }
            }, 3, 3);
        }
    }
}

