/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.scf.content;

import edgarallen.scf.platform.KeyHandler;
import edgarallen.scf.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileEntitySuperItemFrame
extends TileEntity {
    private static final long doubleClickDelay = 5L;
    public ItemStack displayedItem;
    private long timeOfLastClick = -1000L;

    public void onClicked(EntityPlayer player) {
        this.trySetDisplayItem(player.func_71045_bC());
        if (this.displayedItem != null) {
            ItemStack stack = KeyHandler.craftStacksPressed ? this.getStackToEject() : this.getItemToEject();
            if (stack != null) {
                Utils.ejectItem(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack);
            } else {
                player.func_71035_c("Count: 0");
            }
        }
    }

    public void onActivated(EntityPlayer player) {
        if (this.displayedItem == null && player.func_71045_bC() != null) {
            ItemStack stack = player.func_71045_bC().func_77946_l();
            stack.field_77994_a = 1;
            this.setDisplayedItem(stack);
        } else if (this.displayedItem != null && player.func_70093_af() && player.func_71045_bC() == null) {
            this.setDisplayedItem(null);
        } else if (player.func_71045_bC() != null) {
            if (Utils.isMatchingItem(this.displayedItem, player.func_71045_bC())) {
                if (KeyHandler.craftStacksPressed || this.field_70331_k.func_72820_D() - this.timeOfLastClick < 5L) {
                    this.insertAll(player);
                } else {
                    this.timeOfLastClick = this.field_70331_k.func_72820_D();
                    this.insertItem(player);
                }
            } else {
                player.func_71035_c("Count: " + this.getInventoryCount());
            }
        } else if (this.displayedItem != null && player.func_71045_bC() == null) {
            player.func_71035_c("Count: " + this.getInventoryCount());
        }
    }

    private int getInventoryCount() {
        int count = 0;
        IInventory inv = Utils.getAttachedInventory(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (inv != null) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || !Utils.isMatchingItem(this.displayedItem, stack)) continue;
                count += stack.field_77994_a;
            }
        }
        return count;
    }

    private ItemStack getStackToEject() {
        IInventory inv = Utils.getAttachedInventory(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (inv == null) {
            return null;
        }
        ItemStack output = this.displayedItem.func_77946_l();
        output.field_77994_a = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack;
            int stackSpace = output.func_77976_d() - output.field_77994_a;
            if (stackSpace <= 0 || (stack = inv.func_70301_a(i)) == null || !Utils.isItemEquivalent(this.displayedItem, stack, false)) continue;
            if (stack.field_77994_a < stackSpace) {
                output.field_77994_a += stack.field_77994_a;
                inv.func_70299_a(i, null);
                continue;
            }
            output.field_77994_a += stackSpace;
            inv.func_70298_a(i, stackSpace);
            inv.func_70296_d();
            return output;
        }
        if (output.field_77994_a > 0) {
            inv.func_70296_d();
            return output;
        }
        return null;
    }

    private ItemStack getItemToEject() {
        IInventory inv = Utils.getAttachedInventory(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (inv == null) {
            return null;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !Utils.isItemEquivalent(this.displayedItem, stack, true)) continue;
            return inv.func_70298_a(i, 1);
        }
        return null;
    }

    public void setDisplayedItem(ItemStack stack) {
        this.displayedItem = stack;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.displayedItem != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.displayedItem.func_77955_b(tag);
            data.func_74766_a("i", tag);
        }
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        NBTTagCompound tag = data.func_74775_l("i");
        if (tag != null) {
            this.displayedItem = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.displayedItem != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.displayedItem.func_77955_b(tag);
            data.func_74766_a("i", tag);
        }
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, data);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        NBTTagCompound data = packet.field_73331_e;
        NBTTagCompound tag = data.func_74775_l("i");
        if (tag != null) {
            this.displayedItem = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    private void trySetDisplayItem(ItemStack stack) {
        if (this.displayedItem == null && stack != null) {
            ItemStack s = stack.func_77946_l();
            s.field_77994_a = 1;
            this.setDisplayedItem(s);
        }
    }

    public void insertItem(EntityPlayer player) {
        int count = player.func_71045_bC().field_77994_a;
        IInventory inv = Utils.getAttachedInventory(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (inv != null) {
            ItemStack stack = Utils.insertItemIntoInventory(inv, player.func_71045_bC());
            if (stack != null && stack.field_77994_a == count) {
                player.func_71035_c("Inventory Full.");
                return;
            }
            player.field_71071_by.func_70296_d();
            player.field_71069_bz.func_75142_b();
        }
    }

    public void insertAll(EntityPlayer player) {
        IInventory inv = Utils.getAttachedInventory(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        InventoryPlayer invP = player.field_71071_by;
        if (inv != null) {
            for (int i = 0; i < invP.field_70462_a.length; ++i) {
                ItemStack is = invP.field_70462_a[i];
                if (is == null || is.field_77994_a <= 0 || !Utils.isMatchingItem(this.displayedItem, is)) continue;
                for (int j = is.field_77994_a; j > 0; --j) {
                    int ss = is.field_77994_a;
                    Utils.insertItemIntoInventory(inv, is);
                    if (ss != is.field_77994_a) continue;
                    player.func_71035_c("Inventory Full.");
                    player.field_71071_by.func_70296_d();
                    player.field_71069_bz.func_75142_b();
                    return;
                }
                if (is.field_77994_a > 0) continue;
                invP.func_70299_a(i, null);
            }
            player.field_71071_by.func_70296_d();
            player.field_71069_bz.func_75142_b();
        }
    }
}

