/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.scf.utils;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static void ejectItem(World world, int x, int y, int z, ItemStack stack) {
        if (stack != null && stack.field_77994_a != 0) {
            Vec3 position = world.func_82732_R().func_72345_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            Vec3 velocity = world.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
            int side = world.func_72805_g(x, y, z);
            if (side == 3) {
                position.field_72449_c -= 0.25;
                position.field_72448_b -= 0.25;
                velocity.field_72449_c = 0.2;
            } else if (side == 2) {
                position.field_72449_c += 0.25;
                position.field_72448_b -= 0.25;
                velocity.field_72449_c = -0.2;
            } else if (side == 4) {
                position.field_72450_a += 0.25;
                position.field_72448_b -= 0.25;
                velocity.field_72450_a = -0.2;
            } else if (side == 5) {
                position.field_72450_a -= 0.25;
                position.field_72448_b -= 0.25;
                velocity.field_72450_a = 0.2;
            }
            EntityItem item = new EntityItem(world, position.field_72450_a, position.field_72448_b, position.field_72449_c, stack);
            item.field_70159_w = velocity.field_72450_a;
            item.field_70181_x = velocity.field_72448_b;
            item.field_70179_y = velocity.field_72449_c;
            world.func_72838_d((Entity)item);
        }
    }

    public static IInventory getAttachedInventory(World world, int xCoord, int yCoord, int zCoord) {
        int side = world.func_72805_g(xCoord, yCoord, zCoord);
        TileEntity tile = null;
        if (side == 2) {
            tile = world.func_72796_p(xCoord, yCoord, zCoord + 1);
        } else if (side == 3) {
            tile = world.func_72796_p(xCoord, yCoord, zCoord - 1);
        } else if (side == 4) {
            tile = world.func_72796_p(xCoord + 1, yCoord, zCoord);
        } else if (side == 5) {
            tile = world.func_72796_p(xCoord - 1, yCoord, zCoord);
        }
        if (tile != null && tile instanceof IInventory) {
            return Utils.getFullInventory((IInventory)tile);
        }
        return null;
    }

    public static IInventory getFullInventory(IInventory inv) {
        if (!(inv instanceof TileEntityChest)) {
            return inv;
        }
        TileEntityChest chest = (TileEntityChest)inv;
        TileEntityChest adjacent = null;
        if (chest.field_70421_d != null) {
            adjacent = chest.field_70421_d;
        }
        if (chest.field_70424_c != null) {
            adjacent = chest.field_70424_c;
        }
        if (chest.field_70423_b != null) {
            adjacent = chest.field_70423_b;
        }
        if (chest.field_70422_e != null) {
            adjacent = chest.field_70422_e;
        }
        return adjacent == null ? inv : new InventoryLargeChest("", inv, (IInventory)adjacent);
    }

    public static boolean isItemEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary) {
        int idComp;
        int idBase;
        if (Utils.isMatchingItem(base, comparison)) {
            return true;
        }
        return oreDictionary && (idBase = OreDictionary.getOreID((ItemStack)base)) >= 0 && (idComp = OreDictionary.getOreID((ItemStack)comparison)) >= 0 && idBase == idComp;
    }

    public static boolean isMatchingItem(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.field_77993_c != comparison.field_77993_c) {
            return false;
        }
        if (base.func_77973_b().func_77614_k() && base.func_77960_j() != Short.MAX_VALUE && base.func_77960_j() != comparison.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }

    public static ItemStack insertItemIntoInventory(IInventory inv, ItemStack stack) {
        if (stack != null && inv != null) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack s = inv.func_70301_a(i);
                if (s == null) {
                    inv.func_70299_a(i, stack.func_77979_a(1));
                    inv.func_70296_d();
                    return stack;
                }
                if (!Utils.isMatchingItem(stack, s) || s.field_77994_a >= s.func_77976_d()) continue;
                ++s.field_77994_a;
                --stack.field_77994_a;
                inv.func_70296_d();
                return stack;
            }
        }
        return stack;
    }
}

