/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.CatacombTunneler;
import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class CatacombNode {
    private World world;
    private Random rand;
    private CatacombLevel level;
    private List<CatacombTunneler> tunnelers;
    private ITheme theme;
    private int x;
    private int y;
    private int z;
    private IDungeon toGenerate;
    private Cardinal direction;

    public CatacombNode(World world, Random rand, CatacombLevel level, ITheme theme, int x, int y, int z) {
        this.world = world;
        this.rand = rand;
        this.level = level;
        this.theme = theme;
        this.x = x;
        this.y = y;
        this.z = z;
        this.tunnelers = new ArrayList<CatacombTunneler>();
        this.direction = Cardinal.directions[rand.nextInt(Cardinal.directions.length)];
        if (this.level.inRange(x, z)) {
            this.spawnTunnelers();
        }
    }

    public CatacombNode(World world, Random rand, CatacombLevel level, ITheme theme, CatacombTunneler tunneler) {
        this.world = world;
        this.level = level;
        this.theme = theme;
        this.x = tunneler.getX();
        this.y = tunneler.getY();
        this.z = tunneler.getZ();
        this.rand = rand;
        this.tunnelers = new ArrayList<CatacombTunneler>();
        this.direction = Cardinal.reverse(tunneler.getDirection());
        if (this.level.inRange(this.x, this.z)) {
            this.spawnTunnelers();
        }
    }

    private void spawnTunnelers() {
        for (Cardinal dir : Cardinal.directions) {
            if (dir.equals((Object)this.direction) || this.level.nodeCount() != 0 && !this.tunnelers.isEmpty() && !this.rand.nextBoolean()) continue;
            this.tunnelers.add(new CatacombTunneler(this.world, this.rand, this.level, dir, this.theme, this.x, this.y, this.z));
        }
    }

    public void update() {
        for (CatacombTunneler tunneler : this.tunnelers) {
            tunneler.update();
        }
    }

    public boolean isDone() {
        for (CatacombTunneler tunneler : this.tunnelers) {
            if (tunneler.isDone()) continue;
            return false;
        }
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void construct(World world) {
        for (CatacombTunneler tunneler : this.tunnelers) {
            tunneler.construct(world);
        }
    }

    public void segments() {
        for (CatacombTunneler tunneler : this.tunnelers) {
            tunneler.addSegments(this.world);
        }
    }

    public void setDungeon(IDungeon toGenerate) {
        this.toGenerate = toGenerate;
    }

    public int getSize() {
        if (this.toGenerate == null) {
            return 6;
        }
        return this.toGenerate.getSize();
    }
}

