/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.catacomb.dungeon.Dungeon;
import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.dungeon.IDungeonFactory;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonFactory
implements IDungeonFactory {
    private boolean secret;
    private WeightedRandomizer<Dungeon> secrets = new WeightedRandomizer();
    private List<Dungeon> singles = new ArrayList<Dungeon>();
    private WeightedRandomizer<Dungeon> multiple = new WeightedRandomizer();

    public DungeonFactory() {
    }

    public DungeonFactory(JsonArray json) {
        this();
        for (JsonElement e : json) {
            JsonObject entry = e.getAsJsonObject();
            String mode = entry.get("mode").getAsString();
            if (mode.equals("single")) {
                this.addSingle(Dungeon.valueOf(entry.get("type").getAsString()));
            }
            if (!mode.equals("random")) continue;
            this.addRandom(Dungeon.valueOf(entry.get("type").getAsString()), entry.get("weight").getAsInt());
        }
    }

    public void addSecret(Dungeon type, int weight) {
        this.secrets.add(new WeightedChoice<Dungeon>(type, weight));
    }

    public void addSingle(Dungeon type) {
        this.singles.add(type);
    }

    public void addByRatio(Dungeon toAdd, int rate) {
        if (rate <= 0) {
            return;
        }
        int max = RogueConfig.getInt(RogueConfig.LEVELMAXROOMS);
        int numRooms = max / rate;
        if (numRooms == 0) {
            this.addSingle(toAdd);
            return;
        }
        for (int i = 0; i < numRooms; ++i) {
            this.addSingle(toAdd);
        }
    }

    public void addRandom(Dungeon type, int weight) {
        this.multiple.add(new WeightedChoice<Dungeon>(type, weight));
    }

    @Override
    public IDungeon get(Random rand) {
        if (this.secret && !this.secrets.isEmpty()) {
            this.secret = false;
            return Dungeon.getInstance(this.secrets.get(rand));
        }
        if (!this.singles.isEmpty()) {
            return Dungeon.getInstance(this.singles.remove(0));
        }
        if (!this.multiple.isEmpty()) {
            return Dungeon.getInstance(this.multiple.get(rand));
        }
        return Dungeon.getInstance(Dungeon.CORNER);
    }
}

