/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.BlockFactoryCheckers;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsEnder
implements IDungeon {
    World world;
    Random rand;
    byte dungeonHeight = (byte)10;
    int dungeonLength = 4;
    int dungeonWidth = 4;

    @Override
    public boolean generate(World inWorld, Random inRandom, ITheme theme, int x, int y, int z) {
        this.world = inWorld;
        this.rand = inRandom;
        MetaBlock black = new MetaBlock(Blocks.field_150343_Z);
        MetaBlock white = new MetaBlock(Blocks.field_150371_ca);
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        for (int blockX = x - this.dungeonLength - 1; blockX <= x + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = z - this.dungeonWidth - 1; blockZ <= z + this.dungeonWidth + 1; ++blockZ) {
                for (int blockY = y - 1; blockY <= y + this.dungeonHeight; ++blockY) {
                    int height = y + this.rand.nextInt(8) + 2;
                    if (blockY > height) continue;
                    if (blockX == x - this.dungeonLength - 1 || blockZ == z - this.dungeonWidth - 1 || blockX == x + this.dungeonLength + 1 || blockZ == z + this.dungeonWidth + 1) {
                        if (blockY >= 0 && !this.world.func_147439_a(blockX, blockY - 1, blockZ).func_149688_o().func_76220_a()) {
                            WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, air);
                            continue;
                        }
                        if (!this.world.func_147439_a(blockX, blockY, blockZ).func_149688_o().func_76220_a()) continue;
                        WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, black);
                        continue;
                    }
                    WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, air);
                }
            }
        }
        BlockFactoryCheckers checkers = new BlockFactoryCheckers(black, white);
        WorldGenPrimitive.fillRectSolid(inWorld, inRandom, x - 4, y - 1, z - 4, x + 4, y - 1, z + 4, checkers, true, true);
        Spawner.generate(this.world, this.rand, x, y, z, Spawner.ENDERMAN);
        return true;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

