/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment;

import greymerk.roguelike.catacomb.segment.ISegment;
import greymerk.roguelike.catacomb.segment.part.SegmentArch;
import greymerk.roguelike.catacomb.segment.part.SegmentFire;
import greymerk.roguelike.catacomb.segment.part.SegmentInset;
import greymerk.roguelike.catacomb.segment.part.SegmentJungle;
import greymerk.roguelike.catacomb.segment.part.SegmentMossyArch;
import greymerk.roguelike.catacomb.segment.part.SegmentMossyMushrooms;
import greymerk.roguelike.catacomb.segment.part.SegmentNetherArch;
import greymerk.roguelike.catacomb.segment.part.SegmentNetherLava;
import greymerk.roguelike.catacomb.segment.part.SegmentNetherStripes;
import greymerk.roguelike.catacomb.segment.part.SegmentNetherWart;
import greymerk.roguelike.catacomb.segment.part.SegmentShelf;

public enum Segment {
    ARCH,
    FIRE,
    SHELF,
    INSET,
    MOSSYARCH,
    MOSSYMUSHROOM,
    NETHERARCH,
    NETHERSTRIPE,
    NETHERWART,
    NETHERLAVA,
    JUNGLE;

    public static final Segment[] level0;
    public static final Segment[] level1;
    public static final Segment[] level2;
    public static final Segment[] level3;
    public static final Segment[] level4;

    public static ISegment getSegment(Segment choice) {
        switch (choice) {
            case ARCH: {
                return new SegmentArch();
            }
            case FIRE: {
                return new SegmentFire();
            }
            case SHELF: {
                return new SegmentShelf();
            }
            case INSET: {
                return new SegmentInset();
            }
            case MOSSYARCH: {
                return new SegmentMossyArch();
            }
            case MOSSYMUSHROOM: {
                return new SegmentMossyMushrooms();
            }
            case NETHERARCH: {
                return new SegmentNetherArch();
            }
            case NETHERSTRIPE: {
                return new SegmentNetherStripes();
            }
            case NETHERWART: {
                return new SegmentNetherWart();
            }
            case NETHERLAVA: {
                return new SegmentNetherLava();
            }
            case JUNGLE: {
                return new SegmentJungle();
            }
        }
        return null;
    }

    static {
        level0 = new Segment[]{FIRE, SHELF, INSET};
        level1 = new Segment[]{SHELF, INSET};
        level2 = new Segment[]{SHELF, INSET};
        level3 = new Segment[]{MOSSYMUSHROOM, SHELF, INSET};
        level4 = new Segment[]{INSET, NETHERSTRIPE};
    }
}

