/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SegmentMossyArch
extends SegmentBase {
    private boolean spawnHoleSet = false;

    @Override
    protected void genWall(World world, Random rand, Cardinal wallDirection, ITheme theme, int x, int y, int z) {
        MetaBlock stair = theme.getSecondaryStair();
        stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(wallDirection), true));
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        Coord cursor = new Coord(x, y, z);
        cursor.add(wallDirection, 2);
        WorldGenPrimitive.setBlock(world, rand, cursor, air, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(world, rand, cursor, air, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(world, rand, cursor, stair, true, true);
        for (Cardinal orth : Cardinal.getOrthogonal(wallDirection)) {
            cursor = new Coord(x, y, z);
            cursor.add(orth, 1);
            cursor.add(wallDirection, 2);
            WorldGenPrimitive.setBlock(world, rand, cursor, theme.getSecondaryPillar(), true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, theme.getSecondaryPillar(), true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, theme.getSecondaryWall(), true, true);
            cursor.add(Cardinal.reverse(wallDirection), 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, stair, true, true);
        }
        cursor = new Coord(x, y, z);
        cursor.add(wallDirection, 2);
        cursor.add(Cardinal.DOWN, 1);
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150355_j);
        cursor = new Coord(x, y, z);
        cursor.add(Cardinal.UP, 3);
        cursor.add(wallDirection, 1);
        WorldGenPrimitive.setBlock(world, rand, cursor, new MetaBlock(Blocks.field_150395_bd, rand.nextInt(15)), true, true);
        if (!this.spawnHoleSet) {
            WorldGenPrimitive.fillRectSolid(world, rand, x, y + 2, z, x, y + 5, z, new MetaBlock(Blocks.field_150350_a));
            WorldGenPrimitive.randomVines(world, rand, x, y + 3, z, x, y + 5, z);
            if (!world.func_147437_c(x, y + 6, z)) {
                WorldGenPrimitive.setBlock(world, x, y + 7, z, Blocks.field_150355_j);
            }
            this.spawnHoleSet = true;
        }
    }
}

