/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.MetaBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public enum Door {
    IRON,
    WOOD;


    public static void generate(World world, int x, int y, int z, Cardinal dir, Door type) {
        Door.generate(world, x, y, z, dir, type, false);
    }

    public static void generate(World world, int x, int y, int z, Cardinal dir, Door type, boolean open) {
        MetaBlock doorBase = new MetaBlock(Door.getBlockId(type), Door.getMeta(false, dir, open, false));
        doorBase.setBlock(world, x, y, z);
        MetaBlock doorTop = new MetaBlock(Door.getBlockId(type), Door.getMeta(true, dir, open, false));
        doorTop.setBlock(world, x, y + 1, z);
    }

    private static Block getBlockId(Door type) {
        if (type == IRON) {
            return Blocks.field_150454_av;
        }
        return Blocks.field_150466_ao;
    }

    private static int getMeta(boolean top, Cardinal dir, boolean open, boolean hingeLeft) {
        int meta = 0;
        if (top) {
            if (hingeLeft) {
                ++meta;
            }
            return meta + 8;
        }
        if (open) {
            meta += 4;
        }
        switch (dir) {
            case WEST: {
                return meta;
            }
            case NORTH: {
                return meta + 1;
            }
            case EAST: {
                return meta + 2;
            }
            case SOUTH: {
                return meta + 3;
            }
        }
        return meta;
    }
}

