/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Log;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsWood
implements IDungeon {
    @Override
    public boolean generate(World world, Random rand, ITheme theme, int x, int y, int z) {
        int HEIGHT = 3;
        int WIDTH = rand.nextInt(2) + 2;
        int LENGTH = rand.nextInt(2) + 3;
        int woodType = rand.nextInt(Log.values().length);
        Log type = Log.values()[woodType];
        MetaBlock pillar = Log.getLog(type);
        MetaBlock planks = new MetaBlock(Blocks.field_150344_f, woodType);
        MetaBlock glowstone = new MetaBlock(Blocks.field_150426_aN);
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(world, rand, x - WIDTH, y, z - LENGTH, x + WIDTH, y + 3, z + LENGTH, air);
        WorldGenPrimitive.fillRectHollow(world, rand, x - WIDTH - 1, y - 1, z - LENGTH - 1, x + WIDTH + 1, y + 3 + 1, z + LENGTH + 1, planks, false, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - WIDTH, y, z - LENGTH, x - WIDTH, y + 3, z - LENGTH, pillar, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - WIDTH, y, z + LENGTH, x - WIDTH, y + 3, z + LENGTH, pillar, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + WIDTH, y, z - LENGTH, x + WIDTH, y + 3, z - LENGTH, pillar, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + WIDTH, y, z + LENGTH, x + WIDTH, y + 3, z + LENGTH, pillar, true, true);
        WorldGenPrimitive.setBlock(world, x - WIDTH + 1, y - 1, z - LENGTH + 1, glowstone);
        WorldGenPrimitive.setBlock(world, x - WIDTH + 1, y - 1, z + LENGTH - 1, glowstone);
        WorldGenPrimitive.setBlock(world, x + WIDTH - 1, y - 1, z - LENGTH + 1, glowstone);
        WorldGenPrimitive.setBlock(world, x + WIDTH - 1, y - 1, z + LENGTH - 1, glowstone);
        WorldGenPrimitive.setBlock(world, rand, x, y, z, planks, true, true);
        WorldGenPrimitive.setBlock(world, x, y + 1, z, Blocks.field_150414_aQ);
        ArrayList<Coord> space = new ArrayList<Coord>();
        space.add(new Coord(x - WIDTH, y, z - LENGTH + 1));
        space.add(new Coord(x - WIDTH, y, z + LENGTH - 1));
        space.add(new Coord(x + WIDTH, y, z - LENGTH + 1));
        space.add(new Coord(x + WIDTH, y, z + LENGTH - 1));
        TreasureChest.generate(world, rand, space, TreasureChest.FOOD);
        return true;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

