/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SegmentNetherStripes
extends SegmentBase {
    @Override
    protected void genWall(World world, Random rand, Cardinal dir, ITheme theme, int x, int y, int z) {
        MetaBlock step = theme.getSecondaryStair();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        Coord cursor = new Coord(x, y, z);
        cursor.add(dir, 2);
        WorldGenPrimitive.setBlock(world, rand, cursor, air, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(world, rand, cursor, air, true, true);
        cursor = new Coord(x, y, z);
        cursor.add(dir, 5);
        boolean isAir = world.func_147437_c(cursor.getX(), cursor.getY(), cursor.getZ());
        boolean isLava = rand.nextInt(5) == 0;
        MetaBlock slab = new MetaBlock((Block)Blocks.field_150333_U, 14);
        cursor = new Coord(x, y, z);
        cursor.add(dir, 2);
        WorldGenPrimitive.setBlock(world, rand, cursor, slab, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(world, rand, cursor, slab, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(world, rand, cursor, slab, true, true);
        for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
            Coord start = new Coord(x, y, z);
            start.add(dir, 3);
            Coord end = new Coord(start);
            start.add(orth, 1);
            start.add(Cardinal.UP, 3);
            end.add(Cardinal.DOWN, 2);
            if (isLava && !isAir) {
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, new MetaBlock(Blocks.field_150353_l), false, true);
            }
            step.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(orth), true));
            cursor = new Coord(x, y, z);
            cursor.add(dir, 2);
            cursor.add(orth, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, step, true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, step, true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, step, true, true);
            cursor.add(Cardinal.reverse(dir), 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, step, true, true);
        }
    }
}

