/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.catacomb.Catacomb;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.TreasureChestArmour;
import greymerk.roguelike.treasure.TreasureChestBlocks;
import greymerk.roguelike.treasure.TreasureChestEnchanting;
import greymerk.roguelike.treasure.TreasureChestFood;
import greymerk.roguelike.treasure.TreasureChestMusic;
import greymerk.roguelike.treasure.TreasureChestOre;
import greymerk.roguelike.treasure.TreasureChestPotions;
import greymerk.roguelike.treasure.TreasureChestSmithy;
import greymerk.roguelike.treasure.TreasureChestStarter;
import greymerk.roguelike.treasure.TreasureChestSupplies;
import greymerk.roguelike.treasure.TreasureChestTools;
import greymerk.roguelike.treasure.TreasureChestWeapons;
import greymerk.roguelike.worldgen.Coord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public enum TreasureChest {
    ARMOUR,
    WEAPONS,
    BLOCKS,
    ENCHANTING,
    FOOD,
    ORE,
    POTIONS,
    STARTER,
    TOOLS,
    SUPPLIES,
    SMITH,
    MUSIC;

    public static final List<TreasureChest> level0;
    public static final List<TreasureChest> level1;
    public static final List<TreasureChest> level2;
    public static final List<TreasureChest> level3;
    public static final List<TreasureChest> level4;

    public static void generate(World world, Random rand, int posX, int posY, int posZ) {
        TreasureChest.generate(world, rand, posX, posY, posZ, Catacomb.getLevel(posY), false);
    }

    public static void generate(World world, Random rand, int posX, int posY, int posZ, int level, boolean trapped) {
        TreasureChest type = TreasureChest.getChestType(rand, level);
        ITreasureChest chest = TreasureChest.getChest(type);
        chest.generate(world, rand, posX, posY, posZ, level, trapped);
    }

    public static void generate(World world, Random rand, int posX, int posY, int posZ, TreasureChest type) {
        TreasureChest.generate(world, rand, posX, posY, posZ, type, Catacomb.getLevel(posY), false);
    }

    public static void generate(World world, Random rand, Coord pos, TreasureChest type) {
        TreasureChest.generate(world, rand, pos.getX(), pos.getY(), pos.getZ(), type);
    }

    public static void generate(World world, Random rand, int posX, int posY, int posZ, TreasureChest type, int level, boolean trapped) {
        ITreasureChest chest = TreasureChest.getChest(type);
        chest.generate(world, rand, posX, posY, posZ, level, trapped);
    }

    public static void generate(World world, Random rand, List<Coord> space, TreasureChest type) {
        TreasureChest.createChests(world, rand, 1, space, new ArrayList<TreasureChest>(Arrays.asList(type)));
    }

    public static void createChests(World world, Random rand, int numChests, List<Coord> space) {
        TreasureChest.createChests(world, rand, numChests, space, false);
    }

    public static void createChests(World world, Random rand, int numChests, List<Coord> space, boolean trapped) {
        Collections.shuffle(space, rand);
        int count = 0;
        for (Coord block : space) {
            int z;
            int y;
            if (count == numChests) break;
            int x = block.getX();
            if (!TreasureChest.isValidChestSpace(world, x, y = block.getY(), z = block.getZ())) continue;
            TreasureChest.generate(world, rand, x, y, z, TreasureChest.getChestType(rand, Catacomb.getLevel(y)));
            ++count;
        }
    }

    public static void createChests(World world, Random rand, int numChests, List<Coord> space, List<TreasureChest> types) {
        Collections.shuffle(space, rand);
        int count = 0;
        for (Coord block : space) {
            int z;
            int y;
            if (count == numChests) break;
            int x = block.getX();
            if (!TreasureChest.isValidChestSpace(world, x, y = block.getY(), z = block.getZ())) continue;
            TreasureChest.generate(world, rand, x, y, z, types.get(rand.nextInt(types.size())));
            ++count;
        }
    }

    private static ITreasureChest getChest(TreasureChest type) {
        switch (type) {
            case ARMOUR: {
                return new TreasureChestArmour();
            }
            case WEAPONS: {
                return new TreasureChestWeapons();
            }
            case BLOCKS: {
                return new TreasureChestBlocks();
            }
            case ENCHANTING: {
                return new TreasureChestEnchanting();
            }
            case FOOD: {
                return new TreasureChestFood();
            }
            case ORE: {
                return new TreasureChestOre();
            }
            case POTIONS: {
                return new TreasureChestPotions();
            }
            case STARTER: {
                return new TreasureChestStarter();
            }
            case TOOLS: {
                return new TreasureChestTools();
            }
            case SUPPLIES: {
                return new TreasureChestSupplies();
            }
            case SMITH: {
                return new TreasureChestSmithy();
            }
            case MUSIC: {
                return new TreasureChestMusic();
            }
        }
        return new TreasureChestFood();
    }

    private static TreasureChest getChestType(Random rand, int level) {
        switch (level) {
            case 0: {
                if (rand.nextInt(30) == 0) {
                    return ENCHANTING;
                }
                if (rand.nextInt(10) == 0) {
                    return SUPPLIES;
                }
                return level0.get(rand.nextInt(level0.size()));
            }
            case 1: {
                if (rand.nextInt(20) == 0) {
                    return ENCHANTING;
                }
                return level1.get(rand.nextInt(level1.size()));
            }
            case 2: {
                if (rand.nextInt(10) == 0) {
                    return ENCHANTING;
                }
                return level2.get(rand.nextInt(level2.size()));
            }
            case 3: {
                if (rand.nextInt(10) == 0) {
                    return ENCHANTING;
                }
                return level3.get(rand.nextInt(level3.size()));
            }
            case 4: {
                if (rand.nextInt(10) == 0) {
                    return ENCHANTING;
                }
                return level4.get(rand.nextInt(level4.size()));
            }
        }
        return FOOD;
    }

    public static boolean isValidChestSpace(World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z)) {
            return false;
        }
        if (!world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a()) {
            return false;
        }
        if (world.func_147439_a(x - 1, y, z) == Blocks.field_150486_ae) {
            return false;
        }
        if (world.func_147439_a(x + 1, y, z) == Blocks.field_150486_ae) {
            return false;
        }
        if (world.func_147439_a(x, y, z - 1) == Blocks.field_150486_ae) {
            return false;
        }
        return world.func_147439_a(x, y, z + 1) != Blocks.field_150486_ae;
    }

    static {
        level0 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS, FOOD));
        level1 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS, FOOD));
        level2 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS));
        level3 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS));
        level4 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS));
    }
}

