/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ItemFood
extends ItemBase {
    public ItemFood(int weight, int level) {
        super(weight, level);
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        return ItemFood.getRandom(rand, level);
    }

    public static ItemStack getRandom(Random rand, int rank) {
        ItemNovelty[] items = new ItemNovelty[]{ItemNovelty.GINGER, ItemNovelty.GENERIKB, ItemNovelty.CLEO};
        if (rank > 0 && rand.nextInt(500) == 0) {
            return ItemNovelty.getItem(items[rand.nextInt(items.length)]);
        }
        return ItemFood.pickFood(rand, rank);
    }

    public static ItemStack getDessert(Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                return new ItemStack(Items.field_151105_aU);
            }
            case 1: {
                return new ItemStack(Items.field_151110_aK);
            }
            case 2: {
                return new ItemStack(Items.field_151117_aB);
            }
            case 3: {
                return new ItemStack(Items.field_151158_bO);
            }
        }
        return new ItemStack(Items.field_151106_aX);
    }

    private static ItemStack pickFood(Random rand, int level) {
        int quantity = 1 + rand.nextInt(2 + level);
        switch (level) {
            case 3: 
            case 4: {
                if (rand.nextInt(10) == 0) {
                    return new ItemStack(Items.field_151153_ao);
                }
                if (rand.nextInt(5) == 0) {
                    return new ItemStack(Items.field_151150_bK, quantity);
                }
            }
            case 2: {
                if (rand.nextInt(5) == 0) {
                    if (rand.nextBoolean()) {
                        return new ItemStack(Items.field_151157_am, quantity);
                    }
                    return new ItemStack(Items.field_151083_be, quantity);
                }
            }
            case 1: {
                if (rand.nextInt(10) == 0) {
                    return new ItemStack(Items.field_151127_ba, quantity);
                }
                if (rand.nextInt(5) == 0) {
                    if (rand.nextBoolean()) {
                        return new ItemStack(Items.field_151077_bg, quantity);
                    }
                    return new ItemStack(Items.field_151168_bH, quantity);
                }
            }
            case 0: {
                if (rand.nextInt(20) == 0) {
                    return new ItemStack(Items.field_151034_e, 1);
                }
                if (rand.nextInt(10) == 0) {
                    return new ItemStack(Items.field_151009_A);
                }
                if (rand.nextInt(5) != 0) break;
                return new ItemStack(Items.field_151101_aQ, quantity);
            }
        }
        return new ItemStack(Items.field_151025_P, quantity);
    }
}

